/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u0006H\u0000\u001a[\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\t*\u00020\n\"\u0014\b\u0001\u0010\b*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\u000b*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\u00a2\u0006\u0002\u0010\u0010\u001aU\u0010\u0011\u001a\u0002H\b\"\b\b\u0000\u0010\t*\u00020\u0012\"\b\b\u0001\u0010\u0013*\u00020\u0006\"\u0014\b\u0002\u0010\b*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\u000b*\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\u000b2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00130\r\u00a2\u0006\u0002\u0010\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\n\u001a5\u0010\u0017\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\n*\u0004\u0018\u00010\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\t0\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001b\u001a\u001b\u0010\u001c\u001a\u00020\u0001\"\b\b\u0000\u0010\t*\u00020\u001d*\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"getNameElementUnquoted", "", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "i", "", "getElementName", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "afterSiblingSkipping2", "Self", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/patterns/PsiElementPattern;", "skip", "Lcom/intellij/patterns/ElementPattern;", "", "pattern", "(Lcom/intellij/patterns/PsiElementPattern;Lcom/intellij/patterns/ElementPattern;Lcom/intellij/patterns/ElementPattern;)Lcom/intellij/patterns/PsiElementPattern;", "withHCLHost", "Lorg/intellij/terraform/hcl/psi/common/BaseExpression;", "H", "(Lcom/intellij/patterns/PsiElementPattern;Lcom/intellij/patterns/ElementPattern;)Lcom/intellij/patterns/PsiElementPattern;", "isInHCLFileWithInterpolations", "", "getParent", "aClass", "Ljava/lang/Class;", "strict", "(Lcom/intellij/psi/PsiElement;Ljava/lang/Class;Z)Lcom/intellij/psi/PsiElement;", "getNameOrText", "Lcom/intellij/psi/PsiNamedElement;", "(Lcom/intellij/psi/PsiNamedElement;)Ljava/lang/String;", "intellij.terraform"})
public final class UtilKt {
    @Nullable
    public static final String getNameElementUnquoted(@NotNull HCLBlock $this$getNameElementUnquoted, int i) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getNameElementUnquoted, (String)"<this>");
        HCLElement[] hCLElementArray = $this$getNameElementUnquoted.getNameElements();
        Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
        HCLElement[] elements = hCLElementArray;
        if (elements.length < i + 1) {
            return null;
        }
        HCLElement element = elements[i];
        if (element instanceof HCLIdentifier) {
            String string2 = ((HCLIdentifier)element).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else if (element instanceof HCLStringLiteral) {
            String string3 = ((HCLStringLiteral)element).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        } else if (element instanceof PsiNamedElement) {
            String string4 = ((PsiNamedElement)element).getName();
            string = string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getElementName(@NotNull HCLElement $this$getElementName) {
        Intrinsics.checkNotNullParameter((Object)$this$getElementName, (String)"<this>");
        HCLElement hCLElement = $this$getElementName;
        return hCLElement instanceof HCLProperty ? ((HCLProperty)$this$getElementName).getName() : (hCLElement instanceof HCLBlock ? (TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)$this$getElementName) ? UtilKt.getNameElementUnquoted((HCLBlock)$this$getElementName, 1) : (TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)$this$getElementName) || TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)$this$getElementName) ? UtilKt.getNameElementUnquoted((HCLBlock)$this$getElementName, 2) : null)) : null);
    }

    @NotNull
    public static final <T extends PsiElement, Self extends PsiElementPattern<T, Self>> Self afterSiblingSkipping2(@NotNull PsiElementPattern<T, Self> $this$afterSiblingSkipping2, @NotNull ElementPattern<? extends Object> skip, @NotNull ElementPattern<? extends PsiElement> pattern) {
        Intrinsics.checkNotNullParameter($this$afterSiblingSkipping2, (String)"<this>");
        Intrinsics.checkNotNullParameter(skip, (String)"skip");
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        ObjectPattern objectPattern = $this$afterSiblingSkipping2.with(new PatternCondition<T>(skip, pattern){
            final /* synthetic */ ElementPattern<? extends Object> $skip;
            final /* synthetic */ ElementPattern<? extends PsiElement> $pattern;
            {
                this.$skip = $skip;
                this.$pattern = $pattern;
                super("afterSiblingSkipping2");
            }

            public boolean accepts(T t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                for (PsiElement o = t.getPrevSibling(); o != null; o = o.getPrevSibling()) {
                    if (this.$skip.accepts((Object)o, context)) continue;
                    return this.$pattern.accepts((Object)o, context);
                }
                return false;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (Self)((PsiElementPattern)objectPattern);
    }

    @NotNull
    public static final <T extends BaseExpression, H extends HCLElement, Self extends PsiElementPattern<T, Self>> Self withHCLHost(@NotNull PsiElementPattern<T, Self> $this$withHCLHost, @NotNull ElementPattern<? super H> pattern) {
        Intrinsics.checkNotNullParameter($this$withHCLHost, (String)"<this>");
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        ObjectPattern objectPattern = $this$withHCLHost.with(new PatternCondition<T>(pattern){
            final /* synthetic */ ElementPattern<? super H> $pattern;
            {
                this.$pattern = $pattern;
                super("withHCLHost");
            }

            public boolean accepts(T t, ProcessingContext context) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(t);
                if (hCLElement == null) {
                    return false;
                }
                HCLElement host = hCLElement;
                return this.$pattern.accepts((Object)host);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        return (Self)((PsiElementPattern)objectPattern);
    }

    public static final boolean isInHCLFileWithInterpolations(@NotNull PsiElement $this$isInHCLFileWithInterpolations) {
        Intrinsics.checkNotNullParameter((Object)$this$isInHCLFileWithInterpolations, (String)"<this>");
        PsiFile file = $this$isInHCLFileWithInterpolations.getContainingFile();
        if (file == null) {
            Logger.getInstance((String)"#org.intellij.terraform.hcl.psi.util").warn("Cannot obtain 'containingFile' for element " + $this$isInHCLFileWithInterpolations);
            return false;
        }
        if (file.getContainingDirectory() == null) {
            file = InjectedLanguageManager.getInstance((Project)$this$isInHCLFileWithInterpolations.getProject()).getTopLevelFile($this$isInHCLFileWithInterpolations);
        }
        return file instanceof HCLFile && ((HCLFile)file).isInterpolationsAllowed();
    }

    @Nullable
    public static final <T extends PsiElement> T getParent(@Nullable PsiElement $this$getParent, @NotNull Class<T> aClass, boolean strict) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        if ($this$getParent == null) {
            return null;
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)$this$getParent, aClass, (boolean)strict);
    }

    public static /* synthetic */ PsiElement getParent$default(PsiElement psiElement, Class clazz, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return UtilKt.getParent(psiElement, clazz, bl);
    }

    @NotNull
    public static final <T extends PsiNamedElement> String getNameOrText(@NotNull T $this$getNameOrText) {
        Intrinsics.checkNotNullParameter($this$getNameOrText, (String)"<this>");
        String string = $this$getNameOrText.getName();
        if (string == null) {
            String string2 = ((PsiElement)$this$getNameOrText).getText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        }
        return string;
    }
}

