/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u000eH\u0000\u00a8\u0006\u0016"}, d2={"getTerraformModule", "Lorg/intellij/terraform/config/model/Module;", "element", "Lorg/intellij/terraform/hcl/psi/common/BaseExpression;", "getLocalDefinedVariables", "", "Lorg/intellij/terraform/config/model/Variable;", "getDefinedLocalsInModule", "", "getHclBlockForSelfContext", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "position", "getProvisionerOfResource", "host", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "getConnectionOfResource", "getPostConditionOfBlock", "getParentResourceBlock", "getResource", "getDataSource", "getContainingResourceOrDataSource", "getContainingResourceOrDataSourceOrModule", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLPsiUtil.kt\norg/intellij/terraform/hcl/psi/HCLPsiUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,306:1\n1563#2:307\n1634#2,3:308\n66#3,2:311\n66#3,2:313\n66#3,2:315\n66#3,2:317\n66#3,2:319\n66#3,2:321\n66#3,2:323\n*S KotlinDebug\n*F\n+ 1 HCLPsiUtil.kt\norg/intellij/terraform/hcl/psi/HCLPsiUtilKt\n*L\n232#1:307\n232#1:308,3\n241#1:311,2\n251#1:313,2\n260#1:315,2\n264#1:317,2\n269#1:319,2\n276#1:321,2\n287#1:323,2\n*E\n"})
public final class HCLPsiUtilKt {
    @Nullable
    public static final Module getTerraformModule(@NotNull BaseExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(element);
        if (hCLElement == null) {
            return null;
        }
        HCLElement host = hCLElement;
        return ExtensionsKt.getTerraformModule(host);
    }

    @NotNull
    public static final List<Variable> getLocalDefinedVariables(@NotNull BaseExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = HCLPsiUtilKt.getTerraformModule(element);
        if (object == null || (object = ((Module)object).getAllVariables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getDefinedLocalsInModule(@NotNull BaseExpression element) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = HCLPsiUtilKt.getTerraformModule(element);
        if (object != null && (object = ((Module)object).getAllLocals()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it.getFirst());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final HCLBlock getHclBlockForSelfContext(@NotNull BaseExpression position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(position);
        if (hCLElement == null) {
            return null;
        }
        HCLElement host = hCLElement;
        HCLBlock hCLBlock = HCLPsiUtilKt.getProvisionerOfResource(host);
        if (hCLBlock == null && (hCLBlock = HCLPsiUtilKt.getConnectionOfResource(host)) == null) {
            hCLBlock = HCLPsiUtilKt.getPostConditionOfBlock(host);
        }
        return hCLBlock;
    }

    @Nullable
    public static final HCLBlock getProvisionerOfResource(@NotNull HCLElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement $this$parentOfType_u24default$iv = host;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock provisioner = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(provisioner, 0);
        return Intrinsics.areEqual((Object)string, (Object)"connection") ? HCLPsiUtilKt.getProvisionerOfResource(provisioner) : (Intrinsics.areEqual((Object)string, (Object)"provisioner") ? HCLPsiUtilKt.getParentResourceBlock(provisioner) : null);
    }

    @Nullable
    public static final HCLBlock getConnectionOfResource(@NotNull HCLElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement $this$parentOfType_u24default$iv = host;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock connection = hCLBlock;
        return Intrinsics.areEqual((Object)UtilKt.getNameElementUnquoted(connection, 0), (Object)"connection") ? HCLPsiUtilKt.getParentResourceBlock(connection) : null;
    }

    @Nullable
    public static final HCLBlock getPostConditionOfBlock(@NotNull HCLElement host) {
        HCLBlock lifecycle;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        PsiElement $this$parentOfType_u24default$iv = host;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock postCondition = hCLBlock;
        if (!Intrinsics.areEqual((Object)UtilKt.getNameElementUnquoted(postCondition, 0), (Object)"postcondition")) {
            return null;
        }
        $this$parentOfType_u24default$iv = postCondition;
        withSelf$iv = false;
        $i$f$parentOfType = false;
        HCLBlock hCLBlock2 = lifecycle = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        if (!Intrinsics.areEqual((Object)(hCLBlock2 != null ? UtilKt.getNameElementUnquoted(hCLBlock2, 0) : null), (Object)"lifecycle")) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv2 = lifecycle;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        HCLBlock resourceOrData = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, HCLBlock.class, (boolean)true);
        return TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)resourceOrData) || TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)resourceOrData) ? resourceOrData : null;
    }

    @Nullable
    public static final HCLBlock getParentResourceBlock(@NotNull HCLElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLBlock resource = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        return TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)resource) ? resource : null;
    }

    @Nullable
    public static final HCLBlock getResource(@NotNull BaseExpression position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(position);
        if (hCLElement == null) {
            return null;
        }
        HCLElement host = hCLElement;
        return HCLPsiUtilKt.getParentResourceBlock(host);
    }

    @Nullable
    public static final HCLBlock getDataSource(@NotNull BaseExpression position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost(position);
        if (hCLElement == null) {
            return null;
        }
        HCLElement host = hCLElement;
        PsiElement $this$parentOfType_u24default$iv = host;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HCLBlock dataSource = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HCLBlock.class, (boolean)true);
        return TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)dataSource) ? dataSource : null;
    }

    @Nullable
    public static final HCLBlock getContainingResourceOrDataSource(@Nullable HCLElement element) {
        if (element == null) {
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, arg_0 -> HCLPsiUtilKt.getContainingResourceOrDataSource$lambda$2(HCLPsiUtilKt::getContainingResourceOrDataSource$lambda$1, arg_0));
        return psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
    }

    @Nullable
    public static final HCLBlock getContainingResourceOrDataSourceOrModule(@Nullable HCLElement element) {
        if (element == null) {
            return null;
        }
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, arg_0 -> HCLPsiUtilKt.getContainingResourceOrDataSourceOrModule$lambda$4(HCLPsiUtilKt::getContainingResourceOrDataSourceOrModule$lambda$3, arg_0));
        return psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
    }

    private static final boolean getContainingResourceOrDataSource$lambda$1(PsiElement it) {
        return TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)it) || TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)it);
    }

    private static final boolean getContainingResourceOrDataSource$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getContainingResourceOrDataSourceOrModule$lambda$3(PsiElement it) {
        return TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)it) || TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)it) || TfPsiPatterns.INSTANCE.getModuleRootBlock().accepts((Object)it);
    }

    private static final boolean getContainingResourceOrDataSourceOrModule$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

