/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/terraform/hcl/formatter/HCLLanguageCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "getLanguage", "getCodeSample", "", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "customizeDefaults", "", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "customizeSettings", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "Companion", "intellij.terraform"})
public class HCLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    public static final String SAMPLE = "\n    name = value\n    block 'name' {\n      long_array = [ 'a', 100, \"b\", 1234567890, 1234567890, 1234567890, 1234567890, 10e100, true, false ]\n      arr = []\n      empty_object = {}\n      one_line_object = { something : \"Yep!\", other : \"Nope!\" }\n      object = { \n        yeah : \"Yay\"\n        meh : \"Nein\" \n      }\n    }\n    some_object = {\n      echo = true\n    }\n    ";

    public HCLLanguageCodeStyleSettingsProvider(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    public /* synthetic */ HCLLanguageCodeStyleSettingsProvider(Language language, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            language = HCLLanguage.INSTANCE;
        }
        this(language);
    }

    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return SAMPLE;
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        indentOptions.INDENT_SIZE = 2;
        commonSettings.LINE_COMMENT_ADD_SPACE_IN_SUPPRESSION = true;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_BRACES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_AROUND_ASSIGNMENT_OPERATORS"};
                consumer.showStandardOptions(stringArray);
                consumer.renameStandardOption("SPACE_WITHIN_BRACES", HCLBundle.message("hcl.code.style.settings.braces", new Object[0]));
                consumer.renameStandardOption("SPACE_AROUND_ASSIGNMENT_OPERATORS", HCLBundle.message("hcl.code.style.settings.equals", new Object[0]));
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"KEEP_BLANK_LINES_IN_CODE"};
                consumer.showStandardOptions(stringArray);
                break;
            }
            case 3: {
                Object[] objectArray = new String[]{"RIGHT_MARGIN", "KEEP_LINE_BREAKS", "WRAP_LONG_LINES"};
                consumer.showStandardOptions((String[])objectArray);
                objectArray = new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES};
                consumer.showCustomOption(HclCodeStyleSettings.class, "ARRAY_WRAPPING", HCLBundle.message("hcl.code.style.settings.arrays", new Object[0]), null, objectArray);
                objectArray = new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES};
                consumer.showCustomOption(HclCodeStyleSettings.class, "OBJECT_WRAPPING", HCLBundle.message("hcl.code.style.settings.objects", new Object[0]), null, objectArray);
            }
        }
    }

    public HCLLanguageCodeStyleSettingsProvider() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/terraform/hcl/formatter/HCLLanguageCodeStyleSettingsProvider$Companion;", "", "<init>", "()V", "SAMPLE", "", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

