/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLParserDefinitionKt;
import org.intellij.terraform.hcl.findUsages.HCLWordsScanner;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0015\u0010\u000e\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0012\u001a\u00070\u000b\u00a2\u0006\u0002\b\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0002J\u0015\u0010\u0014\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0015\u0010\u0017\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0015\u0010\u001a\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00152\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/hcl/findUsages/HCLFindUsagesProvider;", "Lcom/intellij/lang/findUsages/FindUsagesProvider;", "<init>", "()V", "getWordsScanner", "Lcom/intellij/lang/cacheBuilder/WordsScanner;", "canFindUsagesFor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getHelpId", "", "getType", "element", "getBlockType", "Lcom/intellij/openapi/util/NlsSafe;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getRootBlockType", "type", "getPropertyType", "Lorg/jetbrains/annotations/Nls;", "property", "getIdentifierType", "identifier", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "getDefaultType", "getDescriptiveName", "getNodeText", "useFullName", "intellij.terraform"})
public class HCLFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return (WordsScanner)new HCLWordsScanner(HCLParserDefinitionKt.createHclLexer());
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!(psiElement instanceof PsiNamedElement) || !(psiElement instanceof HCLElement)) {
            return false;
        }
        if (psiElement instanceof HCLIdentifier) {
            boolean isDynamicIterator = HCLPsiUtil.INSTANCE.isPropertyValue(psiElement) && TfPsiPatterns.INSTANCE.getDynamicBlockIterator().accepts((Object)((HCLIdentifier)psiElement).getParent());
            boolean isForVariable = TfPsiPatterns.INSTANCE.getForVariable().accepts((Object)psiElement);
            if (isDynamicIterator || isForVariable) {
                return true;
            }
        }
        return !TfPsiPatterns.INSTANCE.getLocalsRootBlock().accepts((Object)psiElement) && !TfPsiPatterns.INSTANCE.getTerraformRootBlock().accepts((Object)psiElement);
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!TfPsiPatterns.INSTANCE.getTerraformFile().accepts((Object)element.getContainingFile())) {
            return this.getDefaultType(element);
        }
        PsiElement psiElement = element;
        return psiElement instanceof HCLBlock ? this.getBlockType((HCLBlock)element) : (psiElement instanceof HCLProperty ? this.getPropertyType(element) : (psiElement instanceof HCLIdentifier ? this.getIdentifierType((HCLIdentifier)element) : this.getDefaultType(element)));
    }

    private final String getBlockType(HCLBlock block) {
        String string;
        String type = UtilKt.getNameElementUnquoted(block, 0);
        if (TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)block)) {
            string = this.getRootBlockType(type);
        } else if (TfPsiPatterns.INSTANCE.getBackend().accepts((Object)block)) {
            String string2 = HCLBundle.message("HCLFindUsagesProvider.type.backend.configuration", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            string = String.valueOf(type);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String getRootBlockType(String type) {
        String string;
        String string2 = type;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case -1005512447: {
                    if (!string2.equals("output")) break;
                    n = 1;
                    break;
                }
                case 3076010: {
                    if (!string2.equals("data")) break;
                    n = 2;
                    break;
                }
                case -987494927: {
                    if (!string2.equals("provider")) break;
                    n = 3;
                    break;
                }
                case -341064690: {
                    if (!string2.equals("resource")) break;
                    n = 4;
                    break;
                }
                case -1068784020: {
                    if (!string2.equals("module")) break;
                    n = 5;
                    break;
                }
                case -1249586564: {
                    if (!string2.equals("variable")) break;
                    n = 6;
                    break;
                }
                case -2123444524: {
                    if (!string2.equals("terraform")) break;
                    n = 7;
                    break;
                }
                case -1097462168: {
                    if (!string2.equals("locals")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 5: {
                    String string3 = HCLBundle.message("HCLFindUsagesProvider.type.module", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    return string;
                }
                case 6: {
                    String string4 = HCLBundle.message("HCLFindUsagesProvider.type.variable", new Object[0]);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    return string;
                }
                case 1: {
                    String string5 = HCLBundle.message("HCLFindUsagesProvider.type.output.value", new Object[0]);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    return string;
                }
                case 3: {
                    String string6 = HCLBundle.message("HCLFindUsagesProvider.type.provider", new Object[0]);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                    return string;
                }
                case 4: {
                    String string7 = HCLBundle.message("HCLFindUsagesProvider.type.resource", new Object[0]);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                    return string;
                }
                case 2: {
                    String string8 = HCLBundle.message("HCLFindUsagesProvider.type.data.source", new Object[0]);
                    string = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
                    return string;
                }
                case 7: {
                    String string9 = HCLBundle.message("HCLFindUsagesProvider.type.terraform.configuration", new Object[0]);
                    string = string9;
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
                    return string;
                }
                case 8: {
                    String string10 = HCLBundle.message("HCLFindUsagesProvider.type.local.values", new Object[0]);
                    string = string10;
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
                    return string;
                }
            }
        }
        string = String.valueOf(type);
        return string;
    }

    private final String getPropertyType(PsiElement property) {
        String string;
        if (TfPsiPatterns.INSTANCE.getLocalsVariable().accepts((Object)property)) {
            String string2 = HCLBundle.message("HCLFindUsagesProvider.type.local.value", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = HCLBundle.message("HCLFindUsagesProvider.type.property", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final String getIdentifierType(HCLIdentifier identifier) {
        String string;
        if (HCLPsiUtil.INSTANCE.isPropertyValue(identifier) && TfPsiPatterns.INSTANCE.getDynamicBlockIterator().accepts((Object)identifier.getParent())) {
            String string2 = HCLBundle.message("HCLFindUsagesProvider.type.dynamic.iterator", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (TfPsiPatterns.INSTANCE.getForVariable().accepts((Object)identifier)) {
            String string3 = HCLBundle.message("HCLFindUsagesProvider.type.for.loop.variable", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (identifier.getParent() instanceof HCLProperty) {
            PsiElement psiElement = identifier.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getParent(...)");
            string = this.getPropertyType(psiElement);
        } else {
            string = this.getDefaultType(identifier);
        }
        return string;
    }

    private final String getDefaultType(PsiElement element) {
        String string;
        PsiElement psiElement = element;
        if (psiElement instanceof HCLBlock) {
            Object[] objectArray = new Object[]{UtilKt.getNameElementUnquoted((HCLBlock)element, 0)};
            String string2 = HCLBundle.message("HCLFindUsagesProvider.type.named.block", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (psiElement instanceof HCLProperty) {
            String string3 = HCLBundle.message("HCLFindUsagesProvider.type.property", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else if (psiElement instanceof PsiNamedElement) {
            Object[] objectArray = new Object[]{element.getClass().getName()};
            String string4 = HCLBundle.message("HCLFindUsagesProvider.type.untyped.named.element", objectArray);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{element.getNode().getElementType()};
            String string5 = HCLBundle.message("HCLFindUsagesProvider.type.untyped.non.psi.named.element", objectArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : null;
        Object object = name;
        if (object == null) {
            object = "<Not An PsiNamedElement " + element.getNode().getElementType() + ">";
        }
        return object;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (useFullName && element instanceof HCLBlock) {
            String string = ((HCLBlock)element).getFullName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullName(...)");
            return string;
        }
        return this.getDescriptiveName(element);
    }
}

