/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J.\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0014J,\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u001d2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\""}, d2={"Lorg/intellij/terraform/hcl/editor/HCLFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isRegionCollapsedByDefault", "", "node", "Lcom/intellij/lang/ASTNode;", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "collect", "element", "usedComments", "", "getCollapsedObjectPlaceholder", "", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "limit", "", "getCollapsedArrayPlaceholder", "Lorg/intellij/terraform/hcl/psi/HCLArray;", "getLanguagePlaceholderText", "range", "Lcom/intellij/openapi/util/TextRange;", "isSpanMultipleLines", "intellij.terraform"})
public final class HCLFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return false;
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.collect(root, descriptors, new HashSet());
    }

    private final void collect(PsiElement element, List<FoldingDescriptor> descriptors, Set<PsiElement> usedComments) {
        ASTNode node = element.getNode();
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.OBJECT) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.BLOCK_OBJECT)) {
            Intrinsics.checkNotNull((Object)node);
            if (this.isSpanMultipleLines(node) && element instanceof HCLObject) {
                int props = ((HCLObject)element).getPropertyList().size();
                int blocks = ((HCLObject)element).getBlockList().size();
                switch (props + blocks) {
                    case 0: 
                    case 1: {
                        boolean bl = descriptors.add(new FoldingDescriptor(node, node.getTextRange(), null, HCLFoldingBuilder.getCollapsedObjectPlaceholder$default(this, (HCLObject)element, 0, 2, null)));
                        break;
                    }
                    default: {
                        boolean bl = descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.ARRAY)) {
            Intrinsics.checkNotNull((Object)node);
            if (this.isSpanMultipleLines(node) && element instanceof HCLArray) {
                switch (((HCLArray)element).getElements().size()) {
                    case 0: 
                    case 1: {
                        boolean bl = descriptors.add(new FoldingDescriptor(node, node.getTextRange(), null, HCLFoldingBuilder.getCollapsedArrayPlaceholder$default(this, (HCLArray)element, 0, 2, null)));
                        break;
                    }
                    default: {
                        boolean bl = descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.BLOCK_COMMENT)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_C_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_HASH_COMMENT)) && usedComments.add(element) && !CustomFoldingBuilder.isCustomRegionElement((PsiElement)element)) {
            PsiElement end = null;
            PsiElement current = HCLPsiUtil.getNextSiblingNonWhiteSpace(element);
            while (current != null && HCLTokenTypes.HCL_LINE_COMMENTS.contains(current.getNode().getElementType())) {
                if (CustomFoldingBuilder.isCustomRegionElement((PsiElement)current)) {
                    usedComments.add(current);
                    break;
                }
                end = current;
                usedComments.add(current);
                current = HCLPsiUtil.getNextSiblingNonWhiteSpace(current);
            }
            if (end != null) {
                TextRange range = new TextRange(element.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
                descriptors.add(new FoldingDescriptor(element, range));
            }
        }
        HashSet childUsedCommends = new HashSet();
        for (PsiElement c : element.getChildren()) {
            this.collect(c, descriptors, childUsedCommends);
        }
    }

    private final String getCollapsedObjectPlaceholder(HCLObject element, int limit) {
        int blocks;
        int props = element.getPropertyList().size();
        if (props + (blocks = element.getBlockList().size()) == 0) {
            return "{}";
        }
        if (props + blocks != 1) {
            return "{...}";
        }
        List<HCLProperty> list = element.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
        HCLProperty prop = (HCLProperty)CollectionsKt.firstOrNull(list);
        if (prop != null) {
            if (prop.getTextLength() > limit) {
                return "{...}";
            }
            return "{" + prop.getText() + "}";
        }
        List<HCLBlock> list2 = element.getBlockList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBlockList(...)");
        HCLBlock bl = (HCLBlock)CollectionsKt.firstOrNull(list2);
        if (bl != null) {
            if (bl.getName().length() > limit) {
                return "{...}";
            }
            HCLObject hCLObject = bl.getObject();
            if (hCLObject == null) {
                return "{...}";
            }
            HCLObject obj = hCLObject;
            String inner = this.getCollapsedObjectPlaceholder(obj, limit - (bl.getName().length() + 3));
            return "{" + bl.getName() + " " + inner + "}";
        }
        return "{}";
    }

    static /* synthetic */ String getCollapsedObjectPlaceholder$default(HCLFoldingBuilder hCLFoldingBuilder, HCLObject hCLObject, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        return hCLFoldingBuilder.getCollapsedObjectPlaceholder(hCLObject, n);
    }

    private final String getCollapsedArrayPlaceholder(HCLArray element, int limit) {
        List<HCLExpression> list = element.getElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
        List<HCLExpression> vals = list;
        if (vals.isEmpty()) {
            return "[]";
        }
        if (vals.size() > 1) {
            return "[...]";
        }
        ASTNode node = ((HCLExpression)CollectionsKt.first(vals)).getNode();
        if (node.getTextLength() > limit) {
            return "[...]";
        }
        return "[" + node.getText() + "]";
    }

    static /* synthetic */ String getCollapsedArrayPlaceholder$default(HCLFoldingBuilder hCLFoldingBuilder, HCLArray hCLArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        return hCLFoldingBuilder.getCollapsedArrayPlaceholder(hCLArray, n);
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.ARRAY) ? "[...]" : (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.OBJECT) ? "{...}" : (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.BLOCK_OBJECT) ? "{...}" : (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.BLOCK_COMMENT) ? "/*...*/" : (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_C_COMMENT) ? "//..." : (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_HASH_COMMENT) ? "#..." : "...")))));
    }

    private final boolean isSpanMultipleLines(ASTNode node) {
        return node.textContains('\n') || node.textContains('\r');
    }
}

