/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/hcl/HCLSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "lexer", "Lorg/intellij/terraform/hcl/HCLLexer;", "<init>", "(Lorg/intellij/terraform/hcl/HCLLexer;)V", "getLexer", "()Lorg/intellij/terraform/hcl/HCLLexer;", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "Companion", "intellij.terraform"})
public final class HCLSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HCLLexer lexer;
    @NotNull
    private static final TextAttributesKey HCL_BRACKETS;
    @NotNull
    private static final TextAttributesKey HCL_BRACES;
    @NotNull
    private static final TextAttributesKey HCL_COMMA;
    @NotNull
    private static final TextAttributesKey HCL_OPERATION_SIGN;
    @NotNull
    private static final TextAttributesKey HCL_NUMBER;
    @NotNull
    private static final TextAttributesKey HCL_STRING;
    @NotNull
    private static final TextAttributesKey HCL_KEYWORD;
    @NotNull
    private static final TextAttributesKey HCL_LINE_COMMENT;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_COMMENT;
    @NotNull
    private static final TextAttributesKey HCL_IDENTIFIER;
    @NotNull
    private static final TextAttributesKey HCL_PROPERTY_KEY;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_FIRST_TYPE_KEY;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_SECOND_TYPE_KEY;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_OTHER_TYPES_KEY;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_NAME_KEY;
    @NotNull
    private static final TextAttributesKey HCL_BLOCK_ONLY_NAME_KEY;
    @NotNull
    private static final TextAttributesKey HCL_VALID_ESCAPE;
    @NotNull
    private static final TextAttributesKey HCL_INVALID_ESCAPE;

    public HCLSyntaxHighlighter(@NotNull HCLLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)((Object)lexer), (String)"lexer");
        this.lexer = lexer;
    }

    @NotNull
    public final HCLLexer getLexer() {
        return this.lexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@Nullable IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray;
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.L_CURLY) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.R_CURLY)) {
            TextAttributesKey[] textAttributesKeyArray2 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_BRACES);
            textAttributesKeyArray = textAttributesKeyArray2;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray2, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.L_BRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.R_BRACKET)) {
            TextAttributesKey[] textAttributesKeyArray3 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_BRACKETS);
            textAttributesKeyArray = textAttributesKeyArray3;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray3, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.COMMA)) {
            TextAttributesKey[] textAttributesKeyArray4 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_COMMA);
            textAttributesKeyArray = textAttributesKeyArray4;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray4, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.EQUALS)) {
            TextAttributesKey[] textAttributesKeyArray5 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_OPERATION_SIGN);
            textAttributesKeyArray = textAttributesKeyArray5;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray5, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.DOUBLE_QUOTED_STRING) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.SINGLE_QUOTED_STRING)) {
            TextAttributesKey[] textAttributesKeyArray6 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_STRING);
            textAttributesKeyArray = textAttributesKeyArray6;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray6, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.NUMBER)) {
            TextAttributesKey[] textAttributesKeyArray7 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_NUMBER);
            textAttributesKeyArray = textAttributesKeyArray7;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray7, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.TRUE) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.FALSE) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.NULL)) {
            TextAttributesKey[] textAttributesKeyArray8 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_KEYWORD);
            textAttributesKeyArray = textAttributesKeyArray8;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray8, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_C_COMMENT) || Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.LINE_HASH_COMMENT)) {
            TextAttributesKey[] textAttributesKeyArray9 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_LINE_COMMENT);
            textAttributesKeyArray = textAttributesKeyArray9;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray9, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.BLOCK_COMMENT)) {
            TextAttributesKey[] textAttributesKeyArray10 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_BLOCK_COMMENT);
            textAttributesKeyArray = textAttributesKeyArray10;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray10, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)HCLElementTypes.ID)) {
            TextAttributesKey[] textAttributesKeyArray11 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_IDENTIFIER);
            textAttributesKeyArray = textAttributesKeyArray11;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray11, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER)) {
            TextAttributesKey[] textAttributesKeyArray12 = SyntaxHighlighterBase.pack((TextAttributesKey)HighlighterColors.BAD_CHARACTER);
            textAttributesKeyArray = textAttributesKeyArray12;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray12, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
            TextAttributesKey[] textAttributesKeyArray13 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_VALID_ESCAPE);
            textAttributesKeyArray = textAttributesKeyArray13;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray13, (String)"pack(...)");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) || Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
            TextAttributesKey[] textAttributesKeyArray14 = SyntaxHighlighterBase.pack((TextAttributesKey)HCL_INVALID_ESCAPE);
            textAttributesKeyArray = textAttributesKeyArray14;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray14, (String)"pack(...)");
        } else {
            textAttributesKeyArray = new TextAttributesKey[]{};
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        LayeredLexer layeredLexer = new LayeredLexer((Lexer)this.lexer);
        IElementType[] iElementTypeArray = new IElementType[]{HCLElementTypes.DOUBLE_QUOTED_STRING};
        layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', HCLElementTypes.DOUBLE_QUOTED_STRING, false, "/vaUX", true, false), iElementTypeArray, IElementType.EMPTY_ARRAY);
        iElementTypeArray = new IElementType[]{HCLElementTypes.SINGLE_QUOTED_STRING};
        layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', HCLElementTypes.SINGLE_QUOTED_STRING, false, "/vaUX", true, false), iElementTypeArray, IElementType.EMPTY_ARRAY);
        return (Lexer)layeredLexer;
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"HCL.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        HCL_BRACKETS = textAttributesKey;
        TextAttributesKey textAttributesKey2 = TextAttributesKey.createTextAttributesKey((String)"HCL.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"createTextAttributesKey(...)");
        HCL_BRACES = textAttributesKey2;
        TextAttributesKey textAttributesKey3 = TextAttributesKey.createTextAttributesKey((String)"HCL.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"createTextAttributesKey(...)");
        HCL_COMMA = textAttributesKey3;
        TextAttributesKey textAttributesKey4 = TextAttributesKey.createTextAttributesKey((String)"HCL.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey4, (String)"createTextAttributesKey(...)");
        HCL_OPERATION_SIGN = textAttributesKey4;
        TextAttributesKey textAttributesKey5 = TextAttributesKey.createTextAttributesKey((String)"HCL.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey5, (String)"createTextAttributesKey(...)");
        HCL_NUMBER = textAttributesKey5;
        TextAttributesKey textAttributesKey6 = TextAttributesKey.createTextAttributesKey((String)"HCL.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey6, (String)"createTextAttributesKey(...)");
        HCL_STRING = textAttributesKey6;
        TextAttributesKey textAttributesKey7 = TextAttributesKey.createTextAttributesKey((String)"HCL.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey7, (String)"createTextAttributesKey(...)");
        HCL_KEYWORD = textAttributesKey7;
        TextAttributesKey textAttributesKey8 = TextAttributesKey.createTextAttributesKey((String)"HCL.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey8, (String)"createTextAttributesKey(...)");
        HCL_LINE_COMMENT = textAttributesKey8;
        TextAttributesKey textAttributesKey9 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey9, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_COMMENT = textAttributesKey9;
        TextAttributesKey textAttributesKey10 = TextAttributesKey.createTextAttributesKey((String)"HCL.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey10, (String)"createTextAttributesKey(...)");
        HCL_IDENTIFIER = textAttributesKey10;
        TextAttributesKey textAttributesKey11 = TextAttributesKey.createTextAttributesKey((String)"HCL.PROPERTY_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey11, (String)"createTextAttributesKey(...)");
        HCL_PROPERTY_KEY = textAttributesKey11;
        TextAttributesKey textAttributesKey12 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_FIRST_TYPE_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey12, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_FIRST_TYPE_KEY = textAttributesKey12;
        TextAttributesKey textAttributesKey13 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_SECOND_TYPE_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey13, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_SECOND_TYPE_KEY = textAttributesKey13;
        TextAttributesKey textAttributesKey14 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_TYPES_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey14, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_OTHER_TYPES_KEY = textAttributesKey14;
        TextAttributesKey textAttributesKey15 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_NAME_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey15, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_NAME_KEY = textAttributesKey15;
        TextAttributesKey textAttributesKey16 = TextAttributesKey.createTextAttributesKey((String)"HCL.BLOCK_ONLY_NAME_KEY", (TextAttributesKey)HCL_BLOCK_FIRST_TYPE_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey16, (String)"createTextAttributesKey(...)");
        HCL_BLOCK_ONLY_NAME_KEY = textAttributesKey16;
        TextAttributesKey textAttributesKey17 = TextAttributesKey.createTextAttributesKey((String)"HCL.VALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey17, (String)"createTextAttributesKey(...)");
        HCL_VALID_ESCAPE = textAttributesKey17;
        TextAttributesKey textAttributesKey18 = TextAttributesKey.createTextAttributesKey((String)"HCL.INVALID_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey18, (String)"createTextAttributesKey(...)");
        HCL_INVALID_ESCAPE = textAttributesKey18;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b%\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0007R\u0011\u0010$\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0007R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007\u00a8\u0006*"}, d2={"Lorg/intellij/terraform/hcl/HCLSyntaxHighlighter$Companion;", "", "<init>", "()V", "HCL_BRACKETS", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHCL_BRACKETS", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "HCL_BRACES", "getHCL_BRACES", "HCL_COMMA", "getHCL_COMMA", "HCL_OPERATION_SIGN", "getHCL_OPERATION_SIGN", "HCL_NUMBER", "getHCL_NUMBER", "HCL_STRING", "getHCL_STRING", "HCL_KEYWORD", "getHCL_KEYWORD", "HCL_LINE_COMMENT", "getHCL_LINE_COMMENT", "HCL_BLOCK_COMMENT", "getHCL_BLOCK_COMMENT", "HCL_IDENTIFIER", "getHCL_IDENTIFIER", "HCL_PROPERTY_KEY", "getHCL_PROPERTY_KEY", "HCL_BLOCK_FIRST_TYPE_KEY", "getHCL_BLOCK_FIRST_TYPE_KEY", "HCL_BLOCK_SECOND_TYPE_KEY", "getHCL_BLOCK_SECOND_TYPE_KEY", "HCL_BLOCK_OTHER_TYPES_KEY", "getHCL_BLOCK_OTHER_TYPES_KEY", "HCL_BLOCK_NAME_KEY", "getHCL_BLOCK_NAME_KEY", "HCL_BLOCK_ONLY_NAME_KEY", "getHCL_BLOCK_ONLY_NAME_KEY", "HCL_VALID_ESCAPE", "getHCL_VALID_ESCAPE", "HCL_INVALID_ESCAPE", "getHCL_INVALID_ESCAPE", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextAttributesKey getHCL_BRACKETS() {
            return HCL_BRACKETS;
        }

        @NotNull
        public final TextAttributesKey getHCL_BRACES() {
            return HCL_BRACES;
        }

        @NotNull
        public final TextAttributesKey getHCL_COMMA() {
            return HCL_COMMA;
        }

        @NotNull
        public final TextAttributesKey getHCL_OPERATION_SIGN() {
            return HCL_OPERATION_SIGN;
        }

        @NotNull
        public final TextAttributesKey getHCL_NUMBER() {
            return HCL_NUMBER;
        }

        @NotNull
        public final TextAttributesKey getHCL_STRING() {
            return HCL_STRING;
        }

        @NotNull
        public final TextAttributesKey getHCL_KEYWORD() {
            return HCL_KEYWORD;
        }

        @NotNull
        public final TextAttributesKey getHCL_LINE_COMMENT() {
            return HCL_LINE_COMMENT;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_COMMENT() {
            return HCL_BLOCK_COMMENT;
        }

        @NotNull
        public final TextAttributesKey getHCL_IDENTIFIER() {
            return HCL_IDENTIFIER;
        }

        @NotNull
        public final TextAttributesKey getHCL_PROPERTY_KEY() {
            return HCL_PROPERTY_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_FIRST_TYPE_KEY() {
            return HCL_BLOCK_FIRST_TYPE_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_SECOND_TYPE_KEY() {
            return HCL_BLOCK_SECOND_TYPE_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_OTHER_TYPES_KEY() {
            return HCL_BLOCK_OTHER_TYPES_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_NAME_KEY() {
            return HCL_BLOCK_NAME_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_BLOCK_ONLY_NAME_KEY() {
            return HCL_BLOCK_ONLY_NAME_KEY;
        }

        @NotNull
        public final TextAttributesKey getHCL_VALID_ESCAPE() {
            return HCL_VALID_ESCAPE;
        }

        @NotNull
        public final TextAttributesKey getHCL_INVALID_ESCAPE() {
            return HCL_INVALID_ESCAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

