/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.hcl;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.hcl.HCLCapability;
import org.intellij.terraform.hcl._HCLLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/hcl/HCLLexer;", "Lcom/intellij/lexer/FlexAdapter;", "capabilities", "Ljava/util/EnumSet;", "Lorg/intellij/terraform/hcl/HCLCapability;", "<init>", "(Ljava/util/EnumSet;)V", "getFlex", "Lorg/intellij/terraform/hcl/_HCLLexer;", "start", "", "buffer", "", "startOffset", "", "endOffset", "state", "isLexerInHereDocLineState", "", "isLexerInStringOrHILState", "getState", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLLexer.kt\norg/intellij/terraform/hcl/HCLLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class HCLLexer
extends FlexAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnumSet<HCLCapability> capabilities;
    private static final int STRING_START_MASK = -65536;
    private static final int IN_SINGLE_QUOTED_STRING = 32768;
    private static final int IN_STRING = 16384;
    private static final int HIL_MASK = 16128;
    private static final int HEREDOC_MARKER_LENGTH = 32512;
    private static final int HEREDOC_MARKER_INDENTED = 32768;
    private static final int HEREDOC_MARKER_WEAK_HASH = -65536;
    private static final int JFLEX_STATE_MASK = 255;

    public HCLLexer(@NotNull EnumSet<HCLCapability> capabilities) {
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        super((FlexLexer)new _HCLLexer(capabilities));
        this.capabilities = capabilities;
    }

    public /* synthetic */ HCLLexer(EnumSet enumSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            EnumSet<HCLCapability> enumSet2 = EnumSet.noneOf(HCLCapability.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(...)");
            enumSet = enumSet2;
        }
        this(enumSet);
    }

    @NotNull
    public _HCLLexer getFlex() {
        FlexLexer flexLexer = super.getFlex();
        Intrinsics.checkNotNull((Object)flexLexer, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl._HCLLexer");
        return (_HCLLexer)flexLexer;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        _HCLLexer lexer = this.getFlex();
        if (this.isLexerInHereDocLineState(state)) {
            lexer.myHereDocMarkerLength = (state & 0x7F00) >>> 8;
            lexer.myHereDocIndented = (state & 0x8000) != 0;
            lexer.myHereDocMarkerWeakHash = (state & HEREDOC_MARKER_WEAK_HASH) >>> 16;
        } else if (this.capabilities.contains((Object)HCLCapability.INTERPOLATION_LANGUAGE)) {
            if (!this.isLexerInStringOrHILState(state) || (state & 0x4000) == 0) {
                lexer.stringType = _HCLLexer.StringType.None;
                lexer.stringStart = -1;
                lexer.hil = 0;
            } else {
                lexer.stringType = (state & 0x8000) == 0 ? _HCLLexer.StringType.DoubleQ : _HCLLexer.StringType.SingleQ;
                lexer.stringStart = (state & 0xFFFF0000) >>> 16;
                lexer.hil = (state & 0x3F00) >>> 8;
            }
        }
        super.start(buffer, startOffset, endOffset, state & 0xFF);
    }

    private final boolean isLexerInHereDocLineState(int state) {
        return (state & 0xFF) == 10;
    }

    private final boolean isLexerInStringOrHILState(int state) {
        return switch (state & 0xFF) {
            case 4 -> true;
            case 2 -> true;
            case 6 -> true;
            default -> false;
        };
    }

    public int getState() {
        boolean bl;
        _HCLLexer lexer = this.getFlex();
        int state = super.getState();
        boolean bl2 = bl = (state & 0xFFFFFF00) == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "State outside JFLEX_STATE_MASK (255) should not be used by JFLex lexer";
            throw new AssertionError((Object)string);
        }
        if (this.isLexerInHereDocLineState(state &= 0xFF)) {
            state |= (lexer.myHereDocMarkerLength & 0x7F) << 8 & 0x7F00;
            state |= (lexer.myHereDocIndented ? 128 : 0) << 8 & 0x7F00;
            state |= (lexer.myHereDocMarkerWeakHash & 0xFFFF) << 16 & HEREDOC_MARKER_WEAK_HASH;
        } else if (this.capabilities.contains((Object)HCLCapability.INTERPOLATION_LANGUAGE)) {
            _HCLLexer.StringType stringType = lexer.stringType;
            Intrinsics.checkNotNull((Object)((Object)stringType));
            _HCLLexer.StringType type = stringType;
            if (type != _HCLLexer.StringType.None) {
                state |= 0x4000;
                if (type == _HCLLexer.StringType.SingleQ) {
                    state |= 0x8000;
                }
            }
            state |= (lexer.hil & 0x3F) << 8 & 0x3F00;
        }
        return state;
    }

    public HCLLexer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/hcl/HCLLexer$Companion;", "", "<init>", "()V", "STRING_START_MASK", "", "IN_SINGLE_QUOTED_STRING", "IN_STRING", "HIL_MASK", "HEREDOC_MARKER_LENGTH", "HEREDOC_MARKER_INDENTED", "HEREDOC_MARKER_WEAK_HASH", "JFLEX_STATE_MASK", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

