/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.intellij.terraform.config.util.TfCommandLineService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0015\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00060\u00060\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/terraform/config/util/TfCommandLineServiceMock;", "Lorg/intellij/terraform/config/util/TfCommandLineService;", "<init>", "()V", "mocks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/lang/Process;", "mockCommandLine", "", "commandLine", "stdout", "disposable", "Lcom/intellij/openapi/Disposable;", "exitCode", "", "errors", "Lcom/intellij/util/containers/ConcurrentList;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "requests", "wrapCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "throwErrorsIfAny", "clear", "requestsToVerify", "", "Companion", "intellij.terraform"})
public final class TfCommandLineServiceMock
implements TfCommandLineService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Process> mocks = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentList<Throwable> errors;
    @NotNull
    private final ConcurrentList<String> requests;

    public TfCommandLineServiceMock() {
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.errors = concurrentList;
        ConcurrentList concurrentList2 = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList2, (String)"createConcurrentList(...)");
        this.requests = concurrentList2;
    }

    public final void mockCommandLine(@NotNull String commandLine, @NotNull String stdout, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.mockCommandLine(commandLine, stdout, 0, disposable);
    }

    public final void mockCommandLine(@NotNull String commandLine, @NotNull String stdout, int exitCode, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ((Map)this.mocks).put(commandLine, new Process(stdout, exitCode){
            final /* synthetic */ String $stdout;
            final /* synthetic */ int $exitCode;
            {
                this.$stdout = $stdout;
                this.$exitCode = $exitCode;
            }

            public OutputStream getOutputStream() {
                OutputStream outputStream = OutputStream.nullOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"nullOutputStream(...)");
                return outputStream;
            }

            public InputStream getInputStream() {
                String string = this.$stdout;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return new ByteArrayInputStream(byArray);
            }

            public InputStream getErrorStream() {
                InputStream inputStream = InputStream.nullInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"nullInputStream(...)");
                return inputStream;
            }

            public int waitFor() {
                return this.$exitCode;
            }

            public int exitValue() {
                return this.$exitCode;
            }

            public void destroy() {
            }
        });
        Disposer.register((Disposable)disposable, () -> TfCommandLineServiceMock.mockCommandLine$lambda$0(this, commandLine));
    }

    @Override
    @NotNull
    public GeneralCommandLine wrapCommandLine(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return new GeneralCommandLine(commandLine, this){
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ TfCommandLineServiceMock this$0;
            {
                this.$commandLine = $commandLine;
                this.this$0 = $receiver;
            }

            public Process createProcess() {
                String string = this.$commandLine.getCommandLineString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCommandLineString(...)");
                String commandLineString = string;
                TfCommandLineServiceMock.access$getRequests$p(this.this$0).add((Object)commandLineString);
                Process process2 = (Process)TfCommandLineServiceMock.access$getMocks$p(this.this$0).get(commandLineString);
                if (process2 == null) {
                    AssertionError assertionError = new AssertionError((Object)("Missing mock for " + commandLineString + ", available mocks = " + TfCommandLineServiceMock.access$getMocks$p(this.this$0).keySet()));
                    TfCommandLineServiceMock tfCommandLineServiceMock = this.this$0;
                    AssertionError it = assertionError;
                    boolean bl = false;
                    TfCommandLineServiceMock.access$getErrors$p(tfCommandLineServiceMock).add((Object)it);
                    throw (Throwable)((Object)assertionError);
                }
                return process2;
            }
        };
    }

    public final void throwErrorsIfAny() {
        Pair pair = UtilKt.headTailOrNull((List)CollectionsKt.toList((Iterable)((Iterable)this.errors)));
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        Throwable head = (Throwable)pair2.component1();
        List tail = (List)pair2.component2();
        this.errors.clear();
        for (Throwable throwable : tail) {
            Intrinsics.checkNotNull((Object)head);
            Intrinsics.checkNotNull((Object)throwable);
            ExceptionsKt.addSuppressed((Throwable)head, (Throwable)throwable);
        }
        throw head;
    }

    public final void clear() {
        this.requests.clear();
        this.errors.clear();
    }

    @NotNull
    public final List<String> requestsToVerify() {
        List result = CollectionsKt.toList((Iterable)((Iterable)this.requests));
        this.requests.clear();
        return result;
    }

    private static final void mockCommandLine$lambda$0(TfCommandLineServiceMock this$0, String $commandLine) {
        this$0.mocks.remove($commandLine);
        this$0.requests.clear();
    }

    public static final /* synthetic */ ConcurrentList access$getRequests$p(TfCommandLineServiceMock $this) {
        return $this.requests;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMocks$p(TfCommandLineServiceMock $this) {
        return $this.mocks;
    }

    public static final /* synthetic */ ConcurrentList access$getErrors$p(TfCommandLineServiceMock $this) {
        return $this.errors;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/config/util/TfCommandLineServiceMock$Companion;", "", "<init>", "()V", "instance", "Lorg/intellij/terraform/config/util/TfCommandLineServiceMock;", "getInstance", "()Lorg/intellij/terraform/config/util/TfCommandLineServiceMock;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfCommandLineService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfCommandLineService.kt\norg/intellij/terraform/config/util/TfCommandLineServiceMock$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,95:1\n40#2,3:96\n*S KotlinDebug\n*F\n+ 1 TfCommandLineService.kt\norg/intellij/terraform/config/util/TfCommandLineServiceMock$Companion\n*L\n91#1:96,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final TfCommandLineServiceMock getInstance() {
            boolean $i$f$service = false;
            Class<TfCommandLineService> serviceClass$iv = TfCommandLineService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.intellij.terraform.config.util.TfCommandLineServiceMock");
            return (TfCommandLineServiceMock)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

