/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.spellchecker;

import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/intellij/terraform/config/spellchecker/TfSpellcheckingUtil;", "", "<init>", "()V", "RootBlocksWithChangeableName", "", "", "getRootBlocksWithChangeableName", "()Ljava/util/Set;", "StringLiteralTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "getStringLiteralTokenizer", "()Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "HeredocContentTokenizer", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "getHeredocContentTokenizer", "handleTokenizing", "", "element", "Lcom/intellij/psi/PsiElement;", "textFragments", "", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "consumer", "Lcom/intellij/spellchecker/tokenizer/TokenConsumer;", "intellij.terraform"})
public final class TfSpellcheckingUtil {
    @NotNull
    public static final TfSpellcheckingUtil INSTANCE = new TfSpellcheckingUtil();
    @NotNull
    private static final Set<String> RootBlocksWithChangeableName;
    @NotNull
    private static final Tokenizer<HCLStringLiteral> StringLiteralTokenizer;
    @NotNull
    private static final Tokenizer<HCLHeredocContent> HeredocContentTokenizer;

    private TfSpellcheckingUtil() {
    }

    @NotNull
    public final Set<String> getRootBlocksWithChangeableName() {
        return RootBlocksWithChangeableName;
    }

    @NotNull
    public final Tokenizer<HCLStringLiteral> getStringLiteralTokenizer() {
        return StringLiteralTokenizer;
    }

    @NotNull
    public final Tokenizer<HCLHeredocContent> getHeredocContentTokenizer() {
        return HeredocContentTokenizer;
    }

    private final void handleTokenizing(PsiElement element, List<? extends Pair<TextRange, String>> textFragments, TokenConsumer consumer) {
        PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
        for (Pair<TextRange, String> pair : textFragments) {
            TextRange fragmentRange = (TextRange)ExtensionsKt.component1(pair);
            String escaped = (String)ExtensionsKt.component2(pair);
            if (escaped.length() != fragmentRange.getLength() || StringsKt.startsWith$default((String)escaped, (String)"\\", (boolean)false, (int)2, null)) continue;
            consumer.consumeToken(element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), (Splitter)textSplitter);
        }
    }

    public static final /* synthetic */ void access$handleTokenizing(TfSpellcheckingUtil $this, PsiElement element, List textFragments, TokenConsumer consumer) {
        $this.handleTokenizing(element, textFragments, consumer);
    }

    static {
        Object[] objectArray = new String[]{"output", "variable", "module", "resource", "data"};
        RootBlocksWithChangeableName = SetsKt.setOf((Object[])objectArray);
        StringLiteralTokenizer = (Tokenizer)new Tokenizer<HCLStringLiteral>(){

            public void tokenize(HCLStringLiteral element, TokenConsumer consumer) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                PsiElement psiElement = element;
                List<Pair<TextRange, String>> list = element.getTextFragments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTextFragments(...)");
                TfSpellcheckingUtil.access$handleTokenizing(TfSpellcheckingUtil.INSTANCE, psiElement, list, consumer);
            }
        };
        HeredocContentTokenizer = (Tokenizer)new Tokenizer<HCLHeredocContent>(){

            public void tokenize(HCLHeredocContent element, TokenConsumer consumer) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
                PsiElement psiElement = element;
                List<Pair<TextRange, String>> list = element.getTextFragments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTextFragments(...)");
                TfSpellcheckingUtil.access$handleTokenizing(TfSpellcheckingUtil.INSTANCE, psiElement, list, consumer);
            }
        };
    }
}

