/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.ILLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016JI\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0013\"\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u000bJ \u0010\u001b\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/intellij/terraform/config/psi/TfElementGenerator;", "Lorg/intellij/terraform/hcl/psi/HCLElementGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createDummyFile", "Lcom/intellij/psi/PsiFile;", "content", "", "original", "createBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "name", "properties", "", "namedElements", "", "(Ljava/lang/String;Ljava/util/Map;[Ljava/lang/String;Lcom/intellij/psi/PsiFile;)Lorg/intellij/terraform/hcl/psi/HCLBlock;", "createObjectProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "value", "createRequiredProviderProperty", "provider", "Lorg/intellij/terraform/config/model/ProviderType;", "createVariable", "type", "Lorg/intellij/terraform/config/model/Type;", "initializer", "Lorg/intellij/terraform/hil/psi/ILExpression;", "Lcom/intellij/psi/PsiElement;", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfElementGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfElementGenerator.kt\norg/intellij/terraform/config/psi/TfElementGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,112:1\n1#2:113\n126#3:114\n153#3,3:115\n455#4:118\n*S KotlinDebug\n*F\n+ 1 TfElementGenerator.kt\norg/intellij/terraform/config/psi/TfElementGenerator\n*L\n50#1:114\n50#1:115,3\n65#1:118\n*E\n"})
public final class TfElementGenerator
extends HCLElementGenerator {
    @NotNull
    private final Project project;

    public TfElementGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PsiFile createDummyFile(String content, PsiFile original) {
        PsiFile psiFile;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)this.project);
        if (original != null) {
            PsiFile psiFile2;
            PsiFile it = psiFile2 = psiFileFactory.createFileFromText("dummy." + original.getFileType().getDefaultExtension(), original.getFileType(), (CharSequence)content);
            boolean bl = false;
            it.putUserData(PsiFileFactory.ORIGINAL_FILE, (Object)original);
            psiFile = psiFile2;
        } else {
            psiFile = psiFileFactory.createFileFromText("dummy." + TerraformFileType.INSTANCE.getDefaultExtension(), (FileType)TerraformFileType.INSTANCE, (CharSequence)content);
        }
        PsiFile psiFile3 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile3);
        PsiFile psiFile4 = psiFile3;
        if (PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)psiFile4))) {
            throw new IllegalStateException("PsiFile contains PsiErrorElement: " + DebugUtil.psiToString((PsiElement)((PsiElement)psiFile4), (boolean)false, (boolean)true));
        }
        return psiFile4;
    }

    @Override
    @NotNull
    public PsiFile createDummyFile(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return this.createDummyFile(content, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HCLBlock createBlock(@NotNull String name, @NotNull Map<String, String> properties, @NotNull String[] namedElements, @Nullable PsiFile original) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)namedElements, (String)"namedElements");
        if (!this.isIdentifier(name)) {
            char c = '\"';
            object = c + name + "\"";
        } else {
            object = name;
        }
        String nameString = object;
        String typeString = ArraysKt.joinToString$default((Object[])namedElements, (CharSequence)" ", null, null, (int)0, null, TfElementGenerator::createBlock$lambda$1, (int)30, null);
        Map<String, String> $this$map$iv = properties;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name2 = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(this.createPropertyString(name2, "\"" + StringUtil.unquoteString((String)value) + "\""));
        }
        String propertiesString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", (CharSequence)"\t", null, (int)0, null, null, (int)60, null);
        String content = StringsKt.trimIndent((String)("\n      " + nameString + " " + typeString + " {\n      " + propertiesString + "\n      }\n     "));
        PsiFile file = this.createDummyFile(content, original);
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        return (HCLBlock)psiElement;
    }

    public static /* synthetic */ HCLBlock createBlock$default(TfElementGenerator tfElementGenerator, String string, Map map, String[] stringArray, PsiFile psiFile, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            psiFile = null;
        }
        return tfElementGenerator.createBlock(string, map, stringArray, psiFile);
    }

    private final HCLProperty createObjectProperty(String name, String value) {
        String s = StringsKt.trimIndent((String)("\n      " + name + " = " + value + "\n    "));
        PsiFile file = this.createDummyFile(s);
        PsiElement $this$childrenOfType$iv = (PsiElement)file;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, HCLProperty.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        return (HCLProperty)CollectionsKt.first((List)list);
    }

    @NotNull
    public final HCLProperty createRequiredProviderProperty(@NotNull ProviderType provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"source", (Object)("\"" + provider.getFullName() + "\"")), TuplesKt.to((Object)"version", (Object)("\"" + provider.getVersion() + "\""))};
        HCLObject providerObject = this.createObject(MapsKt.mapOf((Pair[])pairArray));
        String string = provider.getType();
        String string2 = providerObject.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return this.createObjectProperty(string, string2);
    }

    @NotNull
    public final HCLBlock createVariable(@NotNull String name, @Nullable Type type, @NotNull ILExpression initializer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
        Object value = initializer instanceof ILLiteralExpression ? ((ILLiteralExpression)initializer).getText() : "\"${" + initializer.getText() + "}\"";
        Intrinsics.checkNotNull((Object)value);
        return this.createVariable(name, type, (String)value);
    }

    @NotNull
    public final HCLBlock createVariable(@NotNull String name, @Nullable Type type, @NotNull String value) {
        String typeName;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringBuilder $this$createVariable_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createVariable_u24lambda_u243.append("variable \"").append(name).append("\" {");
        if (type != null) {
            String string = type.getPresentableText();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            v2 = typeName = null;
        }
        if (typeName != null) {
            $this$createVariable_u24lambda_u243.append("\n  type=").append(typeName);
        }
        $this$createVariable_u24lambda_u243.append("\n  default=").append(value).append("\n}");
        String content = stringBuilder.toString();
        PsiFile file = this.createDummyFile(content);
        PsiElement psiElement = file.getFirstChild();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        return (HCLBlock)psiElement;
    }

    @NotNull
    public final PsiElement createVariable(@NotNull String name, @Nullable Type type, @NotNull HCLElement initializer) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
        String value = initializer instanceof HCLLiteral ? ((HCLLiteral)initializer).getText() : initializer.getText();
        Intrinsics.checkNotNull((Object)value);
        return this.createVariable(name, type, value);
    }

    private static final CharSequence createBlock$lambda$1(String str) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (StringUtil.isQuotedString((String)str)) {
            charSequence = str;
        } else {
            StringBuilder builder = new StringBuilder(str);
            StringUtil.quote((StringBuilder)builder, (char)'\"');
            String string = builder.toString();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        }
        return charSequence;
    }
}

