/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLIndexSelectExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLSelectExpression;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hil.psi.HCLElementLazyReferenceBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/psi/ModuleProvidersReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "Reference", "intellij.terraform"})
public final class ModuleProvidersReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final ModuleProvidersReferenceProvider INSTANCE = new ModuleProvidersReferenceProvider();

    private ModuleProvidersReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof HCLElement)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (!(element instanceof HCLIdentifier || element instanceof HCLStringLiteral || element instanceof HCLSelectExpression)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        if (element instanceof HCLIndexSelectExpression) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLProperty hCLProperty = (HCLProperty)UtilKt.getParent$default(element, HCLProperty.class, false, 2, null);
        if (hCLProperty == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLProperty property = hCLProperty;
        HCLBlock hCLBlock = (HCLBlock)UtilKt.getParent$default(UtilKt.getParent$default(UtilKt.getParent$default(property, HCLObject.class, false, 2, null), HCLObject.class, false, 2, null), HCLBlock.class, false, 2, null);
        if (hCLBlock == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HCLBlock block = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String type = string;
        if (!Intrinsics.areEqual((Object)type, (Object)"module")) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Reference[] referenceArray = new Reference[]{new Reference(element)};
        return (PsiReference[])referenceArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/psi/ModuleProvidersReferenceProvider$Reference;", "Lorg/intellij/terraform/hil/psi/HCLElementLazyReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "resolve", "", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "incompleteCode", "", "includeFake", "Companion", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nModuleProvidersReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleProvidersReferenceProvider.kt\norg/intellij/terraform/config/psi/ModuleProvidersReferenceProvider$Reference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1563#2:67\n1634#2,3:68\n*S KotlinDebug\n*F\n+ 1 ModuleProvidersReferenceProvider.kt\norg/intellij/terraform/config/psi/ModuleProvidersReferenceProvider$Reference\n*L\n51#1:67\n51#1:68,3\n*E\n"})
    public static final class Reference
    extends HCLElementLazyReferenceBase<PsiElement> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public Reference(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<HCLElement> resolve(boolean incompleteCode, boolean includeFake) {
            List list;
            Module module;
            boolean isKey;
            PsiElement psiElement = this.getElement();
            HCLElement hCLElement = psiElement instanceof HCLElement ? (HCLElement)psiElement : null;
            if (hCLElement == null) {
                return CollectionsKt.emptyList();
            }
            HCLElement element = hCLElement;
            HCLProperty hCLProperty = (HCLProperty)UtilKt.getParent$default(element, HCLProperty.class, false, 2, null);
            if (hCLProperty == null) {
                return CollectionsKt.emptyList();
            }
            HCLProperty property = hCLProperty;
            HCLBlock hCLBlock = (HCLBlock)UtilKt.getParent$default(UtilKt.getParent$default(UtilKt.getParent$default(property, HCLObject.class, false, 2, null), HCLObject.class, false, 2, null), HCLBlock.class, false, 2, null);
            if (hCLBlock == null) {
                return CollectionsKt.emptyList();
            }
            HCLBlock block = hCLBlock;
            String string = UtilKt.getNameElementUnquoted(block, 0);
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            String type = string;
            if (!Intrinsics.areEqual((Object)type, (Object)"module")) {
                return CollectionsKt.emptyList();
            }
            String string2 = Reference.Companion.getValue(element);
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            String value = string2;
            HCLProperty parent = (HCLProperty)UtilKt.getParent$default(element, HCLProperty.class, false, 2, null);
            boolean bl = isKey = parent != null && HCLPsiUtil.INSTANCE.isPartOfPropertyKey(element);
            if (isKey) {
                v6 = Module.Companion.getAsModuleBlock(block);
                if (v6 == null) {
                    return CollectionsKt.emptyList();
                }
            } else {
                v6 = module = ExtensionsKt.getTerraformModule(element);
            }
            if (incompleteCode) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = module.getDefinedProviders();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((HCLBlock)it.getFirst());
                }
                list = (List)destination$iv$iv;
            } else {
                list = module.findProviders(value);
            }
            return list;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/config/psi/ModuleProvidersReferenceProvider$Reference$Companion;", "", "<init>", "()V", "getValue", "", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "intellij.terraform"})
        public static final class Companion {
            private Companion() {
            }

            private final String getValue(HCLElement element) {
                if (element instanceof HCLIdentifier && ((HCLIdentifier)element).getParent() instanceof HCLSelectExpression) {
                    return ((HCLIdentifier)element).getParent().getText();
                }
                if (element instanceof HCLIdentifier) {
                    return ((HCLIdentifier)element).getId();
                }
                if (element instanceof HCLStringLiteral) {
                    return ((HCLStringLiteral)element).getValue();
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

