/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.version.MalformedVersionException;
import org.intellij.terraform.config.model.version.VersionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\t\b\u0086\b\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001'B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u0013\u0010\u001e\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\bH\u0016J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0006H\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J;\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006("}, d2={"Lorg/intellij/terraform/config/model/version/Version;", "", "metadata", "", "pre", "segments", "", "si", "", "original", "<init>", "(Ljava/lang/String;Ljava/lang/String;[JILjava/lang/String;)V", "getMetadata", "()Ljava/lang/String;", "getPre", "getSegments", "()[J", "getSi", "()I", "getOriginal", "compareTo", "other", "isAllZero", "", "longs", "startIndex", "comparePrereleases", "self", "comparePart", "toString", "equals", "", "hashCode", "component1", "component2", "component3", "component4", "component5", "copy", "Companion", "intellij.terraform"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String metadata;
    @NotNull
    private final String pre;
    @NotNull
    private final long[] segments;
    private final int si;
    @NotNull
    private final String original;
    @NotNull
    private static final Version MAX = Companion.parse("2147483647.2147483647.2147483647");
    @NotNull
    private static final Version ZERO = Companion.parse("0.0");

    public Version(@NotNull String metadata, @NotNull String pre, @NotNull long[] segments, int si, @NotNull String original) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)pre, (String)"pre");
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.metadata = metadata;
        this.pre = pre;
        this.segments = segments;
        this.si = si;
        this.original = original;
        boolean bl2 = bl = this.segments.length >= 3;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final String getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final String getPre() {
        return this.pre;
    }

    @NotNull
    public final long[] getSegments() {
        return this.segments;
    }

    public final int getSi() {
        return this.si;
    }

    @NotNull
    public final String getOriginal() {
        return this.original;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)other.toString(), (Object)this.toString())) {
            return 0;
        }
        long[] segmentsSelf = this.segments;
        long[] segmentsOther = other.segments;
        if (Arrays.equals(segmentsSelf, segmentsOther)) {
            String preSelf = this.pre;
            String preOther = other.pre;
            if (Intrinsics.areEqual((Object)preSelf, (Object)preOther)) {
                return 0;
            }
            if (((CharSequence)preSelf).length() == 0) {
                return 1;
            }
            if (((CharSequence)preOther).length() == 0) {
                return -1;
            }
            return this.comparePrereleases(preSelf, preOther);
        }
        int i = 0;
        int n = Math.max(ArraysKt.getLastIndex((long[])segmentsSelf), ArraysKt.getLastIndex((long[])segmentsOther));
        if (i <= n) {
            while (true) {
                if (i > ArraysKt.getLastIndex((long[])segmentsSelf)) {
                    if (this.isAllZero(segmentsOther, i)) break;
                    return -1;
                }
                if (i > ArraysKt.getLastIndex((long[])segmentsOther)) {
                    if (this.isAllZero(segmentsSelf, i)) break;
                    return 1;
                }
                long lhs = segmentsSelf[i];
                long rhs = segmentsOther[i];
                if (lhs != rhs) {
                    return MathKt.getSign((int)Intrinsics.compare((long)lhs, (long)rhs));
                }
                if (i == n) break;
                ++i;
            }
        }
        return 0;
    }

    private final boolean isAllZero(long[] longs, int startIndex) {
        int i = startIndex;
        int n = ArraysKt.getLastIndex((long[])longs);
        if (i <= n) {
            while (true) {
                if (longs[i] != 0L) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    private final int comparePrereleases(String self, String other) {
        if (Intrinsics.areEqual((Object)self, (Object)other)) {
            return 0;
        }
        char[] cArray = new char[]{'.'};
        List selfPreReleaseMeta = StringsKt.split$default((CharSequence)self, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'.'};
        List otherPreReleaseMeta = StringsKt.split$default((CharSequence)other, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        int i = 0;
        int n = Math.max(CollectionsKt.getLastIndex((List)selfPreReleaseMeta), CollectionsKt.getLastIndex((List)otherPreReleaseMeta));
        if (i <= n) {
            while (true) {
                String partOtherPre;
                int compare;
                String string;
                String partSelfPre;
                String string2;
                if ((string2 = (String)CollectionsKt.getOrNull((List)selfPreReleaseMeta, (int)i)) == null) {
                    string2 = partSelfPre = "";
                }
                if ((string = (String)CollectionsKt.getOrNull((List)otherPreReleaseMeta, (int)i)) == null) {
                    string = "";
                }
                if ((compare = MathKt.getSign((int)this.comparePart(partSelfPre, partOtherPre = string))) != 0) {
                    return compare;
                }
                if (i == n) break;
                ++i;
            }
        }
        return 0;
    }

    private final int comparePart(String self, String other) {
        if (Intrinsics.areEqual((Object)self, (Object)other)) {
            return 0;
        }
        Long selfInt = StringsKt.toLongOrNull((String)self);
        Long otherInt = StringsKt.toLongOrNull((String)other);
        if (((CharSequence)self).length() == 0) {
            if (otherInt != null) {
                return -1;
            }
            return 1;
        }
        if (((CharSequence)other).length() == 0) {
            if (selfInt != null) {
                return 1;
            }
            return -1;
        }
        if (selfInt != null) {
            if (otherInt != null) {
                return Intrinsics.compare((long)selfInt, (long)otherInt);
            }
            return -1;
        }
        if (otherInt == null) {
            return self.compareTo(other);
        }
        return 1;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArraysKt.joinTo$default((long[])this.segments, (Appendable)sb, (CharSequence)".", null, null, (int)0, null, null, (int)124, null);
        if (((CharSequence)this.pre).length() > 0) {
            sb.append('-').append(this.pre);
        }
        if (((CharSequence)this.metadata).length() > 0) {
            sb.append('+').append(this.metadata);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = 31 * result + this.pre.hashCode();
        result = 31 * result + Arrays.hashCode(ArraysKt.sliceArray((long[])this.segments, (IntRange)new IntRange(0, 2)));
        return result;
    }

    @NotNull
    public final String component1() {
        return this.metadata;
    }

    @NotNull
    public final String component2() {
        return this.pre;
    }

    @NotNull
    public final long[] component3() {
        return this.segments;
    }

    public final int component4() {
        return this.si;
    }

    @NotNull
    public final String component5() {
        return this.original;
    }

    @NotNull
    public final Version copy(@NotNull String metadata, @NotNull String pre, @NotNull long[] segments, int si, @NotNull String original) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)pre, (String)"pre");
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return new Version(metadata, pre, segments, si, original);
    }

    public static /* synthetic */ Version copy$default(Version version, String string, String string2, long[] lArray, int n, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = version.metadata;
        }
        if ((n2 & 2) != 0) {
            string2 = version.pre;
        }
        if ((n2 & 4) != 0) {
            lArray = version.segments;
        }
        if ((n2 & 8) != 0) {
            n = version.si;
        }
        if ((n2 & 0x10) != 0) {
            string3 = version.original;
        }
        return version.copy(string, string2, lArray, n, string3);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/model/version/Version$Companion;", "", "<init>", "()V", "MAX", "Lorg/intellij/terraform/config/model/version/Version;", "getMAX", "()Lorg/intellij/terraform/config/model/version/Version;", "ZERO", "getZERO", "parseOrNull", "v", "", "parse", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\norg/intellij/terraform/config/model/version/Version$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1634#2,3:192\n*S KotlinDebug\n*F\n+ 1 Version.kt\norg/intellij/terraform/config/model/version/Version$Companion\n*L\n48#1:192,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getMAX() {
            return MAX;
        }

        @NotNull
        public final Version getZERO() {
            return ZERO;
        }

        @Nullable
        public final Version parseOrNull(@NotNull String v) {
            Version version;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            try {
                version = this.parse(v);
            }
            catch (MalformedVersionException e) {
                version = null;
            }
            return version;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Version parse(@NotNull String v) throws MalformedVersionException {
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Object object = VersionKt.getVersionRegexp().matchEntire((CharSequence)v);
            if (object == null || (object = object.getGroupValues()) == null) {
                throw new MalformedVersionException("Malformed version: " + v);
            }
            Object matches = object;
            String[] stringArray = new String[]{"."};
            List segmentsStr = StringsKt.split$default((CharSequence)((CharSequence)matches.get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable iterable = segmentsStr;
            Collection destination$iv = new ArrayList();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                Long l = StringsKt.toLongOrNull((String)it);
                if (l == null) {
                    throw new MalformedVersionException("Malformed version part: " + (String)it + ", full version: " + v);
                }
                collection.add(Long.valueOf(l));
            }
            ArrayList segments = (ArrayList)destination$iv;
            while (segments.size() < 3) {
                segments.add(0L);
            }
            String pre = (String)matches.get(7);
            if (((CharSequence)pre).length() == 0) {
                pre = (String)matches.get(4);
            }
            return new Version((String)matches.get(10), pre, CollectionsKt.toLongArray((Collection)segments), segmentsStr.size(), v);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

