/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.BackendType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.EphemeralType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Hint;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ProvisionerType;
import org.intellij.terraform.config.model.ReferenceHint;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.SimpleValueHint;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.model.loader.BackendLoaderV1;
import org.intellij.terraform.config.model.loader.BackendLoaderV2;
import org.intellij.terraform.config.model.loader.FunctionsLoaderV1;
import org.intellij.terraform.config.model.loader.FunctionsLoaderV2;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.ProviderLoaderV1;
import org.intellij.terraform.config.model.loader.ProviderLoaderV2;
import org.intellij.terraform.config.model.loader.ProvisionerLoaderV1;
import org.intellij.terraform.config.model.loader.ProvisionerLoaderV2;
import org.intellij.terraform.config.model.loader.ReusePool;
import org.intellij.terraform.config.model.loader.TfProvidersSchema;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00152\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000bH\u0002J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/intellij/terraform/config/model/loader/TfMetadataLoader;", "", "<init>", "()V", "pool", "Lorg/intellij/terraform/config/model/loader/ReusePool;", "model", "Lorg/intellij/terraform/config/model/loader/LoadingModel;", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "loaders", "", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "loadDefaults", "Lorg/intellij/terraform/config/model/TypeModel;", "loadFrom", "", "another", "buildModel", "loadExternalInformation", "", "", "Lorg/intellij/terraform/config/model/loader/LoadingModel$Additional;", "loadBundled", "loadExternal", "loadOne", "sourceName", "stream", "Ljava/io/InputStream;", "logErrorAndFailInInternalMode", "msg", "e", "", "getSharedSchemas", "Ljava/io/File;", "parseFile", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfMetadataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfMetadataLoader.kt\norg/intellij/terraform/config/model/loader/TfMetadataLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,299:1\n774#2:300\n865#2,2:301\n774#2:303\n865#2,2:304\n774#2:306\n865#2,2:307\n774#2:309\n865#2,2:310\n1617#2,9:312\n1869#2:321\n1870#2:323\n1626#2:324\n1#3:322\n1#3:329\n37#4:325\n36#4,3:326\n*S KotlinDebug\n*F\n+ 1 TfMetadataLoader.kt\norg/intellij/terraform/config/model/loader/TfMetadataLoader\n*L\n57#1:300\n57#1:301,2\n58#1:303\n58#1:304,2\n59#1:306\n59#1:307,2\n60#1:309\n60#1:310,2\n94#1:312,9\n94#1:321\n94#1:323\n94#1:324\n94#1:322\n94#1:325\n94#1:326,3\n*E\n"})
public final class TfMetadataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReusePool pool = new ReusePool();
    @NotNull
    private final LoadingModel model = new LoadingModel();
    @NotNull
    private final LoadContext context = new LoadContext(this.pool, this.model);
    @NotNull
    private final List<VersionedMetadataLoader> loaders;
    @NotNull
    private static final Lazy<Logger> LOG$delegate = LazyKt.lazy(TfMetadataLoader::LOG_delegate$lambda$17);
    @NotNull
    public static final String ModelResourcesPrefix = "/terraform/model";

    public TfMetadataLoader() {
        Object[] objectArray = new VersionedMetadataLoader[]{new TfProvidersSchema(), new ProviderLoaderV2(), new ProvisionerLoaderV2(), new BackendLoaderV2(), new FunctionsLoaderV2(), new ProviderLoaderV1(), new ProvisionerLoaderV1(), new BackendLoaderV1(), new FunctionsLoaderV1()};
        this.loaders = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public final TypeModel loadDefaults() {
        try {
            this.model.getExternal().putAll(this.loadExternalInformation());
            this.loadExternal();
            this.loadBundled();
            return this.buildModel();
        }
        catch (Exception e) {
            this.logErrorAndFailInInternalMode("Failed to load Terraform Model", e);
            return null;
        }
    }

    public final void loadFrom(@NotNull TypeModel another) {
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        TypeModel tmp = this.buildModel();
        CollectionsKt.addAll((Collection)this.model.getResources(), (Sequence)SequencesKt.filter(another.allResources(), arg_0 -> TfMetadataLoader.loadFrom$lambda$0(tmp, arg_0)));
        CollectionsKt.addAll((Collection)this.model.getDataSources(), (Sequence)SequencesKt.filter(another.allDataSources(), arg_0 -> TfMetadataLoader.loadFrom$lambda$1(tmp, arg_0)));
        CollectionsKt.addAll((Collection)this.model.getProviders(), (Sequence)SequencesKt.filter(another.allProviders(), arg_0 -> TfMetadataLoader.loadFrom$lambda$2(tmp, arg_0)));
        CollectionsKt.addAll((Collection)this.model.getEphemeralResources(), (Sequence)SequencesKt.filter(another.allEphemeralResources(), arg_0 -> TfMetadataLoader.loadFrom$lambda$3(tmp, arg_0)));
        Iterable iterable = another.getProvisioners();
        List<Object> list = this.model.getProvisioners();
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProvisionerType)element$iv$iv;
            boolean bl = false;
            if (!(tmp.getProvisionerType(((ProvisionerType)it).getType()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        $this$filter$iv = another.getBackends();
        list = this.model.getBackends();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BackendType)element$iv$iv;
            boolean bl = false;
            if (!(tmp.getBackendType(((BackendType)it).getType()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        $this$filter$iv = another.getFunctions();
        list = this.model.getFunctions();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TfFunction)element$iv$iv;
            boolean bl = false;
            if (!(tmp.getFunction(((TfFunction)it).getName()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        $this$filter$iv = another.getProviderDefinedFunctions();
        list = this.model.getProviderDefinedFunctions();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TfFunction)element$iv$iv;
            boolean bl = false;
            if (!(tmp.getFunction(((TfFunction)it).getName()) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
    }

    @NotNull
    public final TypeModel buildModel() {
        return new TypeModel(this.model.getResources(), this.model.getDataSources(), this.model.getProviders(), this.model.getProvisioners(), this.model.getBackends(), this.model.getFunctions(), this.model.getProviderDefinedFunctions(), this.model.getEphemeralResources());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<String, LoadingModel.Additional> loadExternalInformation() {
        InputStream it;
        HashMap map = new HashMap();
        InputStream inputStream = Companion.loadExternalResource("external-data.json");
        if (inputStream == null) {
            return map;
        }
        InputStream stream = inputStream;
        Object object = stream;
        Object object2 = null;
        try {
            it = (InputStream)object;
            boolean bl = false;
            it = (ObjectNode)new ObjectMapper().readTree(it);
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        InputStream json = it;
        if (json != null) {
            Iterator iterator = json.fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
            object = iterator;
            while (object.hasNext()) {
                Hint hint;
                object2 = (Map.Entry)object.next();
                Intrinsics.checkNotNull((Object)object2);
                String fqn = (String)object2.getKey();
                JsonNode obj = (JsonNode)object2.getValue();
                if (!(obj instanceof ObjectNode)) {
                    Companion.getLOG$intellij_terraform().warn("In external-data.json value for '" + fqn + "' root key is not an object");
                    continue;
                }
                JsonNode hintV = ((ObjectNode)obj).get("hint");
                if (hintV == null) {
                    hint = null;
                } else if (hintV.isTextual()) {
                    var10_13 = new String[1];
                    Intrinsics.checkNotNullExpressionValue((Object)hintV.textValue(), (String)"textValue(...)");
                    hint = new ReferenceHint(var10_13);
                } else if (hintV.isArray()) {
                    void $this$toTypedArray$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)hintV;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        JsonNode it2 = (JsonNode)element$iv$iv;
                        boolean bl2 = false;
                        if (it2.textValue() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    var10_13 = thisCollection$iv.toArray(new String[0]);
                    String[] stringArray = Arrays.copyOf(var10_13, var10_13.length);
                    hint = new SimpleValueHint(stringArray);
                } else {
                    hint = null;
                }
                Hint hint2 = hint;
                Intrinsics.checkNotNull((Object)fqn);
                LoadingModel.Additional additional = new LoadingModel.Additional(fqn, ExtensionsKt.string((ObjectNode)obj, "description"), hint2, ExtensionsKt.boolean((ObjectNode)obj, "optional"), ExtensionsKt.boolean((ObjectNode)obj, "required"));
                ((Map)map).put(fqn, additional);
            }
        }
        return map;
    }

    private final void loadBundled() {
        Collection<String> resources = Companion.getAllResourcesToLoad$intellij_terraform(ModelResourcesPrefix);
        for (String it : resources) {
            String file = ExtensionsKt.ensureHavePrefix(it, "/");
            InputStream stream = Companion.getResource(file);
            if (stream == null) {
                Companion.getLOG$intellij_terraform().warn("Resource '" + file + "' was not found");
                continue;
            }
            this.loadOne(file, stream);
        }
    }

    private final void loadExternal() {
        List<File> schemas = this.getSharedSchemas();
        for (File file : schemas) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
            }
            catch (Exception e) {
                this.logErrorAndFailInInternalMode("Cannot open stream for file '" + file.getAbsolutePath() + "'", e);
                continue;
            }
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            this.loadOne(string, stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadOne(@NotNull String sourceName, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        ObjectNode json = null;
        try {
            ObjectNode objectNode;
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                objectNode = (ObjectNode)new ObjectMapper().readTree(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            json = objectNode;
            if (json == null) {
                TfMetadataLoader.logErrorAndFailInInternalMode$default(this, "In file '" + sourceName + "' no JSON found", null, 2, null);
                return;
            }
        }
        catch (Exception e) {
            this.logErrorAndFailInInternalMode("Failed to load json data from file '" + sourceName + "'", e);
            return;
        }
        try {
            this.parseFile(json, sourceName);
        }
        catch (Throwable e) {
            this.logErrorAndFailInInternalMode("Failed to parse file '" + sourceName + "'", e);
        }
    }

    private final void logErrorAndFailInInternalMode(String msg, Throwable e) {
        String msg2;
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        Throwable throwable = e;
        String string = msg2 = throwable == null ? msg : msg + ": " + throwable.getMessage();
        if (e == null) {
            Companion.getLOG$intellij_terraform().error(msg2);
        } else {
            Companion.getLOG$intellij_terraform().error(msg2, e);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            throw new AssertionError(msg2, e);
        }
    }

    static /* synthetic */ void logErrorAndFailInInternalMode$default(TfMetadataLoader tfMetadataLoader, String string, Throwable throwable, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        tfMetadataLoader.logErrorAndFailInInternalMode(string, throwable);
    }

    private final List<File> getSharedSchemas() {
        File metadataRepo;
        File file = Companion.getGlobalTerraformDir();
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        File terraform_d = file;
        ArrayList result = new ArrayList();
        File schemas = new File(terraform_d, "schemas");
        if (schemas.exists() && schemas.isDirectory()) {
            FileUtil.processFilesRecursively((File)schemas, arg_0 -> TfMetadataLoader.getSharedSchemas$lambda$12(arg_0 -> TfMetadataLoader.getSharedSchemas$lambda$11(result, arg_0), arg_0));
        }
        if ((metadataRepo = new File(terraform_d, "metadata-repo/terraform/model")).exists() && metadataRepo.isDirectory()) {
            FileUtil.processFilesRecursively((File)metadataRepo, arg_0 -> TfMetadataLoader.getSharedSchemas$lambda$14(arg_0 -> TfMetadataLoader.getSharedSchemas$lambda$13(result, arg_0), arg_0));
        }
        return result;
    }

    private final void parseFile(ObjectNode json, String fileName) {
        Object v4;
        String version;
        String type;
        block9: {
            ObjectNode schemasNode;
            type = null;
            version = null;
            ObjectNode objectNode = ExtensionsKt.obj(json, "schemas");
            if (objectNode == null) {
                objectNode = json;
            }
            if ((schemasNode = objectNode).has("format_version")) {
                type = "terraform-providers-schema-json";
                String string = schemasNode.get("format_version").textValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textValue(...)");
                version = string;
            } else {
                String string;
                String string2 = ExtensionsKt.string(schemasNode, "type");
                if (string2 == null) {
                    string2 = type = "unknown";
                }
                if ((string = ExtensionsKt.string(schemasNode, ".schema_version")) == null) {
                    string = "1";
                }
                version = string;
            }
            Iterable iterable = this.loaders;
            for (Object t : iterable) {
                VersionedMetadataLoader it = (VersionedMetadataLoader)t;
                boolean bl = false;
                if (!(it.isSupportedType(type) && it.isSupportedVersion(version))) continue;
                v4 = t;
                break block9;
            }
            v4 = null;
        }
        VersionedMetadataLoader loader = v4;
        if (loader == null) {
            String message = "Cannot find loader for model file content '" + fileName + "', type: '" + type + "', version: '" + version + "'";
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode() || application.isInternal()) {
                Companion.getLOG$intellij_terraform().error(message);
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string = message;
                    throw new AssertionError((Object)string);
                }
            }
            Companion.getLOG$intellij_terraform().warn(message);
            return;
        }
        loader.load(this.context, json, fileName);
    }

    private static final boolean loadFrom$lambda$0(TypeModel $tmp, ResourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeModel.getResourceType$default($tmp, it.getType(), null, 2, null) == null;
    }

    private static final boolean loadFrom$lambda$1(TypeModel $tmp, DataSourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeModel.getDataSourceType$default($tmp, it.getType(), null, 2, null) == null;
    }

    private static final boolean loadFrom$lambda$2(TypeModel $tmp, ProviderType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeModel.getProviderType$default($tmp, it.getType(), null, 2, null) == null;
    }

    private static final boolean loadFrom$lambda$3(TypeModel $tmp, EphemeralType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TypeModel.getEphemeralType$default($tmp, it.getType(), null, 2, null) == null;
    }

    private static final boolean getSharedSchemas$lambda$11(ArrayList $result, File it) {
        if (it.isFile()) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith((String)string, (String)".json", (boolean)true)) {
                $result.add(it);
            }
        }
        return true;
    }

    private static final boolean getSharedSchemas$lambda$12(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getSharedSchemas$lambda$13(ArrayList $result, File it) {
        if (it.isFile()) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith((String)string, (String)".json", (boolean)true)) {
                $result.add(it);
            }
        }
        return true;
    }

    private static final boolean getSharedSchemas$lambda$14(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Logger LOG_delegate$lambda$17() {
        Logger logger = Logger.getInstance(TfMetadataLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\u00020\u00058@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/model/loader/TfMetadataLoader$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_terraform", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "ModelResourcesPrefix", "", "getResource", "Ljava/io/InputStream;", "path", "getAllResourcesToLoad", "", "prefix", "getAllResourcesToLoad$intellij_terraform", "loadList", "", "name", "getGlobalTerraformDir", "Ljava/io/File;", "loadExternalResource", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfMetadataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfMetadataLoader.kt\norg/intellij/terraform/config/model/loader/TfMetadataLoader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1563#2:300\n1634#2,3:301\n1563#2:304\n1634#2,3:305\n1563#2:308\n1634#2,3:309\n1563#2:313\n1634#2,3:314\n774#2:317\n865#2,2:318\n295#2,2:320\n1#3:312\n*S KotlinDebug\n*F\n+ 1 TfMetadataLoader.kt\norg/intellij/terraform/config/model/loader/TfMetadataLoader$Companion\n*L\n209#1:300\n209#1:301,3\n210#1:304\n210#1:305,3\n211#1:308\n211#1:309,3\n228#1:313\n228#1:314,3\n228#1:317\n228#1:318,2\n255#1:320,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_terraform() {
            Lazy lazy = LOG$delegate;
            return (Logger)lazy.getValue();
        }

        @Nullable
        public final InputStream getResource(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return TfMetadataLoader.class.getResourceAsStream(path);
        }

        @NotNull
        public final Collection<String> getAllResourcesToLoad$intellij_terraform(@NotNull String prefix) {
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            ArrayList<CallSite> resources = new ArrayList<CallSite>();
            Iterable $this$map$iv = this.loadList(prefix + "/providers.list");
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(prefix + "/providers/" + it + ".json");
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)resources);
            $this$map$iv = this.loadList(prefix + "/provisioners.list");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(prefix + "/provisioners/" + it + ".json");
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)resources);
            $this$map$iv = this.loadList(prefix + "/backends.list");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(prefix + "/backends/" + it + ".json");
            }
            CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)resources);
            resources.add((CallSite)((Object)(prefix + "/functions.json")));
            return resources;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> loadList(String name) {
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                String it;
                void $this$mapTo$iv$iv;
                InputStream stream = this.getResource(name);
                if (stream == null) {
                    String message = "Cannot read list '" + name + "': resource not found";
                    this.getLOG$intellij_terraform().warn(message);
                    Application application = ApplicationManager.getApplication();
                    if ((application.isUnitTestMode() || application.isInternal()) && _Assertions.ENABLED) {
                        boolean $i$a$-assert-TfMetadataLoader$Companion$loadList$22 = false;
                        String $i$a$-assert-TfMetadataLoader$Companion$loadList$22 = message;
                        throw new AssertionError((Object)$i$a$-assert-TfMetadataLoader$Companion$loadList$22);
                    }
                    return SetsKt.emptySet();
                }
                Object $i$a$-assert-TfMetadataLoader$Companion$loadList$22 = new InputStreamReader(stream, Charsets.UTF_8);
                int n = 8192;
                Iterable $this$map$iv = TextStreamsKt.readLines((Reader)($i$a$-assert-TfMetadataLoader$Companion$loadList$22 instanceof BufferedReader ? (BufferedReader)$i$a$-assert-TfMetadataLoader$Companion$loadList$22 : new BufferedReader((Reader)$i$a$-assert-TfMetadataLoader$Companion$loadList$22, n)));
                boolean $i$f$map = false;
                $i$a$-assert-TfMetadataLoader$Companion$loadList$22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!(!(((CharSequence)it).length() == 0))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List lines = (List)destination$iv$iv;
                return new LinkedHashSet(lines);
            }
            catch (Exception e) {
                this.getLOG$intellij_terraform().warn("Cannot read 'ignored-references.list': " + e.getMessage());
                return SetsKt.emptySet();
            }
        }

        @Nullable
        public final File getGlobalTerraformDir() {
            File terraform_d;
            if (!AdvancedSettings.Companion.getBoolean("org.intellij.terraform.use.global.meta")) {
                return null;
            }
            if (SystemInfo.isWindows) {
                String string = System.getenv("APPDATA");
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v1 = new File(it, "terraform.d");
                } else {
                    v1 = null;
                }
            } else {
                String string = SystemProperties.getUserHome();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
                String userHome = string;
                v1 = terraform_d = new File(userHome, ".terraform.d");
            }
            if (terraform_d == null || !terraform_d.exists() || !terraform_d.isDirectory()) {
                return null;
            }
            return terraform_d;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final InputStream loadExternalResource(@NotNull String name) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                v0 = this.getGlobalTerraformDir();
                if (v0 == null) ** GOTO lbl-1000
                tf = v0;
                $i$a$-let-TfMetadataLoader$Companion$loadExternalResource$stream$1 = false;
                var5_4 /* !! */  = new File[]{new File(tf, "schemas/" + name), new File(tf, "metadata-repo/terraform/model-external/" + name)};
                var5_4 /* !! */  = CollectionsKt.listOf((Object[])var5_4 /* !! */ );
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (File)element$iv;
                    $i$a$-firstOrNull-TfMetadataLoader$Companion$loadExternalResource$stream$1$1 = false;
                    if (!(it.exists() != false && it.isFile() != false)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            var11_13 = v1;
            if (var11_13 != null) {
                it = var11_13;
                $i$a$-let-TfMetadataLoader$Companion$loadExternalResource$stream$1$2 = false;
                try {
                    var8_9 = new FileInputStream(it);
                }
                catch (Exception e) {
                    TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Cannot open stream for file '" + it.getAbsolutePath() + "'", (Throwable)e);
                    var8_9 = null;
                }
                v2 = var8_9;
            } else {
                v2 = null;
            }
            v0 = v2;
            if (v2 != null) {
                v3 = (InputStream)v0;
            } else lbl-1000:
            // 2 sources

            {
                v3 = this.getResource("/terraform/model-external/" + name);
            }
            stream = v3;
            return stream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

