/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.Argument;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.VariadicArgument;
import org.intellij.terraform.config.model.loader.BaseLoaderV2;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.TfMetadataLoader;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/config/model/loader/FunctionsLoaderV2;", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "<init>", "()V", "isSupportedType", "", "type", "", "isSupportedVersion", "version", "load", "", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nloaders_v2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loaders_v2.kt\norg/intellij/terraform/config/model/loader/FunctionsLoaderV2\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,306:1\n1617#2,9:307\n1869#2:316\n1870#2:318\n1626#2:319\n1563#2:320\n1634#2,3:321\n1#3:317\n37#4:324\n36#4,3:325\n*S KotlinDebug\n*F\n+ 1 loaders_v2.kt\norg/intellij/terraform/config/model/loader/FunctionsLoaderV2\n*L\n288#1:307,9\n288#1:316\n288#1:318\n288#1:319\n291#1:320\n291#1:321,3\n288#1:317\n299#1:324\n299#1:325,3\n*E\n"})
public final class FunctionsLoaderV2
implements VersionedMetadataLoader {
    @Override
    public boolean isSupportedType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"functions");
    }

    @Override
    public boolean isSupportedVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return Intrinsics.areEqual((Object)version, (Object)"2");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(@NotNull LoadContext context, @NotNull ObjectNode json, @NotNull String fileName) {
        ObjectNode function_schema;
        ObjectNode functions;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        BaseLoaderV2 base = BaseLoaderV2.INSTANCE;
        LoadingModel model = context.getModel();
        ObjectNode objectNode = ExtensionsKt.obj(json, "schemas");
        if (objectNode == null) {
            objectNode = json;
        }
        if ((functions = ExtensionsKt.obj(function_schema = objectNode, "schema")) == null) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No functions schema in file '" + fileName + "'");
            return;
        }
        if (model.getLoaded().containsKey("functions")) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Functions definitions already loaded from '" + model.getLoaded().get("functions") + "'");
            return;
        }
        model.getLoaded().put("functions", fileName);
        Iterator iterator = functions.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            VariadicArgument variadicArgument;
            void $this$mapTo$iv$iv;
            List list;
            ObjectNode objectNode2;
            Iterable $this$mapNotNullTo$iv$iv;
            Collection destination$iv$iv;
            Map.Entry entry = (Map.Entry)iterator2.next();
            Intrinsics.checkNotNull((Object)entry);
            String name = (String)entry.getKey();
            JsonNode v = (JsonNode)entry.getValue();
            if (!(v instanceof ObjectNode)) continue;
            String string = ExtensionsKt.string((ObjectNode)v, "ReturnType");
            Intrinsics.checkNotNull((Object)string);
            Type returnType = base.parseType(context, string);
            ArrayNode arrayNode = ExtensionsKt.array((ObjectNode)v, "Parameters");
            if (arrayNode != null) {
                Iterable $this$mapNotNull$iv = (Iterable)arrayNode;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                objectNode2 = $this$forEach$iv$iv$iv.iterator();
                while (objectNode2.hasNext()) {
                    ObjectNode it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = objectNode2.next();
                    boolean bl = false;
                    JsonNode it = (JsonNode)element$iv$iv;
                    boolean bl2 = false;
                    if ((it instanceof ObjectNode ? (ObjectNode)it : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List parameters = list;
            ObjectNode variadic = ExtensionsKt.obj((ObjectNode)v, "VariadicParameter");
            Iterable $this$map$iv = parameters;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                objectNode2 = (ObjectNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = ExtensionsKt.string((ObjectNode)it, "Name");
                Type type = base.parseType(context, ExtensionsKt.string((ObjectNode)it, "Type"));
                collection.add(new Argument(type, string2));
            }
            List args = (List)destination$iv$iv;
            if (variadic != null) {
                ObjectNode it;
                boolean bl = false;
                String $i$f$mapTo2 = ExtensionsKt.string(it, "Name");
                Type type = base.parseType(context, ExtensionsKt.string(it, "Type"));
                variadicArgument = new VariadicArgument(type, $i$f$mapTo2);
            } else {
                variadicArgument = null;
            }
            VariadicArgument va = variadicArgument;
            List<TfFunction> list2 = model.getFunctions();
            Intrinsics.checkNotNull((Object)name);
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Argument[] argumentArray = thisCollection$iv.toArray(new Argument[0]);
            list2.add(new TfFunction(LoadersKt.pool(name, context), returnType, Arrays.copyOf(argumentArray, argumentArray.length), null, va, null, 40, null));
        }
    }
}

