/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model.loader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.Argument;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.VariadicArgument;
import org.intellij.terraform.config.model.loader.BaseLoaderV1;
import org.intellij.terraform.config.model.loader.LoadContext;
import org.intellij.terraform.config.model.loader.LoadersKt;
import org.intellij.terraform.config.model.loader.LoadingModel;
import org.intellij.terraform.config.model.loader.TfMetadataLoader;
import org.intellij.terraform.config.model.loader.VersionedMetadataLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/config/model/loader/FunctionsLoaderV1;", "Lorg/intellij/terraform/config/model/loader/VersionedMetadataLoader;", "<init>", "()V", "isSupportedType", "", "type", "", "isSupportedVersion", "version", "load", "", "context", "Lorg/intellij/terraform/config/model/loader/LoadContext;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "fileName", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nloaders_v1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/FunctionsLoaderV1\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,315:1\n1#2:316\n1#2:327\n1617#3,9:317\n1869#3:326\n1870#3:328\n1626#3:329\n1563#3:330\n1634#3,3:331\n1563#3:334\n1634#3,3:335\n37#4:338\n36#4,3:339\n*S KotlinDebug\n*F\n+ 1 loaders_v1.kt\norg/intellij/terraform/config/model/loader/FunctionsLoaderV1\n*L\n304#1:327\n304#1:317,9\n304#1:326\n304#1:328\n304#1:329\n304#1:330\n304#1:331,3\n304#1:334\n304#1:335,3\n310#1:338\n310#1:339,3\n*E\n"})
public final class FunctionsLoaderV1
implements VersionedMetadataLoader {
    @Override
    public boolean isSupportedType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"functions");
    }

    @Override
    public boolean isSupportedVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return Intrinsics.areEqual((Object)version, (Object)"1");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load(@NotNull LoadContext context, @NotNull ObjectNode json, @NotNull String fileName) {
        ObjectNode function_schema;
        ObjectNode functions;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        LoadingModel model = context.getModel();
        ObjectNode objectNode = ExtensionsKt.obj(json, "schemas");
        if (objectNode == null) {
            objectNode = json;
        }
        if ((functions = ExtensionsKt.obj(function_schema = objectNode, "schema")) == null) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("No functions schema in file '" + fileName + "'");
            return;
        }
        if (model.getLoaded().containsKey("functions")) {
            TfMetadataLoader.Companion.getLOG$intellij_terraform().warn("Functions definitions already loaded from '" + model.getLoaded().get("functions") + "'");
            return;
        }
        model.getLoaded().put("functions", fileName);
        Iterator iterator = functions.fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Type it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$mapNotNullTo$iv$iv;
            Map.Entry entry = (Map.Entry)iterator2.next();
            Intrinsics.checkNotNull((Object)entry);
            String k = (String)entry.getKey();
            JsonNode v = (JsonNode)entry.getValue();
            if (!(v instanceof ObjectNode)) continue;
            boolean bl = StringsKt.equals$default((String)ExtensionsKt.string((ObjectNode)v, "Name"), (String)k, (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FunctionsLoaderV1$load$22 = false;
                String $i$a$-assert-FunctionsLoaderV1$load$22 = "Name mismatch: " + k + " != " + ExtensionsKt.string((ObjectNode)v, "Name");
                throw new AssertionError((Object)$i$a$-assert-FunctionsLoaderV1$load$22);
            }
            String string = ExtensionsKt.string((ObjectNode)v, "ReturnType");
            Intrinsics.checkNotNull((Object)string);
            Type returnType = BaseLoaderV1.INSTANCE.parseType(context, string);
            ArrayNode arrayNode = ExtensionsKt.array((ObjectNode)v, "ArgTypes");
            Intrinsics.checkNotNull((Object)arrayNode);
            Argument[] $this$mapNotNull$iv = (Argument[])arrayNode;
            boolean $i$f$mapNotNull = false;
            Argument[] argumentArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl2 = false;
                JsonNode it2 = (JsonNode)element$iv$iv;
                boolean bl3 = false;
                if (it2.textValue() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                object = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(BaseLoaderV1.INSTANCE.parseType(context, (String)((Object)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Type)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(new Argument(it, null, 2, null));
            }
            List args = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Boolean bl7 = ExtensionsKt.boolean((ObjectNode)v, "Variadic");
            boolean variadic = bl7 != null ? bl7 : false;
            VariadicArgument va = null;
            if (variadic) {
                va = new VariadicArgument(BaseLoaderV1.INSTANCE.parseType(context, ExtensionsKt.string((ObjectNode)v, "VariadicType")), null, 2, null);
            }
            List<TfFunction> list = model.getFunctions();
            Intrinsics.checkNotNull((Object)k);
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            argumentArray = thisCollection$iv.toArray(new Argument[0]);
            list.add(new TfFunction(LoadersKt.pool(k, context), returnType, Arrays.copyOf(argumentArray, argumentArray.length), null, va, null, 40, null));
        }
    }
}

