/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import java.net.IDN;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u001e\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/model/RegistryModuleUtil;", "", "<init>", "()V", "KnownGitHosts", "", "", "parseRegistryModule", "Lorg/intellij/terraform/config/model/RegistryModuleUtil$RegistryModule;", "source", "isValidHost", "", "given", "parseFriendlyHost", "Lkotlin/Pair;", "isValidUrlHost", "host", "isValidUrlHostPart", "part", "nameSubRe", "providerSubRe", "ModuleSourceRE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "urlLabelEndSubRe", "urlLabelMidSubRe", "urlLabelUnicodeSubRe", "hostLabelSubRe", "HostLabelSubRe", "RegistryModule", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nRegistryModuleUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryModuleUtil.kt\norg/intellij/terraform/config/model/RegistryModuleUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n58#2:119\n36#2,2:120\n1740#3,3:122\n*S KotlinDebug\n*F\n+ 1 RegistryModuleUtil.kt\norg/intellij/terraform/config/model/RegistryModuleUtil\n*L\n42#1:119\n42#1:120,2\n76#1:122,3\n*E\n"})
public final class RegistryModuleUtil {
    @NotNull
    public static final RegistryModuleUtil INSTANCE = new RegistryModuleUtil();
    @NotNull
    private static final Set<String> KnownGitHosts;
    @NotNull
    private static final String nameSubRe = "[0-9A-Za-z](?:[0-9A-Za-z-_]{0,62}[0-9A-Za-z])?";
    @NotNull
    private static final String providerSubRe = "[0-9a-z]{1,64}";
    private static final Pattern ModuleSourceRE;
    @NotNull
    private static final String urlLabelEndSubRe = "[0-9A-Za-z]";
    @NotNull
    private static final String urlLabelMidSubRe = "[0-9A-Za-z-]";
    @NotNull
    private static final String urlLabelUnicodeSubRe = "[^[:ascii:]]";
    @NotNull
    private static final String hostLabelSubRe;
    private static final Pattern HostLabelSubRe;

    private RegistryModuleUtil() {
    }

    @Nullable
    public final RegistryModule parseRegistryModule(@NotNull String source) {
        Matcher m;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Pair<String, String> pair = this.parseFriendlyHost(source);
        String host = (String)pair.component1();
        String rest = (String)pair.component2();
        if (host != null) {
            String string = host;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (KnownGitHosts.contains(string2)) {
                return null;
            }
            if (!this.isValidHost(host)) {
                return null;
            }
        }
        if (!(m = ModuleSourceRE.matcher(rest)).find()) {
            return null;
        }
        String string = m.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        String string3 = m.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
        String string4 = m.group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
        return new RegistryModule(host, string, string3, string4, m.group(4));
    }

    private final boolean isValidHost(String given) {
        char[] cArray = new char[]{':'};
        List split = StringsKt.split$default((CharSequence)given, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        String host = (String)split.get(0);
        if (split.size() == 2) {
            Integer n = StringsKt.toIntOrNull((String)((String)split.get(1)));
            if (n == null) {
                return false;
            }
            int port = n;
            if (port > 65535) {
                return false;
            }
        }
        if (((CharSequence)host).length() == 0) {
            return false;
        }
        Object object = new char[]{'.'};
        List parts = StringsKt.split$default((CharSequence)host, (char[])object, (boolean)false, (int)0, (int)6, null);
        object = parts.iterator();
        while (object.hasNext()) {
            String part = (String)object.next();
            if (((CharSequence)part).length() == 0) {
                return false;
            }
            if (!StringsKt.startsWith$default((String)part, (String)"xn--", (boolean)false, (int)2, null)) continue;
            return false;
        }
        try {
            IDN.toASCII(host);
        }
        catch (Exception e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Error converting IDN to ASCII", (Throwable)e);
            return false;
        }
        return true;
    }

    private final Pair<String, String> parseFriendlyHost(String source) {
        Pair pair;
        char[] cArray = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)source, (char[])cArray, (boolean)false, (int)2, (int)2, null);
        if (parts.isEmpty()) {
            return TuplesKt.to(null, (Object)"");
        }
        String host = (String)parts.get(0);
        if (this.isValidUrlHost(host)) {
            String string = (String)CollectionsKt.getOrNull((List)parts, (int)1);
            if (string == null) {
                string = "";
            }
            pair = TuplesKt.to((Object)host, (Object)string);
        } else {
            pair = TuplesKt.to(null, (Object)source);
        }
        return pair;
    }

    private final boolean isValidUrlHost(String host) {
        boolean bl;
        block9: {
            int indexOfColon = StringsKt.indexOf$default((CharSequence)host, (char)':', (int)0, (boolean)false, (int)6, null);
            if (indexOfColon != -1) {
                if (StringsKt.lastIndexOf$default((CharSequence)host, (char)':', (int)0, (boolean)false, (int)6, null) != indexOfColon) {
                    return false;
                }
                if (indexOfColon == host.length() - 1) {
                    return false;
                }
                String string = host.substring(indexOfColon + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                Integer n = StringsKt.toIntOrNull((String)string);
                if (n == null) {
                    return false;
                }
                int port = n;
                if (port > 65535) {
                    return false;
                }
                String string2 = host.substring(0, indexOfColon);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                return this.isValidUrlHost(string2);
            }
            char[] cArray = new char[]{'.'};
            List parts = StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() < 2) {
                return false;
            }
            Iterable $this$all$iv = parts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isValidUrlHostPart(it)) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isValidUrlHostPart(String part) {
        int length = part.length();
        if (length == 0 || length > 63) {
            return false;
        }
        Matcher matcher = HostLabelSubRe.matcher(part);
        return matcher.find();
    }

    static {
        Object[] objectArray = new String[]{"github.com", "bitbucket.org"};
        KnownGitHosts = SetsKt.setOf((Object[])objectArray);
        ModuleSourceRE = Pattern.compile("^([0-9A-Za-z](?:[0-9A-Za-z-_]{0,62}[0-9A-Za-z])?)/([0-9A-Za-z](?:[0-9A-Za-z-_]{0,62}[0-9A-Za-z])?)/([0-9a-z]{1,64})(?://(.*))?$");
        hostLabelSubRe = "(?:[0-9A-Za-z]|[^[:ascii:]])(?:(?:[0-9A-Za-z-]|[^[:ascii:]]){0,61}(?:[0-9A-Za-z]|[^[:ascii:]]))?";
        HostLabelSubRe = Pattern.compile("^" + hostLabelSubRe + "$", 2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/model/RegistryModuleUtil$RegistryModule;", "", "host", "", "namespace", "name", "provider", "submodule", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getNamespace", "getName", "getProvider", "getSubmodule", "toString", "formatWithPrefix", "hostPrefix", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "intellij.terraform"})
    public static final class RegistryModule {
        @Nullable
        private final String host;
        @NotNull
        private final String namespace;
        @NotNull
        private final String name;
        @NotNull
        private final String provider;
        @Nullable
        private final String submodule;

        public RegistryModule(@Nullable String host, @NotNull String namespace, @NotNull String name, @NotNull String provider, @Nullable String submodule) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.host = host;
            this.namespace = namespace;
            this.name = name;
            this.provider = provider;
            this.submodule = submodule;
        }

        @Nullable
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getProvider() {
            return this.provider;
        }

        @Nullable
        public final String getSubmodule() {
            return this.submodule;
        }

        @NotNull
        public String toString() {
            String prefix = this.host != null ? this.host + "/" : "";
            return this.formatWithPrefix(prefix);
        }

        private final String formatWithPrefix(String hostPrefix) {
            String suffix = this.submodule != null ? "//" + this.submodule : "";
            String str = hostPrefix + this.namespace + "/" + this.name + "/" + this.provider + suffix;
            return str;
        }

        @Nullable
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final String component2() {
            return this.namespace;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final String component4() {
            return this.provider;
        }

        @Nullable
        public final String component5() {
            return this.submodule;
        }

        @NotNull
        public final RegistryModule copy(@Nullable String host, @NotNull String namespace, @NotNull String name, @NotNull String provider, @Nullable String submodule) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            return new RegistryModule(host, namespace, name, provider, submodule);
        }

        public static /* synthetic */ RegistryModule copy$default(RegistryModule registryModule, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = registryModule.host;
            }
            if ((n & 2) != 0) {
                string2 = registryModule.namespace;
            }
            if ((n & 4) != 0) {
                string3 = registryModule.name;
            }
            if ((n & 8) != 0) {
                string4 = registryModule.provider;
            }
            if ((n & 0x10) != 0) {
                string5 = registryModule.submodule;
            }
            return registryModule.copy(string, string2, string3, string4, string5);
        }

        public int hashCode() {
            int result = this.host == null ? 0 : this.host.hashCode();
            result = result * 31 + this.namespace.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.provider.hashCode();
            result = result * 31 + (this.submodule == null ? 0 : this.submodule.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegistryModule)) {
                return false;
            }
            RegistryModule registryModule = (RegistryModule)other;
            if (!Intrinsics.areEqual((Object)this.host, (Object)registryModule.host)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.namespace, (Object)registryModule.namespace)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)registryModule.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.provider, (Object)registryModule.provider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.submodule, (Object)registryModule.submodule);
        }
    }
}

