/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.hil.psi.ILExpression;
import org.intellij.terraform.hil.psi.TypeCachedValueProvider;
import org.intellij.terraform.hil.psi.impl.ILExpressionBaseKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n*\u0004\u0018\u00010\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0000\u001a\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0000\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u001a\u001b\u0010\u0019\u001a\u0004\u0018\u00010\r*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"getTerraformModule", "Lorg/intellij/terraform/config/model/Module;", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "getTerraformSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/psi/PsiElement;", "getProviderFQName", "", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getType", "Lorg/intellij/terraform/config/model/Type;", "Lorg/intellij/terraform/hcl/psi/common/BaseExpression;", "isInTerraformFile", "", "ensureHavePrefix", "prefix", "isNotEmpty", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "obj", "name", "array", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "string", "number", "", "boolean", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.terraform"})
public final class ExtensionsKt {
    @NotNull
    public static final Module getTerraformModule(@NotNull HCLElement $this$getTerraformModule) {
        Intrinsics.checkNotNullParameter((Object)$this$getTerraformModule, (String)"<this>");
        PsiFile psiFile = $this$getTerraformModule.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        boolean bl = file instanceof HCLFile;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return Module.Companion.getModule(file);
    }

    @NotNull
    public static final GlobalSearchScope getTerraformSearchScope(@NotNull PsiElement $this$getTerraformSearchScope) {
        Intrinsics.checkNotNullParameter((Object)$this$getTerraformSearchScope, (String)"<this>");
        PsiFile psiFile = $this$getTerraformSearchScope.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile file = psiFile;
        PsiDirectory directory = file.getContainingDirectory();
        if (directory == null && $this$getTerraformSearchScope instanceof ILExpression) {
            PsiFile psiFile2 = InjectedLanguageManager.getInstance((Project)((ILExpression)$this$getTerraformSearchScope).getProject()).getTopLevelFile($this$getTerraformSearchScope);
            Object object = directory = psiFile2 != null ? psiFile2.getContainingDirectory() : null;
        }
        if (directory == null) {
            VirtualFile virtualFile = file.getVirtualFile();
            Object vf = virtualFile != null ? VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile) : null;
            VirtualFile virtualFile2 = vf;
            if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
                return globalSearchScope;
            }
            VirtualFile parent = virtualFile2;
            GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((Project)file.getProject(), (VirtualFile)parent, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((PsiDirectory)directory, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
        return globalSearchScope;
    }

    @Nullable
    public static final String getProviderFQName(@NotNull HCLBlock $this$getProviderFQName) {
        String als;
        HCLExpression value;
        Intrinsics.checkNotNullParameter((Object)$this$getProviderFQName, (String)"<this>");
        String string = UtilKt.getNameElementUnquoted($this$getProviderFQName, 1);
        if (string == null) {
            return null;
        }
        String tp = string;
        HCLElement hCLElement = $this$getProviderFQName.getObject();
        HCLExpression hCLExpression = hCLElement != null && (hCLElement = hCLElement.findProperty("alias")) != null ? hCLElement.getValue() : (value = null);
        String string2 = value instanceof HCLStringLiteral ? ((HCLStringLiteral)value).getValue() : (als = value instanceof HCLIdentifier ? ((HCLIdentifier)value).getId() : null);
        if (als != null) {
            return tp + "." + als;
        }
        return tp;
    }

    @Nullable
    public static final Type getType(@Nullable BaseExpression $this$getType) {
        if ($this$getType == null) {
            return null;
        }
        return TypeCachedValueProvider.Companion.getType($this$getType);
    }

    public static final boolean isInTerraformFile(@NotNull BaseExpression $this$isInTerraformFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isInTerraformFile, (String)"<this>");
        HCLElement hCLElement = ILExpressionBaseKt.getHCLHost($this$isInTerraformFile);
        return TfPsiPatterns.INSTANCE.getTerraformFile().accepts(hCLElement != null ? hCLElement.getContainingFile() : null);
    }

    @NotNull
    public static final String ensureHavePrefix(@NotNull String $this$ensureHavePrefix, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureHavePrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.startsWith$default((String)$this$ensureHavePrefix, (String)prefix, (boolean)false, (int)2, null) ? $this$ensureHavePrefix : prefix + $this$ensureHavePrefix;
    }

    public static final boolean isNotEmpty(@NotNull ObjectNode $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return $this$isNotEmpty.size() > 0;
    }

    @Nullable
    public static final ObjectNode obj(@NotNull ObjectNode $this$obj, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$obj, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonNode jsonNode = $this$obj.get(name);
        return jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
    }

    @Nullable
    public static final ArrayNode array(@NotNull ObjectNode $this$array, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$array, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonNode jsonNode = $this$array.get(name);
        return jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
    }

    @Nullable
    public static final String string(@NotNull ObjectNode $this$string, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$string, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonNode jsonNode = $this$string.get(name);
        return jsonNode != null ? jsonNode.textValue() : null;
    }

    @Nullable
    public static final Number number(@NotNull ObjectNode $this$number, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$number, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonNode jsonNode = $this$number.get(name);
        return jsonNode != null ? jsonNode.numberValue() : null;
    }

    @Nullable
    public static final Boolean boolean(@NotNull ObjectNode $this$boolean, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$boolean, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonNode jsonNode = $this$boolean.get(name);
        if (jsonNode == null) {
            return null;
        }
        JsonNode node = jsonNode;
        if (!node.isBoolean()) {
            return null;
        }
        return node.booleanValue();
    }
}

