/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.Type_modelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLBooleanLiteral;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLFile;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLNullLiteral;
import org.intellij.terraform.hcl.psi.HCLNumberLiteral;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.HCLValue;
import org.intellij.terraform.hcl.psi.impl.HCLStringLiteralMixin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/intellij/terraform/config/inspection/TfVARSIncorrectElementInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getQuoteFix", "Lcom/intellij/modcommand/ModCommandAction;", "element", "Lorg/intellij/terraform/hcl/psi/HCLValue;", "MyEV", "ConvertToHCLStringQuickFix", "intellij.terraform"})
public final class TfVARSIncorrectElementInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!TfPsiPatterns.INSTANCE.getTerraformVariablesFile().accepts((Object)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new MyEV(holder);
    }

    private final ModCommandAction getQuoteFix(HCLValue element) {
        if (element instanceof HCLStringLiteralMixin || element instanceof HCLIdentifier || element instanceof HCLNullLiteral || element instanceof HCLBooleanLiteral) {
            return (ModCommandAction)new ConvertToHCLStringQuickFix(element);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/TfVARSIncorrectElementInspection$ConvertToHCLStringQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiElement;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    public static final class ConvertToHCLStringQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        public ConvertToHCLStringQuickFix(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("tfvars.unsupported.element.inspection.convert.to.double.quoted.string.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            String text = null;
            PsiElement psiElement = element;
            if (psiElement instanceof HCLIdentifier || psiElement instanceof HCLNullLiteral || psiElement instanceof HCLBooleanLiteral) {
                String string = ((HCLValue)element).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                text = string;
            } else if (psiElement instanceof HCLStringLiteral) {
                String string = ((HCLStringLiteral)element).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                text = string;
            } else {
                return;
            }
            Project project = context.project();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
            element.replace((PsiElement)HCLElementGenerator.createStringLiteral$default(new HCLElementGenerator(project), text, null, 2, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/TfVARSIncorrectElementInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfVARSIncorrectElementInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "visitProperty", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            ProgressIndicatorProvider.checkCanceled();
            if (!(block.getParent() instanceof HCLFile)) {
                return;
            }
            this.holder.registerProblem((PsiElement)block, HCLBundle.message("tfvars.unsupported.element.inspection.only.key.values.allowed.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }

        @Override
        public void visitProperty(@NotNull HCLProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            HCLExpression hCLExpression = property.getValue();
            HCLValue hCLValue = hCLExpression instanceof HCLValue ? (HCLValue)hCLExpression : null;
            if (hCLValue == null) {
                return;
            }
            HCLValue value = hCLValue;
            if (property.getParent() instanceof HCLFile) {
                if (!(value instanceof HCLNumberLiteral) && !(value instanceof HCLObject) && !(value instanceof HCLArray) && value instanceof HCLStringLiteral && ((HCLStringLiteral)value).getQuoteSymbol() != '\"') {
                    this.holder.problem((PsiElement)value, HCLBundle.message("tfvars.unsupported.element.inspection.illegal.value.type.error.message", new Object[0])).maybeFix(TfVARSIncorrectElementInspection.this.getQuoteFix(value)).register();
                }
                if (property.getNameElement() instanceof HCLStringLiteral) {
                    this.holder.registerProblem((PsiElement)property.getNameElement(), HCLBundle.message("tfvars.unsupported.element.inspection.no.quotes.in.argument.name.error.message", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                }
                String string = property.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String vName = StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
                List<Variable> variables = ExtensionsKt.getTerraformModule(property).findVariables(vName);
                if (variables.isEmpty()) {
                    Object[] objectArray = new Object[]{vName};
                    this.holder.registerProblem((PsiElement)property.getNameElement(), HCLBundle.message("tfvars.unsupported.element.inspection.undefined.variable.error.message", objectArray), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                } else {
                    String string2 = property.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, (char)'.', (boolean)false, (int)2, null)) {
                        HCLExpression hCLExpression2 = ((Variable)CollectionsKt.first(variables)).getTypeExpression();
                        HCLValue hCLValue2 = hCLExpression2 instanceof HCLValue ? (HCLValue)hCLExpression2 : null;
                        String expected = hCLValue2 != null ? hCLValue2.getName() : null;
                        Type actual = ExtensionsKt.getType(value);
                        if (Intrinsics.areEqual((Object)expected, (Object)"string") && !CollectionsKt.contains((Iterable)Types.INSTANCE.getSimpleValueTypes(), (Object)actual) || Intrinsics.areEqual((Object)expected, (Object)"list") && !Type_modelKt.isListType(actual) || Intrinsics.areEqual((Object)expected, (Object)"map") && !Type_modelKt.isObjectType(actual)) {
                            String string3 = Intrinsics.areEqual((Object)expected, (Object)"string") ? HCLBundle.message("tfvars.unsupported.element.inspection.incorrect.variable.type.error.message.string.expected", new Object[0]) : "'" + expected + "'";
                            Intrinsics.checkNotNull((Object)string3);
                            String e = string3;
                            string3 = new Object[]{e};
                            this.holder.registerProblem((PsiElement)value, HCLBundle.message("tfvars.unsupported.element.inspection.incorrect.variable.type.error.message", (Object[])string3), new LocalQuickFix[0]);
                        }
                    }
                }
            }
        }
    }
}

