/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.inspection.HclUnusedElement;
import org.intellij.terraform.config.inspection.RemoveDataSourceQuickFix;
import org.intellij.terraform.config.inspection.RemoveLocalQuickFix;
import org.intellij.terraform.config.inspection.RemoveVariableQuickFix;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnusedElementsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "checkElement", "", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "isElementUnused", "name", "", "getHclUnusedElement", "Lorg/intellij/terraform/config/inspection/HclUnusedElement;", "TfVisitor", "intellij.terraform"})
public final class TfUnusedElementsInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new TfVisitor(holder);
    }

    private final void checkElement(ProblemsHolder holder, HCLElement element) {
        ProgressIndicatorProvider.checkCanceled();
        String string = org.intellij.terraform.hcl.psi.UtilKt.getElementName(element);
        if (string == null) {
            return;
        }
        String name = string;
        HclUnusedElement hclUnusedElement = this.getHclUnusedElement(element, name);
        if (hclUnusedElement == null) {
            return;
        }
        HclUnusedElement unused = hclUnusedElement;
        if (this.isElementUnused(element, name)) {
            PsiElement psiElement = HCLPsiUtil.INSTANCE.getIdentifierPsi(element);
            if (psiElement == null) {
                return;
            }
            PsiElement highlighted = psiElement;
            holder.problem(highlighted, unused.getInspectionMessage()).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix(unused.getQuickFix()).register();
        }
    }

    private final boolean isElementUnused(HCLElement element, String name) {
        ProgressIndicatorProvider.checkCanceled();
        Module module = ExtensionsKt.getTerraformModule(element);
        GlobalSearchScope searchScope = module.getTerraformModuleScope();
        PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.getInstance((Project)element.getProject()).isCheapEnoughToSearch(name, searchScope, element.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(...)");
        PsiSearchHelper.SearchCostResult costSearch = searchCostResult;
        if (costSearch != PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)element, (SearchScope)((SearchScope)searchScope), (boolean)false).findFirst() == null;
    }

    private final HclUnusedElement getHclUnusedElement(HCLElement element, String name) {
        return TfPsiPatterns.INSTANCE.getLocalProperty().accepts((Object)element) ? (HclUnusedElement)new HclUnusedElement(name, element){
            private final String inspectionMessage;
            private final ModCommandAction quickFix;
            {
                Object[] objectArray = new Object[]{$name};
                String string = HCLBundle.message("unused.local.inspection.error.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.inspectionMessage = string;
                this.quickFix = (ModCommandAction)new RemoveLocalQuickFix($element);
            }

            public String getInspectionMessage() {
                return this.inspectionMessage;
            }

            public ModCommandAction getQuickFix() {
                return this.quickFix;
            }
        } : (TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)element) ? (HclUnusedElement)new HclUnusedElement(name, element){
            private final String inspectionMessage;
            private final ModCommandAction quickFix;
            {
                Object[] objectArray = new Object[]{$name};
                String string = HCLBundle.message("unused.variable.inspection.error.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.inspectionMessage = string;
                this.quickFix = (ModCommandAction)new RemoveVariableQuickFix($element);
            }

            public String getInspectionMessage() {
                return this.inspectionMessage;
            }

            public ModCommandAction getQuickFix() {
                return this.quickFix;
            }
        } : (TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)element) ? (HclUnusedElement)new HclUnusedElement(name, element){
            private final String inspectionMessage;
            private final ModCommandAction quickFix;
            {
                Object[] objectArray = new Object[]{$name};
                String string = HCLBundle.message("unused.data.source.inspection.error.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.inspectionMessage = string;
                this.quickFix = (ModCommandAction)new RemoveDataSourceQuickFix($element);
            }

            public String getInspectionMessage() {
                return this.inspectionMessage;
            }

            public ModCommandAction getQuickFix() {
                return this.quickFix;
            }
        } : null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnusedElementsInspection$TfVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfUnusedElementsInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "visitProperty", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "intellij.terraform"})
    public final class TfVisitor
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public TfVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            TfUnusedElementsInspection.this.checkElement(this.holder, block);
        }

        @Override
        public void visitProperty(@NotNull HCLProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            TfUnusedElementsInspection.this.checkElement(this.holder, property);
        }
    }
}

