/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitAction;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.inspection.RemovePropertyQuickFix;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownPropertyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "TfPropertyVisitor", "intellij.terraform"})
public final class TfUnknownPropertyInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new TfPropertyVisitor(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/inspection/TfUnknownPropertyInspection$TfPropertyVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfUnknownPropertyInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitProperty", "", "property", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "getBlockOfProperty", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfUnknownPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfUnknownPropertyInspection.kt\norg/intellij/terraform/config/inspection/TfUnknownPropertyInspection$TfPropertyVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
    public final class TfPropertyVisitor
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public TfPropertyVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitProperty(@NotNull HCLProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super.visitProperty(property);
            HCLBlock hCLBlock = this.getBlockOfProperty(property);
            if (hCLBlock == null) {
                return;
            }
            HCLBlock hclBlock = hCLBlock;
            Map<String, PropertyOrBlockType> map = TfModelHelper.INSTANCE.getBlockProperties(hclBlock);
            if (map.isEmpty()) {
                boolean bl = false;
                return;
            }
            Map<String, PropertyOrBlockType> properties = map;
            String string = property.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String propertyName = string;
            if (!properties.containsKey(propertyName)) {
                Object[] objectArray = new Object[]{propertyName};
                this.holder.problem((PsiElement)property, HCLBundle.message("unknown.property.in.block.inspection.error.message", objectArray)).maybeFix(TfInitAction.Companion.createQuickFixNotInitialized(property)).fix((ModCommandAction)new RemovePropertyQuickFix(property)).register();
            }
        }

        private final HCLBlock getBlockOfProperty(HCLElement element) {
            HCLObject hclObject;
            PsiElement psiElement = element.getParent();
            HCLObject hCLObject = hclObject = psiElement instanceof HCLObject ? (HCLObject)psiElement : null;
            PsiElement psiElement2 = hCLObject != null ? hCLObject.getParent() : null;
            HCLBlock hclBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
            return TfPsiPatterns.INSTANCE.getRootBlock().accepts((Object)hclBlock) ? hclBlock : null;
        }
    }
}

