/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.inspection.TypeSpecificationValidator;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.model.Type_modelKt;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementGenerator;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.HCLValue;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/TfIncorrectVariableTypeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "ChangeVariableType", "intellij.terraform"})
public final class TfIncorrectVariableTypeInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/config/inspection/TfIncorrectVariableTypeInspection$ChangeVariableType;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "toType", "", "<init>", "(Ljava/lang/String;)V", "getToType", "()Ljava/lang/String;", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    private static final class ChangeVariableType
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String toType;

        public ChangeVariableType(@NotNull String toType) {
            Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
            this.toType = toType;
        }

        @NotNull
        public final String getToType() {
            return this.toType;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.toType};
            String string = HCLBundle.message("incorrect.variable.type.inspection.change.type.quick.fix.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            if (!(element instanceof HCLValue)) {
                return;
            }
            PsiElement psiElement = ((HCLValue)element).getParent();
            HCLProperty hCLProperty = psiElement instanceof HCLProperty ? (HCLProperty)psiElement : null;
            if (hCLProperty == null) {
                return;
            }
            HCLProperty property = hCLProperty;
            PsiElement psiElement2 = property.getParent();
            HCLObject hCLObject = psiElement2 instanceof HCLObject ? (HCLObject)psiElement2 : null;
            if (hCLObject == null) {
                return;
            }
            HCLObject obj = hCLObject;
            HCLProperty typeProperty = obj.findProperty(TypeModel.Companion.getVariableType().getName());
            if (typeProperty == null) {
                v2 = obj.addAfter(new HCLElementGenerator(project).createProperty("type", "\"" + this.toType + "\""), obj.getFirstChild());
            } else {
                HCLExpression hCLExpression = typeProperty.getValue();
                Intrinsics.checkNotNull((Object)hCLExpression);
                v2 = hCLExpression.replace(HCLElementGenerator.createStringLiteral$default(new HCLElementGenerator(project), this.toType, null, 2, null));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/inspection/TfIncorrectVariableTypeInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfIncorrectVariableTypeInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "checkVariableTypeDefinitionLegacy", "typePropertyValue", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "checkVariableTypeDefinition", "value", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (!TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)block)) {
                return;
            }
            HCLObject hCLObject = block.getObject();
            if (hCLObject == null) {
                return;
            }
            HCLObject obj = hCLObject;
            HCLProperty typeProperty = obj.findProperty(TypeModel.Companion.getVariableType().getName());
            HCLElement hCLElement = typeProperty;
            if (hCLElement == null || (hCLElement = hCLElement.getValue()) == null) {
                return;
            }
            HCLElement typePropertyValue = hCLElement;
            if (typePropertyValue instanceof HCLStringLiteral) {
                this.checkVariableTypeDefinitionLegacy(block, (HCLStringLiteral)typePropertyValue);
            } else {
                this.checkVariableTypeDefinition(block, (HCLExpression)typePropertyValue);
            }
        }

        private final void checkVariableTypeDefinitionLegacy(HCLBlock block, HCLStringLiteral typePropertyValue) {
            block15: {
                String string;
                Type actual;
                HCLValue value;
                String expected;
                block14: {
                    HCLElement hCLElement;
                    Object[] objectArray = new String[]{"string", "list", "map"};
                    List legacyAllowedValues = CollectionsKt.listOf((Object[])objectArray);
                    String string2 = typePropertyValue.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                    expected = string2;
                    if (!legacyAllowedValues.contains(expected)) {
                        Object[] objectArray2 = new Object[]{UtilKt.joinCommaOr(legacyAllowedValues)};
                        this.holder.registerProblem((PsiElement)typePropertyValue, HCLBundle.message("incorrect.variable.type.inspection.legacy.variable.error.message", objectArray2), new LocalQuickFix[0]);
                    }
                    if ((hCLElement = block.getObject()) == null || (hCLElement = hCLElement.findProperty(TypeModel.Companion.getVariableDefault().getName())) == null) {
                        return;
                    }
                    HCLElement defaultProperty = hCLElement;
                    HCLExpression hCLExpression = defaultProperty.getValue();
                    HCLValue hCLValue = hCLExpression instanceof HCLValue ? (HCLValue)hCLExpression : null;
                    if (hCLValue == null) {
                        return;
                    }
                    value = hCLValue;
                    Type type = ExtensionsKt.getType(value);
                    if (type == null) {
                        return;
                    }
                    actual = type;
                    if (Intrinsics.areEqual((Object)actual, (Object)Types.INSTANCE.getNull())) {
                        return;
                    }
                    if (Intrinsics.areEqual((Object)expected, (Object)"string") && !CollectionsKt.contains((Iterable)Types.INSTANCE.getSimpleValueTypes(), (Object)actual) || Intrinsics.areEqual((Object)expected, (Object)"list") && !Type_modelKt.isListType(actual)) break block14;
                    if (!Intrinsics.areEqual((Object)expected, (Object)"map") || Type_modelKt.isObjectType(actual)) break block15;
                }
                if (CollectionsKt.contains((Iterable)Types.INSTANCE.getSimpleValueTypes(), (Object)actual)) {
                    string = "string";
                } else if (Type_modelKt.isListType(actual)) {
                    string = "list";
                } else if (Type_modelKt.isObjectType(actual)) {
                    string = "map";
                } else {
                    Object[] objectArray = new Object[]{actual.getPresentableText(), expected};
                    this.holder.registerProblem((PsiElement)value, HCLBundle.message("incorrect.variable.type.inspection.type.mismatch.error.message", objectArray), new LocalQuickFix[0]);
                    return;
                }
                String to = string;
                Object[] objectArray = new Object[]{expected};
                String string3 = HCLBundle.message("incorrect.variable.type.inspection.type.mismatch.simplified.error.message", objectArray);
                objectArray = new LocalQuickFix[]{new ChangeVariableType(to)};
                this.holder.registerProblem((PsiElement)value, string3, (LocalQuickFix[])objectArray);
            }
        }

        private final void checkVariableTypeDefinition(HCLBlock block, HCLExpression value) {
            Type type = new TypeSpecificationValidator(this.holder, true, false, 4, null).getType(value);
            if (type == null) {
                return;
            }
            Type expected = type;
            HCLElement hCLElement = block.getObject();
            Object[] objectArray = hCLElement != null && (hCLElement = hCLElement.findProperty(TypeModel.Companion.getVariableDefault().getName())) != null ? hCLElement.getValue() : null;
            HCLValue hCLValue = objectArray instanceof HCLValue ? (HCLValue)objectArray : null;
            if (hCLValue == null) {
                return;
            }
            HCLValue defaultValue = hCLValue;
            Type type2 = ExtensionsKt.getType(defaultValue);
            if (type2 == null) {
                return;
            }
            Type actual = type2;
            if (Intrinsics.areEqual((Object)actual, (Object)Types.INSTANCE.getNull())) {
                return;
            }
            if (!Type_modelKt.isConvertibleTo(actual, expected)) {
                objectArray = new Object[]{actual.getPresentableText(), expected.getPresentableText()};
                this.holder.registerProblem((PsiElement)defaultValue, HCLBundle.message("incorrect.variable.type.inspection.type.mismatch.error.message", objectArray), new LocalQuickFix[0]);
            }
        }
    }
}

