/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.inspection.TfDuplicatedInspectionBase;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection;", "Lorg/intellij/terraform/config/inspection/TfDuplicatedInspectionBase;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getDuplicates", "", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "block", "getFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "duplicates", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;Ljava/util/List;)[Lcom/intellij/codeInspection/LocalQuickFix;", "MyEV", "DeleteOutputFix", "RenameOutputFix", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfDuplicatedOutputInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfDuplicatedOutputInspection.kt\norg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,96:1\n774#2:97\n865#2,2:98\n230#2,2:100\n1#3:102\n37#4:103\n36#4,3:104\n*S KotlinDebug\n*F\n+ 1 TfDuplicatedOutputInspection.kt\norg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection\n*L\n46#1:97\n46#1:98,2\n59#1:100,2\n69#1:103\n69#1:104,3\n*E\n"})
public final class TfDuplicatedOutputInspection
extends TfDuplicatedInspectionBase {
    @Override
    @NotNull
    public PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    /*
     * WARNING - void declaration
     */
    private final List<HCLBlock> getDuplicates(HCLBlock block) {
        void $this$filterTo$iv$iv;
        if (!TfPsiPatterns.INSTANCE.getOutputRootBlock().accepts((Object)block)) {
            return null;
        }
        boolean inOverride = TfPsiPatterns.INSTANCE.getConfigOverrideFile().accepts((Object)block.getContainingFile());
        if (inOverride) {
            return null;
        }
        Module module = ExtensionsKt.getTerraformModule(block);
        String string = UtilKt.getNameElementUnquoted(block, 1);
        if (string == null) {
            return null;
        }
        String name = string;
        Iterable $this$filter$iv = module.getDefinedOutputs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HCLBlock it = (HCLBlock)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)name, (Object)UtilKt.getNameElementUnquoted(it, 1)) && !TfPsiPatterns.INSTANCE.getConfigOverrideFile().accepts((Object)it.getContainingFile()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List same = (List)destination$iv$iv;
        if (same.isEmpty()) {
            return null;
        }
        if (same.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((List)same), (Object)block)) {
            return null;
        }
        return same;
    }

    private final LocalQuickFix[] getFixes(HCLBlock block, List<? extends HCLBlock> duplicates) {
        PsiFile psiFile;
        PsiFile it;
        Object element$iv2;
        ArrayList<Object> fixes;
        block3: {
            fixes = new ArrayList<Object>();
            Iterable $this$first$iv = duplicates;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                HCLBlock it2 = (HCLBlock)element$iv2;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)block))) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        HCLBlock first = (HCLBlock)element$iv2;
        PsiFile psiFile2 = first.getContainingFile();
        if (psiFile2 != null && (psiFile2 = psiFile2.getVirtualFile()) != null) {
            it = psiFile2;
            boolean bl = false;
            LocalQuickFix it3 = this.createNavigateToDupeFix(first, duplicates.size() <= 2);
            boolean bl2 = false;
            fixes.add(it3);
        }
        if ((psiFile = block.getContainingFile()) != null && (psiFile = psiFile.getVirtualFile()) != null) {
            it = psiFile;
            boolean bl = false;
            LocalQuickFix it4 = this.createShowOtherDupesFix((PsiNamedElement)block, (NullableFunction<PsiElement, List<PsiElement>>)((NullableFunction)arg_0 -> TfDuplicatedOutputInspection.getFixes$lambda$6$lambda$4(this, arg_0)));
            boolean bl3 = false;
            fixes.add(it4);
        }
        fixes.add((Object)new DeleteOutputFix());
        fixes.add((Object)new RenameOutputFix());
        Collection $this$toTypedArray$iv = fixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    private static final List getFixes$lambda$6$lambda$4(TfDuplicatedOutputInspection this$0, PsiElement param) {
        Intrinsics.checkNotNull((Object)param, (String)"null cannot be cast to non-null type org.intellij.terraform.hcl.psi.HCLBlock");
        return this$0.getDuplicates((HCLBlock)param);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection$DeleteOutputFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    private static final class DeleteOutputFix
    extends PsiUpdateModCommandQuickFix
    implements LowPriorityAction {
        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("duplicated.output.inspection.delete.output.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                HCLBlock hCLBlock = element instanceof HCLBlock ? (HCLBlock)element : null;
                if (hCLBlock == null) break block0;
                hCLBlock.delete();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            List list = TfDuplicatedOutputInspection.this.getDuplicates(block);
            if (list == null) {
                return;
            }
            List duplicates = list;
            String string = UtilKt.getNameElementUnquoted(block, 1);
            if (string == null) {
                return;
            }
            String name = string;
            Object[] objectArray = new Object[]{name};
            String string2 = HCLBundle.message("duplicated.output.inspection.output.declared.multiple.times.error.message", objectArray);
            objectArray = TfDuplicatedOutputInspection.this.getFixes(block, duplicates);
            this.holder.registerProblem((PsiElement)block, string2, ProblemHighlightType.GENERIC_ERROR, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedOutputInspection$RenameOutputFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    private static final class RenameOutputFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("duplicated.output.inspection.rename.output.quick.fix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            HCLBlock hCLBlock = element instanceof HCLBlock ? (HCLBlock)element : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock block = hCLBlock;
            String string = block.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String currentName = string;
            String string2 = UniqueNameGenerator.generateUniqueNameOneBased((String)currentName, arg_0 -> RenameOutputFix.applyFix$lambda$1(arg_0 -> RenameOutputFix.applyFix$lambda$0(currentName, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateUniqueNameOneBased(...)");
            String uniqueName = string2;
            Object[] objectArray = new String[]{currentName, uniqueName};
            updater.rename((PsiNameIdentifierOwner)block, CollectionsKt.listOf((Object[])objectArray));
        }

        private static final boolean applyFix$lambda$0(String $currentName, String it) {
            return !Intrinsics.areEqual((Object)it, (Object)$currentName);
        }

        private static final boolean applyFix$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

