/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.inspection.TfDuplicatedInspectionBase;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0004J,\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00180\u0017H\u0004\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/inspection/TfDuplicatedInspectionBase;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createVisitor", "createNavigateToDupeFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiElement", "Lcom/intellij/psi/PsiElement;", "single", "createShowOtherDupesFix", "element", "Lcom/intellij/psi/PsiNamedElement;", "duplicates", "Lcom/intellij/util/NullableFunction;", "", "intellij.terraform"})
public abstract class TfDuplicatedInspectionBase
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return this.createVisitor(holder);
    }

    @NotNull
    public abstract PsiElementVisitor createVisitor(@NotNull ProblemsHolder var1);

    @NotNull
    protected final LocalQuickFix createNavigateToDupeFix(@NotNull PsiElement psiElement, boolean single) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        SmartPsiElementPointer psiPointer = SmartPointersKt.createSmartPointer((PsiElement)psiElement);
        return new LocalQuickFix(single, (SmartPsiElementPointer<PsiElement>)psiPointer){
            final /* synthetic */ boolean $single;
            final /* synthetic */ SmartPsiElementPointer<PsiElement> $psiPointer;
            {
                this.$single = $single;
                this.$psiPointer = $psiPointer;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public String getFamilyName() {
                String string = !this.$single ? HCLBundle.message("duplicated.inspection.base.navigate.to.duplicate.quick.fix.name.first", new Object[0]) : "";
                Intrinsics.checkNotNull((Object)string);
                String first = string;
                Object[] objectArray = new Object[]{first};
                String string2 = HCLBundle.message("duplicated.inspection.base.navigate.to.duplicate.quick.fix.name", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return string2;
            }

            public void applyFix(Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement psiElement = this.$psiPointer.getElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement element = psiElement;
                if (element instanceof Navigatable && ((Navigatable)element).canNavigate()) {
                    ((Navigatable)element).navigate(true);
                } else {
                    new OpenFileDescriptor(project, element.getContainingFile().getOriginalFile().getVirtualFile(), element.getTextOffset()).navigate(true);
                }
            }
        };
    }

    @NotNull
    protected final LocalQuickFix createShowOtherDupesFix(@NotNull PsiNamedElement element, @NotNull NullableFunction<PsiElement, List<PsiElement>> duplicates) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(duplicates, (String)"duplicates");
        return new LocalQuickFix(element, duplicates){
            private String myTitle;
            final /* synthetic */ PsiNamedElement $element;
            final /* synthetic */ NullableFunction<PsiElement, List<PsiElement>> $duplicates;
            {
                this.$element = $element;
                this.$duplicates = $duplicates;
            }

            public final String getMyTitle() {
                return this.myTitle;
            }

            public final void setMyTitle(String string) {
                this.myTitle = string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public String getFamilyName() {
                String string = HCLBundle.message("duplicated.inspection.base.show.other.duplicates.quick.fix.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public void applyFix(Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                List list = (List)ApplicationManager.getApplication().runReadAction(() -> createShowOtherDupesFix.1.applyFix$lambda$0(this.$duplicates, descriptor));
                if (list == null) {
                    return;
                }
                List duplicates = list;
                UsageViewPresentation presentation = new UsageViewPresentation();
                PsiElement2UsageTargetAdapter target = new PsiElement2UsageTargetAdapter((PsiElement)this.$element, true);
                if (this.myTitle == null) {
                    this.myTitle = "Duplicate of " + target.getPresentableText();
                }
                String string = this.myTitle;
                Intrinsics.checkNotNull((Object)string);
                String title = string;
                presentation.setSearchString(title);
                presentation.setTabName(title);
                presentation.setTabText(title);
                PsiElement psiElement = descriptor.getPsiElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
                GlobalSearchScope scope = ExtensionsKt.getTerraformSearchScope(psiElement);
                presentation.setScopeText(scope.getDisplayName());
                UsageTarget[] usageTargetArray = new UsageTarget[]{target};
                UsageViewManager.getInstance((Project)project).searchAndShowUsages(usageTargetArray, () -> createShowOtherDupesFix.1.applyFix$lambda$4(duplicates), false, false, presentation, null);
            }

            private static final List applyFix$lambda$0(NullableFunction $duplicates, ProblemDescriptor $descriptor) {
                return (List)$duplicates.fun((Object)$descriptor.getPsiElement());
            }

            /*
             * WARNING - void declaration
             */
            private static final List applyFix$lambda$4$lambda$3$lambda$2(List $duplicates) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $duplicates;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void dup;
                    PsiElement psiElement = (PsiElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new UsageInfo((PsiElement)dup));
                }
                return (List)destination$iv$iv;
            }

            private static final void applyFix$lambda$4$lambda$3(List $duplicates, Processor processor) {
                Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
                List infos = (List)ApplicationManager.getApplication().runReadAction(() -> createShowOtherDupesFix.1.applyFix$lambda$4$lambda$3$lambda$2($duplicates));
                for (UsageInfo info : infos) {
                    processor.process((Object)new UsageInfo2UsageAdapter(info));
                }
            }

            private static final UsageSearcher applyFix$lambda$4(List $duplicates) {
                return arg_0 -> createShowOtherDupesFix.1.applyFix$lambda$4$lambda$3($duplicates, arg_0);
            }
        };
    }
}

