/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.TfInitAction;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.inspection.AddResourcePropertiesFix;
import org.intellij.terraform.config.inspection.MissingPropertyVisitor;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.ModuleKt;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J,\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/inspection/MissingPropertyVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "recursive", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "getRecursive", "()Z", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "visitElement", "element", "Lorg/intellij/terraform/hcl/psi/HCLElement;", "doCheck", "properties", "", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLBlockMissingPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLBlockMissingPropertyInspection.kt\norg/intellij/terraform/config/inspection/MissingPropertyVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n774#2:172\n865#2,2:173\n1563#2:175\n1634#2,3:176\n827#2:179\n855#2,2:180\n808#2,11:182\n808#2,11:193\n1056#2:204\n*S KotlinDebug\n*F\n+ 1 HCLBlockMissingPropertyInspection.kt\norg/intellij/terraform/config/inspection/MissingPropertyVisitor\n*L\n119#1:172\n119#1:173,2\n122#1:175\n122#1:176,3\n134#1:179\n134#1:180,2\n138#1:182,11\n139#1:193,11\n141#1:204\n*E\n"})
public final class MissingPropertyVisitor
extends HCLElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    private final boolean recursive;

    public MissingPropertyVisitor(@NotNull ProblemsHolder holder, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.recursive = recursive;
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public final boolean getRecursive() {
        return this.recursive;
    }

    @Override
    public void visitBlock(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ProgressIndicatorProvider.checkCanceled();
        if (org.intellij.terraform.hcl.psi.UtilKt.getNameElementUnquoted(block, 0) == null) {
            return;
        }
        HCLObject hCLObject = block.getObject();
        if (hCLObject == null) {
            return;
        }
        HCLObject obj = hCLObject;
        if (TfPsiPatterns.INSTANCE.getModuleWithEmptySource().accepts((Object)block)) {
            this.doCheck(block, this.holder, TypeModel.Companion.getModule().getProperties());
            return;
        }
        if (TfPsiPatterns.INSTANCE.getConfigOverrideFile().accepts((Object)block.getContainingFile())) {
            return;
        }
        Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties(block);
        this.doCheck(block, this.holder, properties);
        if (this.recursive) {
            this.visitElement(obj);
        }
    }

    @Override
    public void visitElement(@NotNull HCLElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.visitElement(element);
        if (this.recursive) {
            element.acceptChildren(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doCheck(HCLBlock block, ProblemsHolder holder, Map<String, ? extends PropertyOrBlockType> properties) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterator<HCLBlock> $this$map$iv;
        void $this$filterTo$iv$iv;
        if (properties.isEmpty()) {
            return;
        }
        HCLObject hCLObject = block.getObject();
        if (hCLObject == null) {
            return;
        }
        HCLObject obj = hCLObject;
        ProgressIndicatorProvider.checkCanceled();
        Iterable $this$filter$iv = properties.values();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PropertyOrBlockType it = (PropertyOrBlockType)element$iv$iv;
            boolean bl = false;
            if (!(it.getRequired() && (!(it instanceof PropertyType) || !((PropertyType)it).getHas_default()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ArrayList candidates = new ArrayList(collection);
        if (candidates.isEmpty()) {
            return;
        }
        ArrayList<String> all = new ArrayList<String>();
        List<HCLProperty> list = obj.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
        Iterable $i$f$filter22 = list;
        ArrayList<String> arrayList = all;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HCLProperty bl = (HCLProperty)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.getName());
        }
        arrayList.addAll((List)destination$iv$iv2);
        for (HCLBlock it : obj.getBlockList()) {
            boolean bl = TfPsiPatterns.INSTANCE.getDynamicBlock().accepts((Object)it) ? all.add(it.getName()) : all.add(it.getFullName());
        }
        ProgressIndicatorProvider.checkCanceled();
        Iterable $this$filterNot$iv = candidates;
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PropertyOrBlockType it = (PropertyOrBlockType)element$iv$iv;
            boolean bl = false;
            if (all.contains(it.getName())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List required = (List)destination$iv$iv3;
        if (required.isEmpty()) {
            return;
        }
        Iterable $this$filterIsInstance$iv = required;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv3 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof PropertyType)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List requiredProps = (List)destination$iv$iv4;
        Iterable $this$filterIsInstance$iv2 = required;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv4 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BlockType)) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List requiredBlocks = (List)destination$iv$iv5;
        Iterable $this$sortedBy$iv = requiredProps;
        boolean $i$f$sortedBy = false;
        Collection collection3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PropertyType it = (PropertyType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (PropertyType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        $this$sortedBy$iv = requiredBlocks;
        $i$f$sortedBy = false;
        required = CollectionsKt.plus((Collection)collection3, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BlockType it = (BlockType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (BlockType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
        ProgressIndicatorProvider.checkCanceled();
        PsiElement psiElement = HCLPsiUtil.INSTANCE.getIdentifierPsi(block);
        if (psiElement == null) {
            return;
        }
        PsiElement nameOfBlock = psiElement;
        int size = required.size();
        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)required, (CharSequence)", ", null, (CharSequence)((CharSequence)(size > 5 ? " [" + size + "]" : "")), (int)5, null, (Function1)doCheck.4.INSTANCE, (int)18, null)};
        String string = HCLBundle.message("missing.resource.property.inspection.required.properties.error.message", objectArray);
        Object[] objectArray2 = new LocalQuickFix[]{new AddResourcePropertiesFix(required), TfInitAction.Companion.createQuickFixNotInitialized(nameOfBlock), ModuleKt.createDisableDeepVariableSearchQuickFix()};
        Collection collection4 = CollectionsKt.listOfNotNull((Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)LocalQuickFix.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        objectArray = (LocalQuickFix[])com.intellij.util.containers.UtilKt.toArray((Collection)collection4, (Object[])LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(nameOfBlock, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/intellij/terraform/config/inspection/MissingPropertyVisitor$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "recursive", "", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PsiElementVisitor create(@NotNull ProblemsHolder holder, boolean recursive) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (!UtilKt.isTerraformCompatiblePsiFile(holder.getFile())) {
                PsiElementVisitor psiElementVisitor = HCLElementVisitor.EMPTY_VISITOR;
                Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
                return psiElementVisitor;
            }
            return new MissingPropertyVisitor(holder, recursive);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

