/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.codeinsight.AddClosingQuoteQuickFix;
import org.intellij.terraform.hcl.codeinsight.ReplaceToDoubleQuoteQuickFix;
import org.intellij.terraform.hcl.codeinsight.UnwrapHCLStringQuickFix;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLNumberLiteral;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/terraform/config/inspection/HCLLiteralValidnessInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "COMMON_REGEX", "", "DQS_VALID_ESCAPE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "SQS_VALID_ESCAPE", "VALID_NUMBER_LITERAL", "VALID_HEX_NUMBER_LITERAL", "getID", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "StringLiteralVisitor", "intellij.terraform"})
public final class HCLLiteralValidnessInspection
extends LocalInspectionTool {
    @Language(value="RegExp")
    @NotNull
    private final String COMMON_REGEX;
    private final Pattern DQS_VALID_ESCAPE;
    private final Pattern SQS_VALID_ESCAPE;
    private final Pattern VALID_NUMBER_LITERAL;
    private final Pattern VALID_HEX_NUMBER_LITERAL;

    public HCLLiteralValidnessInspection() {
        this.COMMON_REGEX = "[\\\\abfntrv]|([0-7]{3})|(X[0-9a-fA-F]{2})|(u[0-9a-fA-F]{4})|(U[0-9a-fA-F]{8})";
        this.DQS_VALID_ESCAPE = Pattern.compile("\\\\(\"|" + this.COMMON_REGEX + ")");
        this.SQS_VALID_ESCAPE = Pattern.compile("\\\\('|" + this.COMMON_REGEX + ")");
        this.VALID_NUMBER_LITERAL = Pattern.compile("-?(0x)?([0-9])\\d*(\\.\\d+)?([e][+-]?\\d+)?([kmgb][b]?)?", 2);
        this.VALID_HEX_NUMBER_LITERAL = Pattern.compile("-?(0x)?([0-9a-f])+", 2);
    }

    @NotNull
    public String getID() {
        return "LiteralValidness";
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new StringLiteralVisitor(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/inspection/HCLLiteralValidnessInspection$StringLiteralVisitor;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/HCLLiteralValidnessInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitStringLiteral", "", "element", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "visitNumberLiteral", "Lorg/intellij/terraform/hcl/psi/HCLNumberLiteral;", "intellij.terraform"})
    public final class StringLiteralVisitor
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public StringLiteralVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitStringLiteral(@NotNull HCLStringLiteral element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String text = HCLPsiUtil.INSTANCE.getElementTextWithoutHostEscaping(element);
            int length = text.length();
            if (length <= 1 || text.charAt(0) != text.charAt(length - 1) || HCLPsiUtil.INSTANCE.isEscapedChar(text, length - 1)) {
                this.holder.problem((PsiElement)element, HCLBundle.message("hcl.literal.inspection.missing.closing.quote", new Object[0])).highlight(ProblemHighlightType.ERROR).fix((ModCommandAction)new AddClosingQuoteQuickFix(element)).register();
            }
            Pattern pattern = switch (element.getQuoteSymbol()) {
                case '\'' -> HCLLiteralValidnessInspection.this.SQS_VALID_ESCAPE;
                case '\"' -> HCLLiteralValidnessInspection.this.DQS_VALID_ESCAPE;
                default -> HCLLiteralValidnessInspection.this.DQS_VALID_ESCAPE;
            };
            int elementOffset = element.getNode().getStartOffset();
            for (Pair<TextRange, String> fragment : element.getTextFragments()) {
                TextRange shifted;
                String fragmentText = (String)fragment.getSecond();
                if (fragmentText.length() <= 1 || fragmentText.charAt(0) != '\\' || pattern.matcher(fragmentText).matches()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)((TextRange)fragment.getFirst()).shiftRight(elementOffset), (String)"shiftRight(...)");
                char c = fragmentText.charAt(1);
                String string = ('0' <= c ? c < '8' : false) ? HCLBundle.message("hcl.literal.inspection.illegal.octal.escape.sequence", new Object[0]) : (c == 'X' ? HCLBundle.message("hcl.literal.inspection.illegal.hex.escape.sequence", new Object[0]) : (c == 'u' || c == 'U' ? HCLBundle.message("hcl.literal.inspection.illegal.unicode.escape.sequence", new Object[0]) : HCLBundle.message("hcl.literal.inspection.illegal.escape.sequence", new Object[0])));
                Intrinsics.checkNotNull((Object)string);
                String errText = string;
                this.holder.registerProblem((PsiElement)element, shifted, errText, new LocalQuickFix[0]);
            }
            if (!(!HCLPsiUtil.INSTANCE.isPartOfPropertyKey(element) && !HCLPsiUtil.INSTANCE.isBlockNameElement(element, 0) || !ExtensionsKt.getTerraformModule(element).isHCL2Supported() || HCLPsiUtil.INSTANCE.isUnderPropertyUnderPropertyWithObjectValue(element) || HCLPsiUtil.INSTANCE.isUnderPropertyUnderPropertyWithObjectValueAndArray(element) || HCLPsiUtil.INSTANCE.isUnderPropertyInsideObjectArgument(element) || HCLPsiUtil.INSTANCE.isUnderPropertyInsideObjectConditionalExpression(element))) {
                this.holder.problem((PsiElement)element, HCLBundle.message("hcl.literal.inspection.argument.names.must.not.be.quoted", new Object[0])).highlight(ProblemHighlightType.ERROR).fix((ModCommandAction)new UnwrapHCLStringQuickFix(element)).register();
            }
            if (element.getQuoteSymbol() == '\'') {
                this.holder.problem((PsiElement)element, HCLBundle.message("hcl.literal.inspection.invalid.quotes", new Object[0])).highlight(ProblemHighlightType.ERROR).fix((ModCommandAction)new ReplaceToDoubleQuoteQuickFix(element)).register();
            }
        }

        @Override
        public void visitNumberLiteral(@NotNull HCLNumberLiteral element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String text = HCLPsiUtil.INSTANCE.getElementTextWithoutHostEscaping(element);
            if (!HCLLiteralValidnessInspection.this.VALID_NUMBER_LITERAL.matcher(text).matches() && !HCLLiteralValidnessInspection.this.VALID_HEX_NUMBER_LITERAL.matcher(text).matches()) {
                this.holder.registerProblem((PsiElement)element, HCLBundle.message("hcl.literal.inspection.illegal.number.literal", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }
}

