/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.model.ModuleKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/config/hints/TfReferencesCodeVisionProvider;", "Lcom/intellij/codeInsight/hints/codeVision/ReferencesCodeVisionProvider;", "<init>", "()V", "acceptsFile", "", "file", "Lcom/intellij/psi/PsiFile;", "acceptsElement", "element", "Lcom/intellij/psi/PsiElement;", "getHint", "", "relativeOrderings", "", "Lcom/intellij/codeInsight/codeVision/CodeVisionRelativeOrdering;", "getRelativeOrderings", "()Ljava/util/List;", "id", "getId", "()Ljava/lang/String;", "Companion", "intellij.terraform"})
public final class TfReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "tf.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        return psiElement instanceof HCLBlock ? TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)element) || TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)element) || TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)element) : (psiElement instanceof HCLProperty ? TfPsiPatterns.INSTANCE.getLocalProperty().accepts((Object)element) : false);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(element instanceof HCLElement)) {
            return null;
        }
        String string = org.intellij.terraform.hcl.psi.UtilKt.getElementName((HCLElement)element);
        if (string == null) {
            return null;
        }
        String elementName = string;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)((HCLElement)element).getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        Project project = ((HCLElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope scope = ModuleKt.restrictToTerraformFiles(globalSearchScope, project);
        PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.getInstance((Project)((HCLElement)element).getProject()).isCheapEnoughToSearch(elementName, scope, file);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(...)");
        PsiSearchHelper.SearchCostResult costSearch = searchCostResult;
        if (costSearch == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return HCLBundle.message("terraform.inlay.hints.indefinite.usages.text", new Object[0]);
        }
        AtomicInteger usagesCount = new AtomicInteger();
        int limit = AdvancedSettings.Companion.getInt("org.intellij.terraform.code.vision.usages.limit");
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new ReferencesSearch.SearchParameters(element, (SearchScope)scope, false)).allowParallelProcessing().forEach(arg_0 -> TfReferencesCodeVisionProvider.getHint$lambda$0(usagesCount, limit, arg_0));
        int result = usagesCount.get();
        Object[] objectArray = new Object[]{RangesKt.coerceAtMost((int)result, (int)limit), result > limit ? 1 : 0};
        String string2 = HCLBundle.message("terraform.inlay.hints.usages.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new CodeVisionProviderBase.CodeVisionInfo(string2, Integer.valueOf(result), result <= limit).getText();
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static final boolean getHint$lambda$0(AtomicInteger $usagesCount, int $limit, PsiReference it) {
        return it == null || $usagesCount.incrementAndGet() <= $limit;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/terraform/config/hints/TfReferencesCodeVisionProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

