/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.formatter;

import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.formatter.HCLLanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/intellij/terraform/config/formatter/TfConfigCodeStyleSettingsProvider;", "Lorg/intellij/terraform/hcl/formatter/HCLLanguageCodeStyleSettingsProvider;", "<init>", "()V", "getCodeSample", "", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "Companion", "intellij.terraform"})
public final class TfConfigCodeStyleSettingsProvider
extends HCLLanguageCodeStyleSettingsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SAMPLE = "\n# Specify the provider and access details\nprovider \"aws\" {\n    region = \"${var.aws_region}\"\n}\n\nresource \"aws_elb\" \"web\" {\n  name = \"terraform-example-elb\"\n\n  # The same availability zone as our instances\n  availability_zones = [\"${aws_instance.web.*.availability_zone}\"]\n\n  listener {\n    instance_port = 80\n    instance_protocol = \"http\"\n    lb_port = 80\n    lb_protocol = \"http\"\n  }\n\n  # The instances are registered automatically\n  instances = [\"${aws_instance.web.*.id}\"]\n}\n\n\nresource \"aws_instance\" \"web\" {\n  instance_type = \"m1.small\"\n  ami = \"${lookup(var.aws_amis, var.aws_region)}\"\n\n  # This will create 4 instances\n  count = 4\n}\n  ";

    public TfConfigCodeStyleSettingsProvider() {
        super(TerraformLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return "\n# Specify the provider and access details\nprovider \"aws\" {\n    region = \"${var.aws_region}\"\n}\n\nresource \"aws_elb\" \"web\" {\n  name = \"terraform-example-elb\"\n\n  # The same availability zone as our instances\n  availability_zones = [\"${aws_instance.web.*.availability_zone}\"]\n\n  listener {\n    instance_port = 80\n    instance_protocol = \"http\"\n    lb_port = 80\n    lb_protocol = \"http\"\n  }\n\n  # The instances are registered automatically\n  instances = [\"${aws_instance.web.*.id}\"]\n}\n\n\nresource \"aws_instance\" \"web\" {\n  instance_type = \"m1.small\"\n  ami = \"${lookup(var.aws_amis, var.aws_region)}\"\n\n  # This will create 4 instances\n  count = 4\n}\n  \n" + super.getCodeSample(settingsType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/intellij/terraform/config/formatter/TfConfigCodeStyleSettingsProvider$Companion;", "", "<init>", "()V", "SAMPLE", "", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

