/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.documentation.psi;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.documentation.psi.HCLFakeElementPsiFactoryKt;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.NamedType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.Type_modelKt;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J$\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/intellij/terraform/config/documentation/psi/HCLFakeElementPsiFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "emptyHCLBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getEmptyHCLBlock", "()Lorg/intellij/terraform/hcl/psi/HCLBlock;", "emptyHCLBlock$delegate", "Lkotlin/Lazy;", "myTfElementGenerator", "Lorg/intellij/terraform/config/psi/TfElementGenerator;", "createFakeHCLBlock", "block", "Lorg/intellij/terraform/config/model/NamedType;", "original", "Lcom/intellij/psi/PsiFile;", "blockName", "", "blockType", "createFakeHCLProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "property", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHCLFakeElementPsiFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HCLFakeElementPsiFactory.kt\norg/intellij/terraform/config/documentation/psi/HCLFakeElementPsiFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,65:1\n58#2:66\n36#2,2:67\n58#2:69\n36#2,2:70\n*S KotlinDebug\n*F\n+ 1 HCLFakeElementPsiFactory.kt\norg/intellij/terraform/config/documentation/psi/HCLFakeElementPsiFactory\n*L\n42#1:66\n42#1:67,2\n57#1:69\n57#1:70,2\n*E\n"})
public final class HCLFakeElementPsiFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy emptyHCLBlock$delegate;
    @NotNull
    private final TfElementGenerator myTfElementGenerator;

    public HCLFakeElementPsiFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.emptyHCLBlock$delegate = LazyKt.lazy(() -> HCLFakeElementPsiFactory.emptyHCLBlock_delegate$lambda$0(this));
        this.myTfElementGenerator = new TfElementGenerator(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final HCLBlock getEmptyHCLBlock() {
        Lazy lazy = this.emptyHCLBlock$delegate;
        return (HCLBlock)lazy.getValue();
    }

    @Nullable
    public final HCLBlock createFakeHCLBlock(@NotNull NamedType block, @Nullable PsiFile original) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ProviderType providerType = Type_modelKt.getProviderForBlockType((BlockType)((Object)block));
        if (providerType == null) {
            return null;
        }
        ProviderType provider = providerType;
        HCLBlock hCLBlock = this.createFakeHCLBlock(((BlockType)((Object)block)).getLiteral(), block.getType(), original);
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock fakeBlock = hCLBlock;
        fakeBlock.putUserData(HCLFakeElementPsiFactoryKt.getFAKE_PROVIDER_KEY(), provider);
        return fakeBlock;
    }

    public static /* synthetic */ HCLBlock createFakeHCLBlock$default(HCLFakeElementPsiFactory hCLFakeElementPsiFactory, NamedType namedType, PsiFile psiFile, int n, Object object) {
        if ((n & 2) != 0) {
            psiFile = null;
        }
        return hCLFakeElementPsiFactory.createFakeHCLBlock(namedType, psiFile);
    }

    @Nullable
    public final HCLBlock createFakeHCLBlock(@NotNull String blockName, @NotNull String blockType, @Nullable PsiFile original) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)blockName, (String)"blockName");
        Intrinsics.checkNotNullParameter((Object)blockType, (String)"blockType");
        try {
            object = new String[]{blockType};
            object = this.myTfElementGenerator.createBlock(blockName, MapsKt.emptyMap(), (String[])object, original);
        }
        catch (IllegalStateException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warnWithDebug("Failed to create HCLBlock for content: " + blockName + " " + blockType + ". " + e.getMessage(), (Throwable)e);
            object = null;
        }
        Object hclBlock = object;
        return hclBlock;
    }

    public static /* synthetic */ HCLBlock createFakeHCLBlock$default(HCLFakeElementPsiFactory hCLFakeElementPsiFactory, String string, String string2, PsiFile psiFile, int n, Object object) {
        if ((n & 4) != 0) {
            psiFile = null;
        }
        return hCLFakeElementPsiFactory.createFakeHCLBlock(string, string2, psiFile);
    }

    @Nullable
    public final HCLProperty createFakeHCLProperty(@NotNull HCLBlock block, @NotNull PropertyOrBlockType property) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        try {
            String string;
            String string2 = UtilKt.getNameElementUnquoted(block, 0);
            if (string2 == null) {
                string2 = "";
            }
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)property.getName(), (Object)"\"\""));
            object = new String[2];
            String string3 = UtilKt.getNameElementUnquoted(block, 1);
            if (string3 == null) {
                string3 = object[0] = "\"\"";
            }
            if ((string = UtilKt.getNameElementUnquoted(block, 2)) == null) {
                string = "\"\"";
            }
            object[1] = string;
            object = this.myTfElementGenerator.createBlock(string2, map, (String[])object, block.getContainingFile().getOriginalFile());
        }
        catch (IllegalStateException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warnWithDebug("Failed to create HCLProperty: " + property + " for block " + block + ". " + e.getMessage(), (Throwable)e);
            object = null;
        }
        String[] dummyBlock = object;
        Object object2 = dummyBlock;
        HCLProperty hclProperty = dummyBlock != null && (object2 = object2.getObject()) != null ? object2.findProperty(property.getName()) : null;
        return hclProperty;
    }

    private static final HCLBlock emptyHCLBlock_delegate$lambda$0(HCLFakeElementPsiFactory this$0) {
        return HCLFakeElementPsiFactory.createFakeHCLBlock$default(this$0, "", "", null, 4, null);
    }
}

