/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.documentation.html;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.containers.UtilKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.OpenCloseGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/config/documentation/html/TfFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "root", "Lorg/intellij/markdown/IElementType;", "<init>", "(Lorg/intellij/markdown/IElementType;)V", "getRoot", "()Lorg/intellij/markdown/IElementType;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "TfDocTagProvider", "ListItemGeneratingProvider", "intellij.terraform"})
public final class TfFlavourDescriptor
extends GFMFlavourDescriptor {
    @NotNull
    private final IElementType root;

    public TfFlavourDescriptor(@NotNull IElementType root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(true, false, false, 4, null);
        this.root = root;
    }

    @NotNull
    public final IElementType getRoot() {
        return this.root;
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Map parentProviders = MapsKt.toMutableMap((Map)super.createHtmlGeneratingProviders(linkMap, baseURI));
        parentProviders.put(this.root, new TfDocTagProvider());
        parentProviders.put(MarkdownElementTypes.LIST_ITEM, new ListItemGeneratingProvider());
        return parentProviders;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "<init>", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "ListElementAnchorProvider", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfFlavourDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfFlavourDescriptor.kt\norg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,96:1\n106#2,3:97\n110#2:101\n106#2,3:102\n110#2:106\n106#3:100\n106#3:105\n*S KotlinDebug\n*F\n+ 1 TfFlavourDescriptor.kt\norg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider\n*L\n50#1:97,3\n50#1:101\n53#1:102,3\n53#1:106\n50#1:100\n53#1:105\n*E\n"})
    public static final class ListItemGeneratingProvider
    extends SimpleTagProvider {
        public ListItemGeneratingProvider() {
            super("li");
        }

        public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Compat compat = Compat.INSTANCE;
            boolean condition$iv22 = node instanceof ListItemCompositeNode;
            boolean $i$f$assert = false;
            if (!condition$iv22) {
                boolean bl = false;
                String string = "";
                throw new MarkdownParsingException(string);
            }
            this.openTag(visitor, text, node);
            ASTNode listNode = node.getParent();
            Compat condition$iv22 = Compat.INSTANCE;
            boolean condition$iv = listNode instanceof ListCompositeNode;
            boolean $i$f$assert2 = false;
            if (!condition$iv) {
                boolean bl = false;
                String string = "";
                throw new MarkdownParsingException(string);
            }
            for (ASTNode child : node.getChildren()) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.PARAGRAPH)) {
                    ListElementAnchorProvider.INSTANCE.processNode(visitor, text, child);
                    continue;
                }
                ASTNodeKt.accept((ASTNode)child, (Visitor)((Visitor)visitor));
            }
            this.closeTag(visitor, text, node);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider$ListElementAnchorProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "<init>", "()V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "intellij.terraform"})
        @SourceDebugExtension(value={"SMAP\nTfFlavourDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfFlavourDescriptor.kt\norg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider$ListElementAnchorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n1869#3,2:98\n*S KotlinDebug\n*F\n+ 1 TfFlavourDescriptor.kt\norg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$ListItemGeneratingProvider$ListElementAnchorProvider\n*L\n79#1:98,2\n*E\n"})
        public static final class ListElementAnchorProvider
        extends SimpleTagProvider {
            @NotNull
            public static final ListElementAnchorProvider INSTANCE = new ListElementAnchorProvider();

            private ListElementAnchorProvider() {
                super("p");
            }

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                List nodes = node.getChildren();
                if (nodes.isEmpty()) {
                    return;
                }
                Object e = nodes.get(0);
                CharSequence[] it = (CharSequence[])e;
                boolean bl = false;
                ASTNode codeSpan = (ASTNode)(Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.CODE_SPAN) ? e : null);
                if (codeSpan != null) {
                    String string = StringUtilRt.unquoteString((String)((Object)ASTUtilKt.getTextInNode((ASTNode)codeSpan, (CharSequence)text)).toString(), (char)'`');
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
                    String textInNode = EntityConverter.INSTANCE.replaceEntities((CharSequence)string, true, true);
                    it = new CharSequence[]{"id=\"" + textInNode + "\"", "name=\"" + textInNode + "\""};
                    HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)codeSpan, (CharSequence)"span", (CharSequence[])it, (boolean)false, (int)8, null);
                    HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)codeSpan, (CharSequence)"code", (CharSequence[])new CharSequence[0], (boolean)false, (int)8, null);
                    visitor.consumeHtml((CharSequence)textInNode);
                    visitor.consumeTagClose((CharSequence)"code");
                    visitor.consumeTagClose((CharSequence)"span");
                    Iterable $this$forEach$iv = UtilKt.tail((List)nodes);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ASTNode child = (ASTNode)element$iv;
                        boolean bl2 = false;
                        if (child instanceof LeafASTNode) {
                            visitor.visitLeaf(child);
                            continue;
                        }
                        ASTNodeKt.accept((ASTNode)child, (Visitor)((Visitor)visitor));
                    }
                } else {
                    ASTNodeKt.accept((ASTNode)node, (Visitor)((Visitor)visitor));
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007R\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/documentation/html/TfFlavourDescriptor$TfDocTagProvider;", "Lorg/intellij/markdown/html/OpenCloseGeneratingProvider;", "<init>", "()V", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "closeTag", "intellij.terraform"})
    public static class TfDocTagProvider
    extends OpenCloseGeneratingProvider {
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"body", (CharSequence[])new CharSequence[0], (boolean)false, (int)8, null);
            CharSequence[] charSequenceArray = new CharSequence[]{"id = \"provider-docs-content\""};
            HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"article", (CharSequence[])charSequenceArray, (boolean)false, (int)8, null);
        }

        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            visitor.consumeTagClose((CharSequence)"article");
            visitor.consumeTagClose((CharSequence)"body");
        }
    }
}

