/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.documentation.HCLDocumentationUtilsKt;
import org.intellij.terraform.config.model.BaseModelType;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.config.psi.TfDocumentPsi;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLValue;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.LiteralExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0001\u00a2\u0006\u0002\b\bJ\u0017\u0010\t\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0003J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H\u0003J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0003\u00a8\u0006\u0014"}, d2={"Lorg/intellij/terraform/config/documentation/LocalTfDocumentationProvider;", "", "<init>", "()V", "fetchLocalDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "fetchLocalDescription$intellij_terraform", "provideDocForProperty", "Lorg/jetbrains/annotations/Nls;", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "provideDocForHclBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getVariableDocumentation", "getOutputBlockDocumentation", "bundleKey", "getTypedBlockDocumentation", "provideDocForIdentifier", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nLocalTfDocumentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTfDocumentationProvider.kt\norg/intellij/terraform/config/documentation/LocalTfDocumentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1#2:117\n80#3:118\n1310#4,2:119\n295#5,2:121\n*S KotlinDebug\n*F\n+ 1 LocalTfDocumentationProvider.kt\norg/intellij/terraform/config/documentation/LocalTfDocumentationProvider\n*L\n45#1:118\n81#1:119,2\n89#1:121,2\n*E\n"})
public final class LocalTfDocumentationProvider {
    @NotNull
    public static final LocalTfDocumentationProvider INSTANCE = new LocalTfDocumentationProvider();

    private LocalTfDocumentationProvider() {
    }

    @Nls
    @Nullable
    public final String fetchLocalDescription$intellij_terraform(@Nullable PsiElement element) {
        String string;
        PsiElement psiElement = element;
        if (psiElement instanceof HCLProperty) {
            string = this.provideDocForProperty((HCLProperty)element);
        } else if (psiElement instanceof HCLBlock) {
            string = this.provideDocForHclBlock((HCLBlock)element);
        } else if (psiElement instanceof HCLIdentifier) {
            string = this.provideDocForIdentifier((HCLIdentifier)element);
        } else if (psiElement instanceof TfDocumentPsi) {
            HCLBlock hCLBlock = HCLDocumentationUtilsKt.getBlockForDocumentationLink((TfDocumentPsi)element, ((TfDocumentPsi)element).getName());
            if (hCLBlock != null) {
                HCLBlock it = hCLBlock;
                boolean bl = false;
                string = INSTANCE.provideDocForHclBlock(it);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String provideDocForProperty(HCLProperty element) {
        PropertyType property;
        void $this$parentsOfType$iv;
        PsiElement psiElement = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentsOfType = false;
        HCLBlock hCLBlock = (HCLBlock)SequencesKt.firstOrNull((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, HCLBlock.class, (boolean)withSelf$iv));
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock block = hCLBlock;
        Map<String, PropertyOrBlockType> properties = TfModelHelper.INSTANCE.getBlockProperties(block);
        Object[] objectArray = properties.get(element.getName());
        PropertyType propertyType = property = objectArray instanceof PropertyType ? (PropertyType)objectArray : null;
        if (property != null) {
            objectArray = new Object[3];
            objectArray[0] = element.getName();
            objectArray[1] = property.getType().getPresentableText();
            String string = property.getDescription();
            if (string == null) {
                string = "";
            }
            objectArray[2] = string;
            return HCLBundle.message("terraform.doc.property.0.1.br.2", objectArray);
        }
        if (TfPsiPatterns.INSTANCE.getLocalsRootBlock().accepts((Object)block)) {
            objectArray = new Object[]{element.getName()};
            return HCLBundle.message("terraform.doc.local.value.0", objectArray);
        }
        return null;
    }

    @Nls
    private final String provideDocForHclBlock(HCLBlock element) {
        return TfPsiPatterns.INSTANCE.getVariableRootBlock().accepts((Object)element) ? this.getVariableDocumentation(element) : (TfPsiPatterns.INSTANCE.getOutputRootBlock().accepts((Object)element) ? this.getOutputBlockDocumentation(element, "terraform.doc.hcl.output.0.of.type.1") : (TfPsiPatterns.INSTANCE.getResourceRootBlock().accepts((Object)element) ? this.getTypedBlockDocumentation(element, "terraform.doc.hcl.resource.0.of.type.1") : (TfPsiPatterns.INSTANCE.getDataSourceRootBlock().accepts((Object)element) ? this.getTypedBlockDocumentation(element, "terraform.doc.hcl.datasource.0.of.type.1") : (TfPsiPatterns.INSTANCE.getProviderRootBlock().accepts((Object)element) ? this.getTypedBlockDocumentation(element, "terraform.doc.hcl.provider.0.of.type.1") : HCLDocumentationUtilsKt.calculateBlockDescription(element)))));
    }

    @Nls
    private final String getVariableDocumentation(HCLBlock element) {
        Object[] objectArray;
        Object object;
        Object description;
        Object typeExpression;
        Variable variable;
        block11: {
            block10: {
                block9: {
                    Object object2;
                    block8: {
                        HCLExpression hCLExpression;
                        block7: {
                            Object object3;
                            block6: {
                                variable = new Variable(element);
                                HCLExpression hCLExpression2 = variable.getTypeExpression();
                                object3 = hCLExpression2 instanceof LiteralExpression ? (LiteralExpression)((Object)hCLExpression2) : null;
                                if (object3 == null || (object3 = object3.getUnquotedText()) == null) break block6;
                                Object it = object3;
                                boolean bl = false;
                                String string = " of type " + (String)it;
                                object3 = string;
                                if (string != null) break block7;
                            }
                            object3 = typeExpression = "";
                        }
                        if ((object2 = (hCLExpression = variable.getDescription()) instanceof LiteralExpression ? (LiteralExpression)((Object)hCLExpression) : null) == null || (object2 = object2.getUnquotedText()) == null) break block8;
                        Object it = object2;
                        boolean bl = false;
                        String string = "<br/> " + (String)it;
                        object2 = string;
                        if (string != null) break block9;
                    }
                    object2 = description = "";
                }
                if ((object = (objectArray = variable.getDefault()) instanceof HCLValue ? (HCLValue)objectArray : null) == null || (object = object.getText()) == null) break block10;
                Object it = object;
                boolean bl = false;
                String string = "<br/>Default value: " + (String)it;
                object = string;
                if (string != null) break block11;
            }
            object = "";
        }
        Object defaultValue = object;
        objectArray = new Object[]{variable.getName(), typeExpression, description, defaultValue};
        String string = HCLBundle.message("terraform.doc.variable.0.1.2.3", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nls
    private final String getOutputBlockDocumentation(HCLBlock element, String bundleKey) {
        String string;
        HCLProperty descriptionProperty;
        Object object;
        Object var4_13;
        Object[] objectArray;
        block6: {
            PsiElement[] psiElementArray;
            objectArray = element.getObject();
            if (objectArray != null && (psiElementArray = objectArray.getChildren()) != null) {
                void $this$firstOrNull$iv;
                PsiElement[] psiElementArray2 = psiElementArray;
                boolean $i$f$firstOrNull = false;
                int n = ((void)$this$firstOrNull$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!TfPsiPatterns.INSTANCE.getDescriptionProperty().accepts((Object)it)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            } else {
                v0 = var4_13 = null;
            }
        }
        if ((object = (descriptionProperty = var4_13 instanceof HCLProperty ? (HCLProperty)var4_13 : null)) != null && (object = object.getValue()) != null && (object = object.getText()) != null) {
            Object it = object;
            boolean bl = false;
            string = StringUtil.unquoteString((String)it);
        } else {
            string = null;
        }
        String description = string;
        objectArray = new Object[2];
        objectArray[0] = UtilKt.getNameElementUnquoted(element, 1);
        String string2 = description;
        if (string2 == null) {
            string2 = "";
        }
        objectArray[1] = string2;
        return HCLBundle.message(bundleKey, objectArray);
    }

    @Nls
    private final String getTypedBlockDocumentation(HCLBlock element, String bundleKey) {
        String string;
        DataSourceType type;
        String string2;
        BlockType block;
        block24: {
            block23: {
                Object v0;
                block22: {
                    Iterable $this$firstOrNull$iv = TypeModel.Companion.getRootBlocks();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Object it = (BlockType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((BlockType)it).getLiteral(), (Object)UtilKt.getNameElementUnquoted(element, 0))) continue;
                        v0 = element$iv;
                        break block22;
                    }
                    v0 = null;
                }
                block = v0;
                string2 = UtilKt.getNameElementUnquoted(element, 0);
                if (string2 == null) break block23;
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string2 = string3;
                if (string3 != null) break block24;
            }
            return null;
        }
        String resourceType = string2;
        String string4 = UtilKt.getNameElementUnquoted(element, 1);
        if (string4 == null) {
            return null;
        }
        String identifier = string4;
        TypeModel model = TypeModelProvider.Companion.getModel(element);
        DataSourceType dataSourceType = type = (switch (resourceType) {
            case "resource" -> model.getResourceType(identifier, element);
            case "data" -> model.getDataSourceType(identifier, element);
            case "provider" -> model.getProviderType(identifier, element);
            default -> null;
        });
        String description = dataSourceType != null ? ((BaseModelType)dataSourceType).getDescription() : null;
        BlockType blockType = block;
        if (blockType != null) {
            BlockType it = blockType;
            boolean bl = false;
            Object[] objectArray = new Object[3];
            objectArray[0] = element.getName();
            objectArray[1] = identifier;
            String string5 = description;
            if (string5 == null) {
                string5 = "";
            }
            objectArray[2] = string5;
            string = HCLBundle.message(bundleKey, objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @Nls
    private final String provideDocForIdentifier(HCLIdentifier element) {
        HCLBlock hCLBlock = HCLDocumentationUtilsKt.getBlockForHclIdentifier(element);
        if (hCLBlock == null) {
            return null;
        }
        HCLBlock parentBlock = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(parentBlock, 1);
        if (string == null) {
            string = UtilKt.getNameElementUnquoted(parentBlock, 0);
        }
        String parentBlockType = string;
        Object[] objectArray = TfModelHelper.INSTANCE.getBlockProperties(parentBlock).get(element.getId());
        BaseModelType baseModelType = objectArray instanceof BaseModelType ? (BaseModelType)objectArray : null;
        if (baseModelType == null) {
            return null;
        }
        BaseModelType property = baseModelType;
        String string2 = property.getDescription();
        if (string2 == null) {
            string2 = "";
        }
        String description = string2;
        objectArray = new Object[]{parentBlockType, element.getId(), description};
        return HCLBundle.message("terraform.doc.argument.0.1.br.2", objectArray);
    }
}

