/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.BackendType;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.DataSourceType;
import org.intellij.terraform.config.model.EphemeralType;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ModuleType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ProvisionerType;
import org.intellij.terraform.config.model.ResourceType;
import org.intellij.terraform.config.model.Type;
import org.intellij.terraform.config.model.TypeModel;
import org.intellij.terraform.config.model.TypeModelProvider;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.intellij.terraform.hcl.psi.common.BaseExpression;
import org.intellij.terraform.opentofu.model.OpenTofuTypeModelKt;
import org.intellij.terraform.opentofu.patterns.OpenTofuPatterns;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0007J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010#\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfModelHelper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getBlockProperties", "", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "getBlockPropertiesInternal", "getAbstractBlockType", "Lorg/intellij/terraform/config/model/BlockType;", "getBlockType", "Lorg/intellij/terraform/config/model/Type;", "wrapIfCountForEach", "type", "getModelBlockProperties", "getProviderProperties", "getProvisionerProperties", "getBackendProperties", "getTerraformProperties", "getConnectionProperties", "getResourceProperties", "getDataSourceProperties", "getEphemeralProperties", "getAllTypesForBlockByIdentifier", "", "blockPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getModuleProperties", "getPropertiesWithDefaults", "defaults", "origin", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfModelHelper.kt\norg/intellij/terraform/config/codeinsight/TfModelHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,297:1\n536#2:298\n521#2,6:299\n67#3:305\n67#3:306\n67#3:307\n67#3:308\n126#4:309\n153#4,3:310\n*S KotlinDebug\n*F\n+ 1 TfModelHelper.kt\norg/intellij/terraform/config/codeinsight/TfModelHelper\n*L\n33#1:298\n33#1:299,6\n43#1:305\n45#1:306\n100#1:307\n102#1:308\n159#1:309\n159#1:310,3\n*E\n"})
public final class TfModelHelper {
    @NotNull
    public static final TfModelHelper INSTANCE = new TfModelHelper();
    @NotNull
    private static final Logger LOG;

    private TfModelHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, PropertyOrBlockType> getBlockProperties(@NotNull HCLBlock block) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        FileType fileType = block.getContainingFile().getOriginalFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        Map<String, PropertyOrBlockType> $this$filter$iv = this.getBlockPropertiesInternal(block);
        boolean $i$f$filter = false;
        Map<String, PropertyOrBlockType> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((PropertyOrBlockType)it.getValue()).canBeUsedIn(fileType2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PropertyOrBlockType> getBlockPropertiesInternal(HCLBlock block) {
        Object object;
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return MapsKt.emptyMap();
        }
        String type = string;
        if (TfPsiPatterns.INSTANCE.getBackend().accepts((Object)block)) {
            return this.getBackendProperties(block);
        }
        if (TfPsiPatterns.INSTANCE.getDynamicBlockContent().accepts((Object)block)) {
            void $this$parentOfType$iv;
            void $this$parentOfType$iv2;
            PsiElement psiElement = block;
            boolean withSelf$iv22 = false;
            boolean $i$f$parentOfType = false;
            HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, HCLBlock.class, (boolean)true);
            if (hCLBlock == null) {
                return MapsKt.emptyMap();
            }
            HCLBlock dynamic = hCLBlock;
            PsiElement withSelf$iv22 = dynamic;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType2 = false;
            HCLBlock hCLBlock2 = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HCLBlock.class, (boolean)true);
            if (hCLBlock2 == null) {
                return MapsKt.emptyMap();
            }
            HCLBlock origin = hCLBlock2;
            PropertyOrBlockType propertyOrBlockType = this.getBlockProperties(origin).get(dynamic.getName());
            BlockType blockType = propertyOrBlockType instanceof BlockType ? (BlockType)propertyOrBlockType : null;
            if (blockType == null) {
                return MapsKt.emptyMap();
            }
            BlockType blockType2 = blockType;
            return blockType2.getProperties();
        }
        if (TfPsiPatterns.INSTANCE.getDynamicBlock().accepts((Object)block)) {
            return TypeModel.Companion.getResourceDynamic().getProperties();
        }
        if (TfPsiPatterns.INSTANCE.getProvisionerBlock().accepts((Object)block)) {
            return this.getProvisionerProperties(block);
        }
        if (TfPsiPatterns.INSTANCE.getResourceLifecycleBlock().accepts((Object)block)) {
            return TypeModel.Companion.getResourceLifecycle().getProperties();
        }
        if (TfPsiPatterns.INSTANCE.getResourceConnectionBlock().accepts((Object)block)) {
            return this.getConnectionProperties(block);
        }
        if (OpenTofuPatterns.INSTANCE.getKeyProviderBlock().accepts((Object)block)) {
            return OpenTofuTypeModelKt.getEncryptionKeyProviderProperties(block);
        }
        if (OpenTofuPatterns.INSTANCE.getEncryptionMethodBlock().accepts((Object)block)) {
            return OpenTofuTypeModelKt.getEncryptionMethodProperties(block);
        }
        if (!(block.getParent() instanceof PsiFile)) {
            return this.getModelBlockProperties(block, type);
        }
        switch (type) {
            case "provider": {
                object = this.getProviderProperties(block);
                break;
            }
            case "resource": {
                object = this.getResourceProperties(block);
                break;
            }
            case "data": {
                object = this.getDataSourceProperties(block);
                break;
            }
            case "ephemeral": {
                object = this.getEphemeralProperties(block);
                break;
            }
            case "module": {
                object = this.getModuleProperties(block);
                break;
            }
            case "terraform": {
                object = this.getTerraformProperties(block);
                break;
            }
            default: {
                object = TypeModel.Companion.getRootBlocksMap().get(type);
                if (object != null && (object = ((BlockType)object).getProperties()) != null) break;
                object = MapsKt.emptyMap();
            }
        }
        Map props = object;
        return props;
    }

    @Nullable
    public final BlockType getAbstractBlockType(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return null;
        }
        String type = string;
        if (block.getParent() instanceof PsiFile) {
            return TypeModel.Companion.getRootBlocksMap().get(type);
        }
        return TfPsiPatterns.INSTANCE.getBackend().accepts((Object)block) ? TypeModel.Companion.getAbstractBackend() : (TfPsiPatterns.INSTANCE.getDynamicBlock().accepts((Object)block) ? TypeModel.Companion.getResourceDynamic() : (TfPsiPatterns.INSTANCE.getDynamicBlockContent().accepts((Object)block) ? TypeModel.Companion.getAbstractResourceDynamicContent() : (TfPsiPatterns.INSTANCE.getProvisionerBlock().accepts((Object)block) ? TypeModel.Companion.getAbstractResourceProvisioner() : (TfPsiPatterns.INSTANCE.getResourceLifecycleBlock().accepts((Object)block) ? TypeModel.Companion.getResourceLifecycle() : (TfPsiPatterns.INSTANCE.getResourceConnectionBlock().accepts((Object)block) ? TypeModel.Companion.getConnection() : null)))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Type getBlockType(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return null;
        }
        String type = string;
        if (TfPsiPatterns.INSTANCE.getBackend().accepts((Object)block)) {
            BlockType fallback = TypeModel.Companion.getAbstractBackend();
            String string2 = UtilKt.getNameElementUnquoted(block, 1);
            if (string2 == null) {
                return fallback;
            }
            String name = string2;
            BackendType backendType = TypeModelProvider.Companion.getModel(block).getBackendType(name);
            if (backendType == null) {
                return fallback;
            }
            return backendType;
        }
        if (TfPsiPatterns.INSTANCE.getDynamicBlockContent().accepts((Object)block)) {
            PropertyOrBlockType $this$parentOfType$iv;
            void $this$parentOfType$iv2;
            BlockType fallback = TypeModel.Companion.getAbstractResourceDynamicContent();
            PsiElement psiElement = block;
            boolean withSelf$iv232 = false;
            boolean $i$f$parentOfType = false;
            HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv2, HCLBlock.class, (boolean)true);
            if (hCLBlock == null) {
                return fallback;
            }
            HCLBlock dynamic = hCLBlock;
            PsiElement withSelf$iv232 = dynamic;
            boolean withSelf$iv = false;
            boolean bl = false;
            HCLBlock hCLBlock2 = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, HCLBlock.class, (boolean)true);
            if (hCLBlock2 == null) {
                return fallback;
            }
            HCLBlock origin = hCLBlock2;
            $this$parentOfType$iv = this.getBlockProperties(origin).get(dynamic.getName());
            BlockType blockType = $this$parentOfType$iv instanceof BlockType ? (BlockType)$this$parentOfType$iv : null;
            if (blockType == null) {
                return fallback;
            }
            return blockType;
        }
        if (TfPsiPatterns.INSTANCE.getDynamicBlock().accepts((Object)block)) {
            return TypeModel.Companion.getResourceDynamic();
        }
        if (TfPsiPatterns.INSTANCE.getProvisionerBlock().accepts((Object)block)) {
            BlockType fallback = TypeModel.Companion.getAbstractResourceProvisioner();
            String string3 = UtilKt.getNameElementUnquoted(block, 1);
            if (string3 == null) {
                return fallback;
            }
            String name = string3;
            return TypeModelProvider.Companion.getModel(block).getProvisionerType(name);
        }
        if (TfPsiPatterns.INSTANCE.getResourceLifecycleBlock().accepts((Object)block)) {
            return TypeModel.Companion.getResourceLifecycle();
        }
        if (TfPsiPatterns.INSTANCE.getResourceConnectionBlock().accepts((Object)block)) {
            return TypeModel.Companion.getConnection();
        }
        if (!TypeModel.Companion.getRootBlocksMap().keySet().contains(type) || !(block.getParent() instanceof PsiFile)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"provider")) {
            BlockType fallback = TypeModel.AbstractProvider;
            String string4 = UtilKt.getNameElementUnquoted(block, 1);
            if (string4 == null) {
                return fallback;
            }
            String name = string4;
            ProviderType providerType = TypeModelProvider.Companion.getModel(block).getProviderType(name, block);
            return providerType != null ? (Type)providerType : (Type)fallback;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"resource")) {
            BlockType fallback = TypeModel.AbstractResource;
            String string5 = UtilKt.getNameElementUnquoted(block, 1);
            if (string5 == null) {
                return this.wrapIfCountForEach(fallback, block);
            }
            String name = string5;
            ResourceType resourceType = TypeModelProvider.Companion.getModel(block).getResourceType(name, block);
            return this.wrapIfCountForEach(resourceType != null ? (BlockType)resourceType : fallback, block);
        }
        if (Intrinsics.areEqual((Object)type, (Object)"data")) {
            BlockType fallback = TypeModel.AbstractDataSource;
            String string6 = UtilKt.getNameElementUnquoted(block, 1);
            if (string6 == null) {
                return this.wrapIfCountForEach(fallback, block);
            }
            String name = string6;
            DataSourceType dataSourceType = TypeModelProvider.Companion.getModel(block).getDataSourceType(name, block);
            return this.wrapIfCountForEach(dataSourceType != null ? (BlockType)dataSourceType : fallback, block);
        }
        if (Intrinsics.areEqual((Object)type, (Object)"module")) {
            void $this$mapTo$iv$iv;
            Map map;
            BlockType fallback = TypeModel.Companion.getModule();
            String string7 = UtilKt.getNameElementUnquoted(block, 1);
            if (string7 == null) {
                return fallback;
            }
            String name = string7;
            Module module = Module.Companion.getAsModuleBlock(block);
            if (module == null) {
                return fallback;
            }
            Module module2 = module;
            HashMap result = new HashMap();
            List<HCLBlock> outputs = module2.getDefinedOutputs();
            for (HCLBlock hCLBlock : outputs) {
                HCLElement hCLElement = hCLBlock.getObject();
                HCLExpression value = hCLElement != null && (hCLElement = hCLElement.findProperty("value")) != null ? hCLElement.getValue() : null;
                map = result;
                String string8 = hCLBlock.getName();
                Type type2 = ExtensionsKt.getType(value);
                if (type2 == null) {
                    type2 = Types.INSTANCE.getAny();
                }
                Type type3 = type2;
                map.put(string8, type3);
            }
            List<Variable> variables = module2.getAllVariables();
            for (Variable variable : variables) {
                ((Map)result).put(variable.getName(), variable.getCombinedType());
            }
            Map map2 = result;
            String string9 = name;
            boolean $i$f$map = false;
            map = map2;
            Collection destination$iv$iv = new ArrayList(map2.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string10 = (String)it.getKey();
                Type type4 = (Type)it.getValue();
                if (type4 == null) {
                    type4 = Types.INSTANCE.getAny();
                }
                collection.add(new PropertyType(string10, type4, null, false, null, null, false, false, false, false, null, null, false, 8188, null));
            }
            List list = (List)destination$iv$iv;
            String string11 = string9;
            return new ModuleType(string11, list);
        }
        if (Intrinsics.areEqual((Object)type, (Object)"terraform")) {
            return TypeModel.Companion.getTerraform();
        }
        if (Intrinsics.areEqual((Object)type, (Object)"variable")) {
            Variable variable = new Variable(block);
            return variable.getCombinedType();
        }
        if (Intrinsics.areEqual((Object)type, (Object)"output")) {
            HCLElement hCLElement = block.getObject();
            if (hCLElement == null || (hCLElement = hCLElement.findProperty("value")) == null || (hCLElement = hCLElement.getValue()) == null) {
                return Types.INSTANCE.getAny();
            }
            HCLElement value = hCLElement;
            return ExtensionsKt.getType((BaseExpression)((Object)value));
        }
        return TypeModel.Companion.getRootBlocksMap().get(type);
    }

    private final Type wrapIfCountForEach(BlockType type, HCLBlock block) {
        HCLObject hCLObject = block.getObject();
        if (hCLObject == null) {
            return type;
        }
        HCLObject obj = hCLObject;
        if (obj.findProperty("count") != null) {
            return new ListType(type);
        }
        if (obj.findProperty("for_each") != null) {
            return new MapType(type);
        }
        return type;
    }

    private final Map<String, PropertyOrBlockType> getModelBlockProperties(HCLBlock block, String type) {
        PsiElement psiElement = block.getParent();
        HCLObject hCLObject = psiElement instanceof HCLObject ? (HCLObject)psiElement : null;
        if (hCLObject == null) {
            return MapsKt.emptyMap();
        }
        HCLObject bp = hCLObject;
        PsiElement psiElement2 = bp.getParent();
        HCLBlock hCLBlock = psiElement2 instanceof HCLBlock ? (HCLBlock)psiElement2 : null;
        if (hCLBlock == null) {
            return MapsKt.emptyMap();
        }
        HCLBlock bpp = hCLBlock;
        Map<String, PropertyOrBlockType> properties = this.getBlockProperties(bpp);
        PropertyOrBlockType propertyOrBlockType = properties.get(type);
        BlockType candidate = propertyOrBlockType instanceof BlockType ? (BlockType)propertyOrBlockType : null;
        Object object = candidate;
        if (object == null || (object = ((BlockType)object).getProperties()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, PropertyOrBlockType> getProviderProperties(HCLBlock block) {
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        ProviderType providerType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModelProvider.Companion.getModel(block).getProviderType(type, block) : null;
        return this.getPropertiesWithDefaults(TypeModel.AbstractProvider, providerType);
    }

    private final Map<String, PropertyOrBlockType> getProvisionerProperties(HCLBlock block) {
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        ProvisionerType provisionerType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModelProvider.Companion.getModel(block).getProvisionerType(type) : null;
        return this.getPropertiesWithDefaults(TypeModel.Companion.getAbstractResourceProvisioner(), provisionerType);
    }

    private final Map<String, PropertyOrBlockType> getBackendProperties(HCLBlock block) {
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        BackendType backendType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModelProvider.Companion.getModel(block).getBackendType(type) : null;
        return this.getPropertiesWithDefaults(TypeModel.Companion.getAbstractBackend(), backendType);
    }

    private final Map<String, PropertyOrBlockType> getTerraformProperties(HCLBlock block) {
        return TypeModel.Companion.getTerraform().getProperties();
    }

    private final Map<String, PropertyOrBlockType> getConnectionProperties(HCLBlock block) {
        HCLElement hCLElement = block.getObject();
        HCLExpression type = hCLElement != null && (hCLElement = hCLElement.findProperty("type")) != null ? hCLElement.getValue() : null;
        HashMap<String, PropertyOrBlockType> properties = new HashMap<String, PropertyOrBlockType>();
        properties.putAll(TypeModel.Companion.getConnection().getProperties());
        if (type instanceof HCLStringLiteral) {
            String string = ((HCLStringLiteral)type).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (Intrinsics.areEqual((Object)string4, (Object)"ssh")) {
                properties.putAll(TypeModel.Companion.getConnectionPropertiesSSH());
            } else if (Intrinsics.areEqual((Object)string4, (Object)"winrm")) {
                properties.putAll(TypeModel.Companion.getConnectionPropertiesWinRM());
            } else {
                LOG.warn("Unsupported 'connection' block type '" + ((HCLStringLiteral)type).getValue() + "'");
            }
        }
        if (type == null) {
            properties.putAll(TypeModel.Companion.getConnectionPropertiesSSH());
        }
        return properties;
    }

    @NotNull
    public final Map<String, PropertyOrBlockType> getResourceProperties(@NotNull HCLBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        ResourceType resourceType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModelProvider.Companion.getModel(block).getResourceType(type, block) : null;
        return this.getPropertiesWithDefaults(TypeModel.AbstractResource, resourceType);
    }

    private final Map<String, PropertyOrBlockType> getDataSourceProperties(HCLBlock block) {
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        DataSourceType dataSourceType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModelProvider.Companion.getModel(block).getDataSourceType(type, block) : null;
        return this.getPropertiesWithDefaults(TypeModel.AbstractDataSource, dataSourceType);
    }

    private final Map<String, PropertyOrBlockType> getEphemeralProperties(HCLBlock block) {
        String type = UtilKt.getNameElementUnquoted(block, 1);
        CharSequence charSequence = type;
        EphemeralType ephemeralType = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? TypeModel.getEphemeralType$default(TypeModelProvider.Companion.getModel(block), type, null, 2, null) : null;
        return this.getPropertiesWithDefaults(TypeModel.Companion.getAbstractEphemeralResource(), ephemeralType);
    }

    @RequiresReadLock
    @NotNull
    public final List<BlockType> getAllTypesForBlockByIdentifier(@NotNull SmartPsiElementPointer<HCLBlock> blockPointer) {
        Intrinsics.checkNotNullParameter(blockPointer, (String)"blockPointer");
        HCLBlock hCLBlock = (HCLBlock)blockPointer.getElement();
        if (hCLBlock == null) {
            return CollectionsKt.emptyList();
        }
        HCLBlock block = hCLBlock;
        String string = UtilKt.getNameElementUnquoted(block, 0);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String typeString = string;
        String string2 = UtilKt.getNameElementUnquoted(block, 1);
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String identifier = string2;
        TypeModel model = TypeModelProvider.Companion.getModel(block);
        List types = switch (typeString) {
            case "resource" -> SequencesKt.toList((Sequence)SequencesKt.filter(model.allResources(), arg_0 -> TfModelHelper.getAllTypesForBlockByIdentifier$lambda$2(identifier, arg_0)));
            case "data" -> SequencesKt.toList((Sequence)SequencesKt.filter(model.allDataSources(), arg_0 -> TfModelHelper.getAllTypesForBlockByIdentifier$lambda$3(identifier, arg_0)));
            case "provider" -> SequencesKt.toList((Sequence)SequencesKt.filter(model.allProviders(), arg_0 -> TfModelHelper.getAllTypesForBlockByIdentifier$lambda$4(identifier, arg_0)));
            case "ephemeral" -> SequencesKt.toList((Sequence)SequencesKt.filter(model.allEphemeralResources(), arg_0 -> TfModelHelper.getAllTypesForBlockByIdentifier$lambda$5(identifier, arg_0)));
            default -> CollectionsKt.emptyList();
        };
        return types;
    }

    private final Map<String, PropertyOrBlockType> getModuleProperties(HCLBlock block) {
        Map<String, PropertyOrBlockType> defaults = TypeModel.Companion.getModule().getProperties();
        Module module = Module.Companion.getAsModuleBlock(block);
        if (module == null) {
            return defaults;
        }
        Module module2 = module;
        List<Variable> variables = module2.getAllVariables();
        if (variables.isEmpty()) {
            return defaults;
        }
        HashMap<String, PropertyOrBlockType> properties = new HashMap<String, PropertyOrBlockType>();
        properties.putAll(defaults);
        for (Variable v : variables) {
            boolean hasDefault = v.getDefault() != null;
            Map map = properties;
            String string = v.getName();
            String string2 = v.getName();
            Type type = v.getType();
            if (type == null) {
                type = Types.INSTANCE.getAny();
            }
            PropertyType propertyType = new PropertyType(string2, type, null, false, null, null, false, !hasDefault, false, false, null, null, false, 8060, null);
            map.put(string, propertyType);
        }
        return properties;
    }

    private final Map<String, PropertyOrBlockType> getPropertiesWithDefaults(BlockType defaults, BlockType origin) {
        if (origin == null) {
            return defaults.getProperties();
        }
        HashMap<String, PropertyOrBlockType> result = new HashMap<String, PropertyOrBlockType>(defaults.getProperties().size() + origin.getProperties().size());
        result.putAll(defaults.getProperties());
        result.putAll(origin.getProperties());
        return result;
    }

    private static final boolean getAllTypesForBlockByIdentifier$lambda$2(String $identifier, ResourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$identifier);
    }

    private static final boolean getAllTypesForBlockByIdentifier$lambda$3(String $identifier, DataSourceType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$identifier);
    }

    private static final boolean getAllTypesForBlockByIdentifier$lambda$4(String $identifier, ProviderType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$identifier);
    }

    private static final boolean getAllTypesForBlockByIdentifier$lambda$5(String $identifier, EphemeralType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)$identifier);
    }

    static {
        Logger logger = Logger.getInstance(TfModelHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

