/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.actions.TfExternalToolsActionKt;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLFileType;
import org.intellij.terraform.install.TfToolType;
import org.intellij.terraform.runtime.TfToolPathDetector;
import org.intellij.terraform.runtime.TfToolPathDetectorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b \u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J7\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007H\u00a6@\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/intellij/terraform/config/actions/TfExternalToolsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "isAvailableOnFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkDirChildren", "onlyTerraformFileType", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformed", "invoke", "title", "", "Lorg/jetbrains/annotations/Nls;", "virtualFiles", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "CoroutineScopeProvider", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfExternalToolsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfExternalToolsAction.kt\norg/intellij/terraform/config/actions/TfExternalToolsAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,123:1\n30#2,2:124\n*S KotlinDebug\n*F\n+ 1 TfExternalToolsAction.kt\norg/intellij/terraform/config/actions/TfExternalToolsAction\n*L\n75#1:124,2\n*E\n"})
public abstract class TfExternalToolsAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    private final boolean isAvailableOnFile(VirtualFile file, boolean checkDirChildren, boolean onlyTerraformFileType) {
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (file.isDirectory()) {
            if (!checkDirChildren) {
                return false;
            }
            Object[] children = file.getChildren();
            if (children != null) {
                Iterator iterator = ArrayIteratorKt.iterator((Object[])children);
                while (iterator.hasNext()) {
                    VirtualFile child = (VirtualFile)iterator.next();
                    Intrinsics.checkNotNull((Object)child);
                    if (!this.isAvailableOnFile(child, false, onlyTerraformFileType)) continue;
                    return true;
                }
            }
            return false;
        }
        FileTypeRegistry $this$isAvailableOnFile_u24lambda_u240 = FileTypeRegistry.getInstance();
        boolean bl = false;
        return onlyTerraformFileType ? $this$isAvailableOnFile_u24lambda_u240.isFileOfType(file, (FileType)TerraformFileType.INSTANCE) : $this$isAvailableOnFile_u24lambda_u240.isFileOfType(file, (FileType)HCLFileType.INSTANCE) || $this$isAvailableOnFile_u24lambda_u240.isFileOfType(file, (FileType)TerraformFileType.INSTANCE);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file == null || !this.isAvailableOnFile(file, true, true)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    @NotNull
    protected final CoroutineScope getActionCoroutineScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CoroutineScopeProvider> serviceClass$iv = CoroutineScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((CoroutineScopeProvider)object).getCoroutineScope();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        String string = e.getPresentation().getText();
        if (string == null) {
            String string2 = HCLBundle.message("progress.title.processing", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        String title = string;
        BuildersKt.launch$default((CoroutineScope)this.getActionCoroutineScope(project2), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, project2, title, this, null){
            Object L$0;
            boolean Z$0;
            int label;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ TfExternalToolsAction this$0;
            {
                this.$file = $file;
                this.$project = $project;
                this.$title = $title;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        toolType = TfExecutorUtilKt.getApplicableToolType(this.$file);
                        this.L$0 = toolType;
                        this.label = 1;
                        v0 = TasksKt.withBackgroundProgress((Project)this.$project, (String)this.$title, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$project, toolType, null){
                            int label;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ TfToolType $toolType;
                            {
                                this.$project = $project;
                                this.$toolType = $toolType;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = TfToolPathDetector.Companion.getInstance(this.$project).detectAndVerifyTool(this.$toolType, false, (Continuation<? super Boolean>)((Continuation)this));
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl13
lbl12:
                        // 1 sources

                        return var5_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        toolType = (TfToolType)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if (!(isToolConfigured = ((Boolean)v0).booleanValue())) {
                            TfToolPathDetectorKt.showIncorrectPathNotification(this.$project, toolType);
                            return Unit.INSTANCE;
                        }
                        var4_7 = new VirtualFile[]{this.$file};
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolType);
                        this.Z$0 = isToolConfigured;
                        this.label = 2;
                        v1 = this.this$0.invoke(this.$project, this.$title, var4_7, (Continuation<? super Unit>)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl30
lbl29:
                        // 1 sources

                        return var5_2;
lbl30:
                        // 1 sources

                        ** GOTO lbl44
                    }
                    case 2: {
                        isToolConfigured = this.Z$0;
                        toolType = (TfToolType)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Exception ex) {
                            if (ex instanceof CancellationException) {
                                throw ex;
                            }
                            TfExternalToolsActionKt.notifyError(this.$title, this.$project, ex);
                            TfExternalToolsAction.access$getLOG$cp().error((Throwable)ex);
                        }
lbl44:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public abstract Object invoke(@NotNull Project var1, @NotNull String var2, @NotNull VirtualFile[] var3, @NotNull Continuation<? super Unit> var4);

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(TfExternalToolsAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/terraform/config/actions/TfExternalToolsAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/terraform/config/actions/TfExternalToolsAction$CoroutineScopeProvider;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.terraform"})
    private static final class CoroutineScopeProvider {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineScopeProvider(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

