/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HCLStatementMover
extends LineMover {
    private static final Logger LOG = Logger.getInstance(HCLStatementMover.class);

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement next;
        boolean available;
        if (editor == null) {
            HCLStatementMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            HCLStatementMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            HCLStatementMover.$$$reportNull$$$0(2);
        }
        if (!(available = super.checkAvailable(editor, file, info, down))) {
            return false;
        }
        LineRange range = HCLStatementMover.getLineRangeFromSelection((Editor)editor);
        if ((range = HCLStatementMover.expandLineRangeToCoverPsiElements(range, editor, file)) == null) {
            return false;
        }
        info.toMove = range;
        Pair<PsiElement, PsiElement> psiElements = HCLStatementMover.getElementsInRange(range, editor, file);
        if (psiElements == null) {
            return false;
        }
        PsiElement element = down ? (PsiElement)psiElements.second : (PsiElement)psiElements.first;
        PsiElement psiElement = next = down ? HCLStatementMover.getNextSiblingElement(element) : HCLStatementMover.getPrevSiblingElement(element);
        if (next != null) {
            info.toMove2 = new LineRange(next);
            return true;
        }
        return info.prohibitMove();
    }

    private static PsiElement getNextSiblingElement(PsiElement element) {
        if (element instanceof HCLBlock || element instanceof HCLProperty) {
            PsiElement next = HCLPsiUtil.getNextSiblingNonWhiteSpace(element);
            return next != null && next.getNode().getElementType() != HCLElementTypes.R_CURLY ? next : null;
        }
        return null;
    }

    private static PsiElement getPrevSiblingElement(PsiElement element) {
        if (element instanceof HCLBlock || element instanceof HCLProperty) {
            PsiElement prev = HCLPsiUtil.getPrevSiblingNonWhiteSpace(element);
            return prev != null && prev.getNode().getElementType() != HCLElementTypes.L_CURLY ? prev : null;
        }
        return null;
    }

    private static Pair<PsiElement, PsiElement> getElementsInRange(LineRange range, Editor editor, PsiFile file) {
        Language language = HCLStatementMover.findHCLOrLikeLanguage(file);
        if (language == null) {
            return null;
        }
        Pair psiRange = HCLStatementMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)range);
        if (psiRange == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
        return HCLStatementMover.getElementRange((PsiElement)parent, (PsiElement)((PsiElement)psiRange.getFirst()), (PsiElement)((PsiElement)psiRange.getSecond()));
    }

    private static LineRange expandLineRangeToCoverPsiElements(LineRange range, Editor editor, PsiFile file) {
        int endLine;
        Document document;
        Pair<PsiElement, PsiElement> elementRange = HCLStatementMover.getElementsInRange(range, editor, file);
        if (elementRange == null) {
            return null;
        }
        int endOffset = ((PsiElement)elementRange.getSecond()).getTextRange().getEndOffset();
        if (endOffset > (document = editor.getDocument()).getTextLength()) {
            LOG.assertTrue(!PsiDocumentManager.getInstance((Project)file.getProject()).isUncommited(document));
            LOG.assertTrue(PsiDocumentManagerBase.checkConsistency((PsiFile)file, (Document)document));
        }
        if (endOffset == document.getTextLength()) {
            endLine = document.getLineCount();
        } else {
            endLine = editor.offsetToLogicalPosition((int)endOffset).line + 1;
            endLine = Math.min(endLine, document.getLineCount());
        }
        int startLine = Math.min(range.startLine, editor.offsetToLogicalPosition((int)((PsiElement)elementRange.getFirst()).getNode().getStartOffset()).line);
        endLine = Math.max(endLine, range.endLine);
        return new LineRange(startLine, endLine);
    }

    @Nullable
    private static Language findHCLOrLikeLanguage(@NotNull PsiFile file) {
        if (file == null) {
            HCLStatementMover.$$$reportNull$$$0(3);
        }
        Set languages = file.getViewProvider().getLanguages();
        for (Language language : languages) {
            if (language != HCLLanguage.INSTANCE) continue;
            return language;
        }
        for (Language language : languages) {
            if (!language.isKindOf((Language)HCLLanguage.INSTANCE)) continue;
            return language;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/intellij/terraform/config/HCLStatementMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findHCLOrLikeLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

