/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform;

import com.intellij.lang.Language;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.hcl.HCLLanguage;
import org.intellij.terraform.opentofu.OpenTofuFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0012\u0010\b\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0012\u0010\n\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0016\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0000\u001a\u001e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013\u001a\u001c\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a8\u0006\u0017"}, d2={"isTerraformFileExtension", "", "extension", "", "isTerraformCompatibleExtension", "isTerraformCompatiblePsiFile", "file", "Lcom/intellij/psi/PsiFile;", "isTerraformFile", "psiFile", "isOpenTofuFile", "joinCommaOr", "list", "", "hasHCLLanguageFiles", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/LanguageFileType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/intellij/terraform/UtilKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,51:1\n1255#2,2:52\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/intellij/terraform/UtilKt\n*L\n49#1:52,2\n*E\n"})
public final class UtilKt {
    public static final boolean isTerraformFileExtension(@Nullable String extension) {
        return Intrinsics.areEqual((Object)extension, (Object)"tf") || Intrinsics.areEqual((Object)extension, (Object)"tfvars");
    }

    public static final boolean isTerraformCompatibleExtension(@Nullable String extension) {
        return UtilKt.isTerraformFileExtension(extension) || Intrinsics.areEqual((Object)extension, (Object)"tofu");
    }

    public static final boolean isTerraformCompatiblePsiFile(@Nullable PsiFile file) {
        return UtilKt.isTerraformFile(file) || UtilKt.isOpenTofuFile(file);
    }

    public static final boolean isTerraformFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        return (psiFile2 != null ? psiFile2.getFileType() : null) instanceof TerraformFileType;
    }

    public static final boolean isOpenTofuFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        return (psiFile2 != null ? psiFile2.getFileType() : null) instanceof OpenTofuFileType;
    }

    @NotNull
    public static final String joinCommaOr(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        return switch (list.size()) {
            case 0 -> "";
            case 1 -> (String)CollectionsKt.first(list);
            default -> CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(list, (int)1), null, null, (CharSequence)(" or " + CollectionsKt.last(list)), (int)0, null, null, (int)59, null);
        };
    }

    @Nullable
    public static final Object hasHCLLanguageFiles(@NotNull Project project, @NotNull LanguageFileType fileType, @NotNull Continuation<? super Boolean> $completion) {
        return CoroutinesKt.smartReadAction((Project)project, () -> UtilKt.hasHCLLanguageFiles$lambda$0(project, fileType), $completion);
    }

    public static final boolean hasHCLLanguageFiles(@NotNull Project project, @NotNull Iterable<? extends FileType> fileTypes) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(fileTypes, (String)"fileTypes");
            Sequence $this$any$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence(fileTypes), UtilKt::hasHCLLanguageFiles$lambda$1);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileType ft = (FileType)element$iv;
                boolean bl2 = false;
                if (!FileTypeIndex.containsFileOfType((FileType)ft, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean hasHCLLanguageFiles$lambda$0(Project $project, LanguageFileType $fileType) {
        return UtilKt.hasHCLLanguageFiles($project, CollectionsKt.listOf((Object)$fileType));
    }

    private static final boolean hasHCLLanguageFiles$lambda$1(FileType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LanguageFileType languageFileType = type instanceof LanguageFileType ? (LanguageFileType)type : null;
        return languageFileType != null && (languageFileType = languageFileType.getLanguage()) != null ? languageFileType.isKindOf((Language)HCLLanguage.INSTANCE) : false;
    }
}

