/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\bH\u0014J\b\u0010\u000b\u001a\u00020\bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/terraform/TfUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "TERRAGRUNT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getGroup", "requiresReadAccess", "requiresSmartMode", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terraform"})
public final class TfUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("terraform.project.metrics", 1, null, 4, null);
    @NotNull
    private final EventId1<Boolean> TERRAGRUNT = this.GROUP.registerEvent("terragrunt.found", (EventField)EventFields.Boolean((String)"exists"), "if \"terragrunt.hcl\" file exists in the project among other terraform files");

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set result = new LinkedHashSet();
        FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
        if (UtilKt.hasHCLLanguageFiles(project, ArraysKt.asList((Object[])fileTypeArray))) {
            CommonProcessors.FindFirstProcessor terragruntSearch = new CommonProcessors.FindFirstProcessor();
            FilenameIndex.processFilesByName((String)"terragrunt.hcl", (boolean)false, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (Processor)((Processor)terragruntSearch));
            result.add(this.TERRAGRUNT.metric((Object)terragruntSearch.isFound()));
        }
        return result;
    }
}

