/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.dom;

import org.jetbrains.relocated.apache.batik.dom.AbstractChildNode;
import org.jetbrains.relocated.apache.batik.dom.AbstractDocument;
import org.jetbrains.relocated.apache.batik.dom.AbstractParentNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends AbstractChildNode
implements CharacterData {
    protected String nodeValue = "";

    @Override
    public String getNodeValue() throws DOMException {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        String val = this.nodeValue;
        this.nodeValue = nodeValue == null ? "" : nodeValue;
        this.fireDOMCharacterDataModifiedEvent(val, this.nodeValue);
        if (this.getParentNode() != null) {
            ((AbstractParentNode)this.getParentNode()).fireDOMSubtreeModifiedEvent();
        }
    }

    @Override
    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setData(String data2) throws DOMException {
        this.setNodeValue(data2);
    }

    @Override
    public int getLength() {
        return this.nodeValue.length();
    }

    @Override
    public String substringData(int offset2, int count2) throws DOMException {
        this.checkOffsetCount(offset2, count2);
        String v = this.getNodeValue();
        return v.substring(offset2, Math.min(v.length(), offset2 + count2));
    }

    @Override
    public void appendData(String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.setNodeValue(this.getNodeValue() + (arg == null ? "" : arg));
    }

    @Override
    public void insertData(int offset2, String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        if (offset2 < 0 || offset2 > this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{offset2});
        }
        String v = this.getNodeValue();
        this.setNodeValue(v.substring(0, offset2) + arg + v.substring(offset2, v.length()));
    }

    @Override
    public void deleteData(int offset2, int count2) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.checkOffsetCount(offset2, count2);
        String v = this.getNodeValue();
        this.setNodeValue(v.substring(0, offset2) + v.substring(Math.min(v.length(), offset2 + count2), v.length()));
    }

    @Override
    public void replaceData(int offset2, int count2, String arg) throws DOMException {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        this.checkOffsetCount(offset2, count2);
        String v = this.getNodeValue();
        this.setNodeValue(v.substring(0, offset2) + arg + v.substring(Math.min(v.length(), offset2 + count2), v.length()));
    }

    protected void checkOffsetCount(int offset2, int count2) throws DOMException {
        if (offset2 < 0 || offset2 >= this.getLength()) {
            throw this.createDOMException((short)1, "offset", new Object[]{offset2});
        }
        if (count2 < 0) {
            throw this.createDOMException((short)1, "negative.count", new Object[]{count2});
        }
    }

    @Override
    protected Node export(Node n, AbstractDocument d) {
        super.export(n, d);
        AbstractCharacterData cd = (AbstractCharacterData)n;
        cd.nodeValue = this.nodeValue;
        return n;
    }

    @Override
    protected Node deepExport(Node n, AbstractDocument d) {
        super.deepExport(n, d);
        AbstractCharacterData cd = (AbstractCharacterData)n;
        cd.nodeValue = this.nodeValue;
        return n;
    }

    @Override
    protected Node copyInto(Node n) {
        super.copyInto(n);
        AbstractCharacterData cd = (AbstractCharacterData)n;
        cd.nodeValue = this.nodeValue;
        return n;
    }

    @Override
    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        AbstractCharacterData cd = (AbstractCharacterData)n;
        cd.nodeValue = this.nodeValue;
        return n;
    }
}

