/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.quickfix.VgoModuleDownloader;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoDownloadSingleMissingModuleFix
extends BaseIntentionAction
implements LocalQuickFix {
    @NotNull
    private final String myMissingModulePath;

    public VgoDownloadSingleMissingModuleFix(@NlsSafe @NotNull String replacedModulePath, @NlsSafe @Nullable String replacementModulePath) {
        if (replacedModulePath == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(0);
        }
        this.myMissingModulePath = replacedModulePath;
        this.setText(replacementModulePath == null || replacedModulePath.equals(replacementModulePath) ? GoBundle.message((String)"go.intention.download.single.missing.module.fix.text", (Object[])new Object[]{this.myMissingModulePath}) : GoBundle.message((String)"go.intention.download.single.missing.module.fix.from.replacement.text", (Object[])new Object[]{this.myMissingModulePath, replacementModulePath}));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.intention.download.single.missing.module.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file;
        if (project == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(3);
        }
        if ((file = (PsiFile)ObjectUtils.doIfNotNull((Object)descriptor.getStartElement(), startElement -> startElement.getContainingFile())) != null) {
            this.invoke(project, null, file);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(4);
        }
        return psiFile != null && psiFile.getVirtualFile() != null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(5);
        }
        if (previewDescriptor == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(6);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(10);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(11);
        }
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        Module module;
        Pair.NonNull<VgoModule, VgoDependency> vgoModulePair;
        if (project == null) {
            VgoDownloadSingleMissingModuleFix.$$$reportNull$$$0(12);
        }
        if ((vgoModulePair = VgoUtil.findModuleAndDependencyOfFile(project, module = GoUtil.module((PsiElement)psiFile), psiFile.getVirtualFile())) == null) {
            return;
        }
        VgoModuleDownloader.downloadModule(project, module, (VgoModuleOrWorkspace)vgoModulePair.first, this.myMissingModulePath, this.getText(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacedModulePath";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/quickfix/VgoDownloadSingleMissingModuleFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/quickfix/VgoDownloadSingleMissingModuleFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 11 -> new IllegalStateException(string);
        };
    }
}

