/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.inspections;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.vgo.mod.psi.VgoUseDirective;
import com.goide.vgo.mod.psi.VgoVisitor;
import com.goide.vgo.mod.quickfix.VgoMergeUseDirectivesFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/goide/vgo/mod/inspections/VgoWorkspaceUseDirectivesMergeInspection;", "Lcom/goide/vgo/mod/psi/VgoVisitor;", "holder", "Lcom/goide/highlighting/GoAnnotationHolder;", "<init>", "(Lcom/goide/highlighting/GoAnnotationHolder;)V", "getHolder", "()Lcom/goide/highlighting/GoAnnotationHolder;", "visitFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.go.impl"})
public final class VgoWorkspaceUseDirectivesMergeInspection
extends VgoVisitor {
    @NotNull
    private final GoAnnotationHolder holder;

    public VgoWorkspaceUseDirectivesMergeInspection(@NotNull GoAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @NotNull
    public final GoAnnotationHolder getHolder() {
        return this.holder;
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        super.visitFile(psiFile);
        Object[] directives = (VgoUseDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)psiFile), VgoUseDirective.class);
        if (directives != null && directives.length > 1) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.go.work.multiple.use.directives");
            Intrinsics.checkNotNullExpressionValue((Object)goInspectionMessageWithI18n, (String)"message(...)");
            GoInspectionMessage message = goInspectionMessageWithI18n;
            Iterator iterator = ArrayIteratorKt.iterator((Object[])directives);
            while (iterator.hasNext()) {
                VgoUseDirective directive = (VgoUseDirective)iterator.next();
                GoSpecCheckerUtil.withQuickFix(this.holder.newWeakWarningAnnotation(directive, message), new VgoMergeUseDirectivesFix(), directive, message).create();
            }
        }
    }
}

