/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.highlighting;

import com.goide.i18n.GoBundle;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoReplacement;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VgoLocalPathsHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final VgoFile myFile;
    private final List<HighlightInfo> myHighlightInfos;

    public VgoLocalPathsHighlightingPass(@NotNull VgoFile file, @NotNull Document document) {
        if (file == null) {
            VgoLocalPathsHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            VgoLocalPathsHighlightingPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), document);
        this.myHighlightInfos = new ArrayList<HighlightInfo>();
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            VgoLocalPathsHighlightingPass.$$$reportNull$$$0(2);
        }
        PsiTreeUtil.findChildrenOfType((PsiElement)this.myFile, VgoReplacement.class).forEach(replacement -> {
            VgoModuleSpec target = replacement.getTarget();
            if (target == null) {
                return;
            }
            PsiElement identifier = target.getIdentifier();
            String dependencyName = identifier.getText();
            if (dependencyName.startsWith(".") || FileUtil.isAbsolute((String)dependencyName)) {
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(identifier).description(GoBundle.message((String)"go.code.smells.commit.local.paths", (Object[])new Object[0])).create();
                this.myHighlightInfos.add(highlightInfo);
            }
        });
    }

    @NotNull
    public List<HighlightInfo> getInfos() {
        List<HighlightInfo> list = this.myHighlightInfos;
        if (list == null) {
            VgoLocalPathsHighlightingPass.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void doApplyInformationToEditor() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/highlighting/VgoLocalPathsHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoLocalPathsHighlightingPass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

