/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.configuration;

import com.goide.GoLibrariesUtil;
import com.goide.i18n.GoBundle;
import com.goide.vgo.configuration.VgoEnvironmentVariablesField;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.configuration.VgoSettings;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemGroupConfigurable;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.components.ValidationTooltipKt;
import com.intellij.ui.dsl.builder.components.ValidationType;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/goide/vgo/configuration/VgoSettingsUI;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/goide/vgo/configuration/VgoProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "myDialogMode", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "projectSettings", "globalSettings", "Lcom/goide/vgo/configuration/VgoSettings;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "reset", "", "settings", "isModified", "apply", "getComponent", "Ljavax/swing/JComponent;", "bindEnvs", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/goide/vgo/configuration/VgoEnvironmentVariablesField;", "showBuildToolsSettingsPage", "component", "Ljava/awt/Component;", "saveDownloadSettingsState", "state", "Lcom/goide/vgo/configuration/VgoSettingsUI$DownloadSettingsState;", "loadDownloadSettingsState", "DownloadSettingsState", "Companion", "intellij.go.impl"})
public final class VgoSettingsUI
implements ConfigurableUi<VgoProjectSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean myDialogMode;
    @NotNull
    private final VgoProjectSettings projectSettings;
    @NotNull
    private final VgoSettings globalSettings;
    private DialogPanel panel;
    @NotNull
    private static final String VENDORING_DOCUMENTATION_URL = "https://github.com/golang/go/wiki/Modules#how-do-i-use-vendoring-with-modules-is-vendoring-going-away";

    public VgoSettingsUI(@NotNull Project project, boolean myDialogMode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myDialogMode = myDialogMode;
        VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vgoProjectSettings, (String)"getInstance(...)");
        this.projectSettings = vgoProjectSettings;
        VgoSettings vgoSettings = VgoSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)vgoSettings, (String)"getInstance(...)");
        this.globalSettings = vgoSettings;
    }

    public void reset(@NotNull VgoProjectSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.reset();
    }

    public boolean isModified(@NotNull VgoProjectSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return dialogPanel.isModified();
    }

    public void apply(@NotNull VgoProjectSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
    }

    @NotNull
    public JComponent getComponent() {
        this.panel = BuilderKt.panel(arg_0 -> VgoSettingsUI.getComponent$lambda$9(this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return (JComponent)dialogPanel;
    }

    private final void bindEnvs(Cell<? extends VgoEnvironmentVariablesField> $this$bindEnvs) {
        $this$bindEnvs.bind(VgoSettingsUI::bindEnvs$lambda$10, VgoSettingsUI::bindEnvs$lambda$11, MutablePropertyKt.MutableProperty((Function0)((Function0)new Function0<Map<String, String>>((Object)this.projectSettings){

            public final Map<String, String> invoke() {
                return ((VgoProjectSettings)this.receiver).getEnvironment();
            }
        }), (Function1)((Function1)new Function1<Map<String, String>, Unit>((Object)this.projectSettings){

            public final void invoke(Map<String, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((VgoProjectSettings)this.receiver).setEnvironment(p0);
            }
        })));
        $this$bindEnvs.onApply(() -> VgoSettingsUI.bindEnvs$lambda$12($this$bindEnvs));
    }

    private final void showBuildToolsSettingsPage(Component component2) {
        boolean bl;
        try {
            DataContext dataContext = DataManager.getInstance().getDataContext(component2);
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Settings settings = (Settings)Settings.KEY.getData(dataContext);
            Settings settings2 = settings;
            bl = settings2 != null && (settings2 = settings2.select(settings.find(ExternalSystemGroupConfigurable.class))) != null ? settings2.isRejected() : true;
        }
        catch (IllegalStateException exception) {
            bl = true;
        }
        boolean rejected = bl;
        if (rejected) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.project, ExternalSystemGroupConfigurable.class);
        }
    }

    private final void saveDownloadSettingsState(DownloadSettingsState state) {
        if (state == null) {
            return;
        }
        Function0 runnable = () -> VgoSettingsUI.saveDownloadSettingsState$lambda$13(this, state);
        if (!this.loadDownloadSettingsState().getEnabled() && state.getEnabled()) {
            GoLibrariesUtil.updateLibraries(this.project, RootsChangeRescanningInfo.NO_RESCAN_NEEDED, () -> VgoSettingsUI.saveDownloadSettingsState$lambda$14(runnable), null);
        } else {
            runnable.invoke();
        }
    }

    private final DownloadSettingsState loadDownloadSettingsState() {
        DownloadSettingsState downloadSettingsState;
        boolean globallyEnabled = this.globalSettings.isAutomaticDependenciesDownloadGloballyEnabled();
        Boolean projectEnabled = this.projectSettings.isAutomaticDependenciesDownloadEnabled();
        boolean bl = globallyEnabled;
        if (bl) {
            downloadSettingsState = Intrinsics.areEqual((Object)projectEnabled, (Object)false) ? DownloadSettingsState.DISABLE_ONLY_FOR_THIS_PROJECT : DownloadSettingsState.ENABLE_GLOBALLY;
        } else if (!bl) {
            downloadSettingsState = Intrinsics.areEqual((Object)projectEnabled, (Object)true) ? DownloadSettingsState.ENABLE_ONLY_FOR_THIS_PROJECT : DownloadSettingsState.DISABLE_GLOBALLY;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return downloadSettingsState;
    }

    private static final Unit getComponent$lambda$9$lambda$0(Ref.ObjectRef $isIntegrationEnabled, VgoSettingsUI this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.settings.modules.enable.integration.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $isIntegrationEnabled.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.projectSettings){

            public final Boolean invoke() {
                return ((VgoProjectSettings)this.receiver).isIntegrationEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.projectSettings){

            public final void invoke(boolean p0) {
                ((VgoProjectSettings)this.receiver).setIntegrationEnabled(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$9$lambda$8$lambda$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.settings.modules.do.not.set.goexperiment", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationTooltipKt.validationTooltip((Row)$this$row, (String)string, null, null, (ValidationType)ValidationType.WARNING, (boolean)true).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final void getComponent$lambda$9$lambda$8$lambda$4$lambda$3$lambda$2(AtomicBooleanProperty $showGoExperimentVarWarning, VgoEnvironmentVariablesField $this_applyToComponent, ChangeEvent it) {
        $showGoExperimentVarWarning.set($this_applyToComponent.getEnvs().containsKey("GOEXPERIMENT"));
    }

    private static final Unit getComponent$lambda$9$lambda$8$lambda$4$lambda$3(AtomicBooleanProperty $showGoExperimentVarWarning, VgoEnvironmentVariablesField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
        $this$applyToComponent.addChangeListener(arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$4$lambda$3$lambda$2($showGoExperimentVarWarning, $this$applyToComponent, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$9$lambda$8$lambda$4(VgoSettingsUI this$0, AtomicBooleanProperty $showGoExperimentVarWarning, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.bindEnvs((Cell<? extends VgoEnvironmentVariablesField>)Cell.comment$default((Cell)$this$row.cell((JComponent)((Object)new VgoEnvironmentVariablesField())).align((Align)AlignX.FILL.INSTANCE), (String)GoBundle.message((String)"go.settings.modules.environment.context.help", (Object[])new Object[0]), (int)0, null, (int)6, null).applyToComponent(arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$4$lambda$3($showGoExperimentVarWarning, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$9$lambda$8$lambda$5(VgoSettingsUI this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.settings.modules.vendoring.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string).gap(RightGap.SMALL), (Function0)((Function0)new Function0<Boolean>((Object)this$0.projectSettings){

            public final Boolean invoke() {
                return ((VgoProjectSettings)this.receiver).isAutoVendoringMode();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.projectSettings){

            public final void invoke(boolean p0) {
                ((VgoProjectSettings)this.receiver).setAutoVendoringMode(p0);
            }
        }));
        $this$row.cell((JComponent)Companion.createContextHelpLabel());
        return Unit.INSTANCE;
    }

    private static final void getComponent$lambda$9$lambda$8$lambda$7$lambda$6(VgoSettingsUI this$0, Ref.ObjectRef $isIntegrationEnabled) {
        Cell cell;
        if ($isIntegrationEnabled.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"isIntegrationEnabled");
            cell = null;
        } else {
            cell = (Cell)$isIntegrationEnabled.element;
        }
        this$0.showBuildToolsSettingsPage(cell.getComponent());
    }

    private static final Unit getComponent$lambda$9$lambda$8$lambda$7(VgoSettingsUI this$0, Ref.ObjectRef $isIntegrationEnabled, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GoBundle.message((String)"go.settings.modules.automatic.dependencies.download.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).gap(RightGap.SMALL);
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (Collection)ArraysKt.toList((Object[])DownloadSettingsState.values()), null, (int)2, null).gap(RightGap.SMALL), (Function0)((Function0)new Function0<DownloadSettingsState>((Object)this$0){

            public final DownloadSettingsState invoke() {
                return VgoSettingsUI.access$loadDownloadSettingsState((VgoSettingsUI)this.receiver);
            }
        }), (Function1)((Function1)new Function1<DownloadSettingsState, Unit>((Object)this$0){

            public final void invoke(DownloadSettingsState p0) {
                VgoSettingsUI.access$saveDownloadSettingsState((VgoSettingsUI)this.receiver, p0);
            }
        }));
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.createWithLink(null, (String)GoBundle.message((String)"go.settings.modules.automatic.dependencies.download.checkbox.tooltip", (Object[])new Object[0]), (String)GoBundle.message((String)"go.settings.modules.automatic.dependencies.download.checkbox.link", (Object[])new Object[0]), () -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$7$lambda$6(this$0, $isIntegrationEnabled));
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"createWithLink(...)");
        $this$row.cell((JComponent)contextHelpLabel);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$9$lambda$8(AtomicBooleanProperty $showGoExperimentVarWarning, VgoSettingsUI this$0, Ref.ObjectRef $isIntegrationEnabled, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.row("", VgoSettingsUI::getComponent$lambda$9$lambda$8$lambda$1).visibleIf((ObservableProperty)$showGoExperimentVarWarning);
        String string = GoBundle.message((String)"go.settings.modules.environment.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$indent.row(string, arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$4(this$0, $showGoExperimentVarWarning, arg_0));
        Panel.row$default((Panel)$this$indent, null, arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$5(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8$lambda$7(this$0, $isIntegrationEnabled, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$9(VgoSettingsUI this$0, Panel $this$panel) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef isIntegrationEnabled = new Ref.ObjectRef();
        AtomicBooleanProperty showGoExperimentVarWarning = new AtomicBooleanProperty(false);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$0(isIntegrationEnabled, this$0, arg_0), (int)1, null);
        RowsRange rowsRange = $this$panel.indent(arg_0 -> VgoSettingsUI.getComponent$lambda$9$lambda$8(showGoExperimentVarWarning, this$0, isIntegrationEnabled, arg_0));
        if (isIntegrationEnabled.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"isIntegrationEnabled");
            cell = null;
        } else {
            cell = (Cell)isIntegrationEnabled.element;
        }
        rowsRange.enabledIf(ButtonKt.getSelected((Cell)cell));
        if (this$0.myDialogMode) {
            this$0.getComponent().setPreferredSize((Dimension)JBUI.size((int)400, (int)250));
        }
        return Unit.INSTANCE;
    }

    private static final Map bindEnvs$lambda$10(VgoEnvironmentVariablesField field) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        return field.getEnvs();
    }

    private static final Unit bindEnvs$lambda$11(VgoEnvironmentVariablesField field, Map value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)field), (String)"field");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        field.setEnvs(value2);
        return Unit.INSTANCE;
    }

    private static final Unit bindEnvs$lambda$12(Cell $this_bindEnvs) {
        VgoSettings.getInstance().addEnvironmentVars(((VgoEnvironmentVariablesField)((Object)$this_bindEnvs.getComponent())).getEnvs());
        return Unit.INSTANCE;
    }

    private static final Unit saveDownloadSettingsState$lambda$13(VgoSettingsUI this$0, DownloadSettingsState $state) {
        this$0.globalSettings.setAutomaticDependenciesDownloadGloballyEnabled($state.getGloballyEnabled());
        this$0.projectSettings.setAutomaticDependenciesDownloadEnabled($state.getProjectEnabled());
        return Unit.INSTANCE;
    }

    private static final void saveDownloadSettingsState$lambda$14(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ DownloadSettingsState access$loadDownloadSettingsState(VgoSettingsUI $this) {
        return $this.loadDownloadSettingsState();
    }

    public static final /* synthetic */ void access$saveDownloadSettingsState(VgoSettingsUI $this, DownloadSettingsState state) {
        $this.saveDownloadSettingsState(state);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bJ\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/goide/vgo/configuration/VgoSettingsUI$Companion;", "", "<init>", "()V", "VENDORING_DOCUMENTATION_URL", "", "createContextHelpLabel", "Lcom/intellij/ui/ContextHelpLabel;", "Lorg/jetbrains/annotations/NotNull;", "createVendoringCheckbox", "Lcom/intellij/ui/components/JBCheckBox;", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContextHelpLabel createContextHelpLabel() {
            ContextHelpLabel contextHelpLabel = ContextHelpLabel.createWithLink(null, (String)GoBundle.message((String)"go.settings.modules.vendoring.checkbox.tooltip", (Object[])new Object[0]), (String)GoBundle.message((String)"go.settings.modules.vendoring.documentation.link.title", (Object[])new Object[0]), Companion::createContextHelpLabel$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"createWithLink(...)");
            return contextHelpLabel;
        }

        @NotNull
        public final JBCheckBox createVendoringCheckbox() {
            return new JBCheckBox(GoBundle.message((String)"go.settings.modules.vendoring.checkbox", (Object[])new Object[0]), true);
        }

        private static final void createContextHelpLabel$lambda$0() {
            BrowserUtil.browse((String)VgoSettingsUI.VENDORING_DOCUMENTATION_URL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0017"}, d2={"Lcom/goide/vgo/configuration/VgoSettingsUI$DownloadSettingsState;", "", "globallyEnabled", "", "projectEnabled", "messageKey", "", "<init>", "(Ljava/lang/String;IZLjava/lang/Boolean;Ljava/lang/String;)V", "getGloballyEnabled", "()Z", "getProjectEnabled", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getMessageKey", "()Ljava/lang/String;", "ENABLE_GLOBALLY", "DISABLE_GLOBALLY", "ENABLE_ONLY_FOR_THIS_PROJECT", "DISABLE_ONLY_FOR_THIS_PROJECT", "toString", "enabled", "getEnabled", "intellij.go.impl"})
    private static final class DownloadSettingsState
    extends Enum<DownloadSettingsState> {
        private final boolean globallyEnabled;
        @Nullable
        private final Boolean projectEnabled;
        @NotNull
        private final String messageKey;
        public static final /* enum */ DownloadSettingsState ENABLE_GLOBALLY = new DownloadSettingsState(true, null, "go.settings.modules.automatic.dependencies.download.enable.for.all");
        public static final /* enum */ DownloadSettingsState DISABLE_GLOBALLY = new DownloadSettingsState(false, null, "go.settings.modules.automatic.dependencies.download.disable.for.all");
        public static final /* enum */ DownloadSettingsState ENABLE_ONLY_FOR_THIS_PROJECT = new DownloadSettingsState(false, true, "go.settings.modules.automatic.dependencies.download.enable.for.current.project");
        public static final /* enum */ DownloadSettingsState DISABLE_ONLY_FOR_THIS_PROJECT = new DownloadSettingsState(true, false, "go.settings.modules.automatic.dependencies.download.disable.for.current.project");
        private static final /* synthetic */ DownloadSettingsState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DownloadSettingsState(boolean globallyEnabled, Boolean projectEnabled, String messageKey) {
            this.globallyEnabled = globallyEnabled;
            this.projectEnabled = projectEnabled;
            this.messageKey = messageKey;
        }

        public final boolean getGloballyEnabled() {
            return this.globallyEnabled;
        }

        @Nullable
        public final Boolean getProjectEnabled() {
            return this.projectEnabled;
        }

        @NotNull
        public final String getMessageKey() {
            return this.messageKey;
        }

        @NotNull
        public String toString() {
            String string = GoBundle.message((String)this.messageKey, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public final boolean getEnabled() {
            Boolean bl = this.projectEnabled;
            return bl != null ? bl : this.globallyEnabled;
        }

        public static DownloadSettingsState[] values() {
            return (DownloadSettingsState[])$VALUES.clone();
        }

        public static DownloadSettingsState valueOf(String value2) {
            return Enum.valueOf(DownloadSettingsState.class, value2);
        }

        @NotNull
        public static EnumEntries<DownloadSettingsState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = downloadSettingsStateArray = new DownloadSettingsState[]{DownloadSettingsState.ENABLE_GLOBALLY, DownloadSettingsState.DISABLE_GLOBALLY, DownloadSettingsState.ENABLE_ONLY_FOR_THIS_PROJECT, DownloadSettingsState.DISABLE_ONLY_FOR_THIS_PROJECT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

