/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.configuration;

import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service
@State(name="vgo", storages={@Storage(value="vgo.xml", roamingType=RoamingType.DISABLED, exportable=true)})
public final class VgoSettings
implements PersistentStateComponent<VgoSettings> {
    @Tag(value="environment")
    private final Map<String, List<String>> myEnvironmentVars = new HashMap<String, List<String>>();
    @Tag(value="automatic-dependencies-download-globally-enabled")
    private boolean autoDepDownloadGloballyEnabled = true;

    @NotNull
    public static VgoSettings getInstance() {
        VgoSettings vgoSettings = (VgoSettings)ApplicationManager.getApplication().getService(VgoSettings.class);
        if (vgoSettings == null) {
            VgoSettings.$$$reportNull$$$0(0);
        }
        return vgoSettings;
    }

    public void addEnvironmentVars(@NotNull Map<String, String> environment) {
        if (environment == null) {
            VgoSettings.$$$reportNull$$$0(1);
        }
        for (VgoEnvironmentVariable knownVariable : VgoEnvironmentVariable.getKnownVariables(null).values()) {
            String value2 = environment.get(knownVariable.getName());
            if (!StringUtil.isNotEmpty((String)value2)) continue;
            List storedValues = this.myEnvironmentVars.computeIfAbsent(knownVariable.getName(), __ -> new LinkedList());
            storedValues.remove(value2);
            storedValues.add(0, value2);
        }
    }

    @NotNull
    public List<String> getEnvironmentVariableValues(@NotNull String variableName) {
        if (variableName == null) {
            VgoSettings.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.unmodifiableOrEmptyList(this.myEnvironmentVars.getOrDefault(variableName, Collections.emptyList()));
        if (list == null) {
            VgoSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isAutomaticDependenciesDownloadGloballyEnabled() {
        return this.autoDepDownloadGloballyEnabled;
    }

    public void setAutomaticDependenciesDownloadGloballyEnabled(boolean enabled) {
        this.autoDepDownloadGloballyEnabled = enabled;
    }

    @NotNull
    public VgoSettings getState() {
        VgoSettings vgoSettings = this;
        if (vgoSettings == null) {
            VgoSettings.$$$reportNull$$$0(4);
        }
        return vgoSettings;
    }

    public void loadState(@NotNull VgoSettings state) {
        if (state == null) {
            VgoSettings.$$$reportNull$$$0(5);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/configuration/VgoSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/configuration/VgoSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVariableValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addEnvironmentVars";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVariableValues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5 -> new IllegalArgumentException(string);
        };
    }
}

