/*
 * Decompiled with CFR 0.152.
 */
package com.goide.utils;

import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStringUtil {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count2) {
        if (s == null) {
            GoStringUtil.$$$reportNull$$$0(0);
        }
        if (count2 == 0) {
            return "";
        }
        assert (count2 >= 0) : count2;
        StringBuilder sb = new StringBuilder(s.length() * count2);
        for (int i = 0; i < count2; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String unescapeStringLiteralText(@Nullable String stringLiteralText) {
        GoDecodedString decodedString = GoStringUtil.decodeStringLiteralExpression(stringLiteralText);
        return decodedString.correct ? decodedString.unescapedString : null;
    }

    public static GoDecodedString decodeStringLiteralExpression(@Nullable String stringLiteralText) {
        String unquoted = GoStringUtil.unquoteStringLiteralExpression(stringLiteralText);
        if (unquoted == null || unquoted.isEmpty()) {
            return new GoDecodedString(unquoted != null, EMPTY_INT_ARRAY, "");
        }
        boolean raw = stringLiteralText.charAt(0) == '`';
        return raw ? new GoDecodedString(true, EMPTY_INT_ARRAY, unquoted) : GoStringUtil.decode(unquoted);
    }

    @NotNull
    public static String createSingleLineString(@NotNull String stringContent) {
        if (stringContent == null) {
            GoStringUtil.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        result.append("\"");
        GoStringUtil.escapeString(stringContent, result);
        result.append("\"");
        String string = result.toString();
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String escapeString(@NotNull String string) {
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(4);
        }
        StringBuilder escapedString = new StringBuilder();
        GoStringUtil.escapeString(string, escapedString);
        String string2 = escapedString.toString();
        if (string2 == null) {
            GoStringUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public static void escapeString(@NotNull String chars, @NotNull StringBuilder outChars) {
        int c;
        if (chars == null) {
            GoStringUtil.$$$reportNull$$$0(6);
        }
        if (outChars == null) {
            GoStringUtil.$$$reportNull$$$0(7);
        }
        block14: for (int index = 0; index < chars.length(); index += Character.charCount(c)) {
            c = chars.codePointAt(index);
            switch (c) {
                case 7: {
                    outChars.append("\\a");
                    continue block14;
                }
                case 8: {
                    outChars.append("\\b");
                    continue block14;
                }
                case 12: {
                    outChars.append("\\f");
                    continue block14;
                }
                case 10: {
                    outChars.append("\\n");
                    continue block14;
                }
                case 13: {
                    outChars.append("\\r");
                    continue block14;
                }
                case 9: {
                    outChars.append("\\t");
                    continue block14;
                }
                case 11: {
                    outChars.append("\\v");
                    continue block14;
                }
                case 92: {
                    outChars.append("\\\\");
                    continue block14;
                }
                case 34: {
                    outChars.append("\\\"");
                    continue block14;
                }
                default: {
                    switch (Character.getType(c)) {
                        case 0: 
                        case 15: 
                        case 18: {
                            if (c <= 65535) {
                                outChars.append("\\u").append(String.format(Locale.US, "%04X", c));
                                continue block14;
                            }
                            outChars.append("\\U").append(String.format(Locale.US, "%08X", c));
                            continue block14;
                        }
                    }
                    outChars.appendCodePoint(c);
                }
            }
        }
    }

    @NotNull
    public static GoDecodedString decode(@NotNull String chars) {
        if (chars == null) {
            GoStringUtil.$$$reportNull$$$0(8);
        }
        int[] offsets = new int[chars.length() + 1];
        offsets[chars.length()] = -1;
        StringBuilder outChars = new StringBuilder();
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = i;
            }
            return new GoDecodedString(true, offsets, outChars.toString());
        }
        int index = 0;
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            offsets[outChars.length()] = index - 1;
            offsets[outChars.length() + 1] = index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return new GoDecodedString(false, offsets, outChars.toString());
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'a': {
                    outChars.append('\u0007');
                    break;
                }
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case '\n': 
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'v': {
                    outChars.append('\u000b');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '\'': {
                    outChars.append('\'');
                    break;
                }
                case '\"': {
                    outChars.append('\"');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'x': {
                    int v;
                    if (index + 2 <= chars.length()) {
                        try {
                            v = Integer.parseInt(chars.substring(index, index + 2), 16);
                            outChars.append((char)v);
                            index += 2;
                            break;
                        }
                        catch (Exception e) {
                            return new GoDecodedString(false, offsets, outChars.toString());
                        }
                    }
                    return new GoDecodedString(false, offsets, outChars.toString());
                }
                case 'u': {
                    int v;
                    if (index + 4 <= chars.length()) {
                        try {
                            v = Integer.parseInt(chars.substring(index, index + 4), 16);
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return new GoDecodedString(false, offsets, outChars.toString());
                            }
                            outChars.append((char)v);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return new GoDecodedString(false, offsets, outChars.toString());
                        }
                    }
                    return new GoDecodedString(false, offsets, outChars.toString());
                }
                case 'U': {
                    int v;
                    if (index + 8 <= chars.length()) {
                        try {
                            v = Integer.parseInt(chars.substring(index, index + 8), 16);
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return new GoDecodedString(false, offsets, outChars.toString());
                            }
                            outChars.append((char)v);
                            index += 8;
                            break;
                        }
                        catch (Exception e) {
                            return new GoDecodedString(false, offsets, outChars.toString());
                        }
                    }
                    return new GoDecodedString(false, offsets, outChars.toString());
                }
                default: {
                    return new GoDecodedString(false, offsets, outChars.toString());
                }
            }
            offsets[outChars.length()] = --index;
        }
        return new GoDecodedString(true, offsets, outChars.toString());
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        return s != null ? s : "";
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            GoStringUtil.$$$reportNull$$$0(9);
        }
        String string = s != null ? s : defaultValue;
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return s != null && !s.isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            GoStringUtil.$$$reportNull$$$0(11);
        }
        if (prefix == null) {
            GoStringUtil.$$$reportNull$$$0(12);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                GoStringUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            GoStringUtil.$$$reportNull$$$0(15);
        }
        if (suffix == null) {
            GoStringUtil.$$$reportNull$$$0(16);
        }
        if (s.endsWith(suffix)) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                GoStringUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string) {
        int index;
        if (string == null) {
            GoStringUtil.$$$reportNull$$$0(19);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            GoStringUtil.$$$reportNull$$$0(20);
        }
        return string2;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String unquoteStringLiteralExpression(@Nullable String elementText) {
        if (GoStringUtil.isStringLiteralExpression(elementText)) {
            return elementText.substring(1, elementText.length() - 1);
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isStringLiteralExpression(@Nullable String elementText) {
        if (elementText == null || elementText.length() <= 1) {
            return false;
        }
        char firstChar = elementText.charAt(0);
        return (firstChar == '`' || firstChar == '\"') && elementText.charAt(elementText.length() - 1) == firstChar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/utils/GoStringUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringContent";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/utils/GoStringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleLineString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSingleLineString";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GoDecodedString {
        public final boolean correct;
        public final int @NotNull [] offsets;
        @NotNull
        public final String unescapedString;

        public GoDecodedString(boolean correct, int @NotNull [] offsets, @NotNull String unescapedString) {
            if (unescapedString == null) {
                GoDecodedString.$$$reportNull$$$0(0);
            }
            if (offsets == null) {
                GoDecodedString.$$$reportNull$$$0(1);
            }
            this.correct = correct;
            this.offsets = offsets;
            this.unescapedString = unescapedString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unescapedString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsets";
                    break;
                }
            }
            objectArray[1] = "com/goide/utils/GoStringUtil$GoDecodedString";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

