/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.Value;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GoZeroValue {
    FALSE("false"),
    ZERO("0"),
    EMPTY_STRING("\"\""),
    NIL("nil"),
    EMPTY_LITERAL(null);

    private final String myText;

    private GoZeroValue(String text) {
        this.myText = text;
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    @Contract(value="null -> null")
    public static GoZeroValue of(@Nullable GoType type) {
        GoType underlyingType;
        GoType defaultType = GoTypeUtil.getDefaultType(type);
        GoType goType = underlyingType = defaultType != null ? defaultType.getContextlessUnderlyingType() : null;
        if (underlyingType == null) {
            return null;
        }
        if (underlyingType instanceof GoLightType.LightVoidType) {
            return NIL;
        }
        if (GoTypeUtil.isNumericType(underlyingType, null)) {
            return ZERO;
        }
        if (GoTypeUtil.isString(underlyingType, null)) {
            return EMPTY_STRING;
        }
        if (GoTypeUtil.isBoolean(underlyingType, null)) {
            return FALSE;
        }
        boolean isSlice = underlyingType instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)underlyingType).isArray();
        return isSlice || PsiTreeUtil.instanceOf((Object)underlyingType, (Class[])new Class[]{GoPointerType.class, GoFunctionType.class, GoInterfaceType.class, GoChannelType.class, GoMapType.class}) ? NIL : EMPTY_LITERAL;
    }

    @NotNull
    public static String getText(@Nullable GoType type, @NotNull String defaultValue) {
        GoZeroValue zeroValue;
        if (defaultValue == null) {
            GoZeroValue.$$$reportNull$$$0(0);
        }
        String string = (String)ObjectUtils.notNull((Object)((zeroValue = GoZeroValue.of(type)) != null ? zeroValue.getText() : null), (Object)defaultValue);
        if (string == null) {
            GoZeroValue.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isZeroValue(@Nullable GoExpression expr, @Nullable GoType type) {
        if (expr == null || type == null) {
            return false;
        }
        GoZeroValue zeroValue = GoZeroValue.of(type);
        if (zeroValue == null) {
            return false;
        }
        return switch (zeroValue) {
            default -> throw new IncompatibleClassChangeError();
            case FALSE -> expr.textMatches("false");
            case ZERO -> {
                Long longValue;
                Value value = expr instanceof GoLiteral ? expr.getValue() : null;
                Long v1 = longValue = value != null ? value.getInteger() : null;
                if (longValue != null && longValue == 0L) {
                    yield true;
                }
                yield false;
            }
            case EMPTY_STRING -> {
                if (expr.textMatches("\"\"") || expr.textMatches("``")) {
                    yield true;
                }
                yield false;
            }
            case NIL -> expr.textMatches("nil");
            case EMPTY_LITERAL -> {
                GoLiteralValue literalValue = (GoLiteralValue)ObjectUtils.doIfCast((Object)expr, GoCompositeLit.class, GoCompositeLit::getLiteralValue);
                if (literalValue != null && literalValue.getElementList().isEmpty() && GoTypeUtil.isAssignable(type, expr, false)) {
                    yield true;
                }
                yield false;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoZeroValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoZeroValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

