/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoTypes;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class GoImportsSorter {
    private static final Logger LOG = Logger.getInstance(GoImportsSorter.class);
    private static final Comparator<GoImportSpec> COMPARATOR = (o1, o2) -> {
        int path = Comparing.compare((Comparable)((Object)o1.getPath()), (Comparable)((Object)o2.getPath()));
        return path != 0 ? path : Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
    };
    @NotNull
    private final Set<String> myPredefinedSdkImportPaths;
    @NotNull
    private final GoFile myFile;
    @NotNull
    private final GoCodeStyleSettings.ImportSorting mySortingType;
    private final boolean myGroupStdlib;
    private final boolean mySingleDeclaration;
    private final boolean mySingleStdlibSubGroup;
    private final boolean myCreateLocalGroup;
    private final GoCodeStyleSettings.LocalGroupMode myLocalGroupMode;
    private final Set<String> myLocalPackagePrefixes;

    @NotNull
    public static GoImportsSorter forFile(@NotNull GoFile file) {
        if (file == null) {
            GoImportsSorter.$$$reportNull$$$0(0);
        }
        GoCodeStyleSettings settings = GoCodeStyleSettings.getSettings((PsiFile)file);
        return new GoImportsSorter(file, settings.IMPORT_SORTING, settings.GROUP_STDLIB_IMPORTS, settings.MOVE_ALL_IMPORTS_IN_ONE_DECLARATION, settings.MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP, Collections.emptySet(), settings.CREATE_LOCAL_GROUP, settings.LOCAL_GROUP_MODE, settings.LOCAL_PACKAGE_PREFIXES);
    }

    public GoImportsSorter(@NotNull GoFile file, @NotNull GoCodeStyleSettings.ImportSorting sortingType, boolean groupStdlib, boolean singleDeclaration, boolean singleStdlibSubGroup, @NotNull Set<String> predefinedSdkPaths, boolean createLocalGroup, @NotNull GoCodeStyleSettings.LocalGroupMode localGroupMode, @Nullable String localPackagePrefixes) {
        if (file == null) {
            GoImportsSorter.$$$reportNull$$$0(1);
        }
        if (sortingType == null) {
            GoImportsSorter.$$$reportNull$$$0(2);
        }
        if (predefinedSdkPaths == null) {
            GoImportsSorter.$$$reportNull$$$0(3);
        }
        if (localGroupMode == null) {
            GoImportsSorter.$$$reportNull$$$0(4);
        }
        this.myPredefinedSdkImportPaths = predefinedSdkPaths;
        this.myFile = file;
        this.mySortingType = sortingType;
        this.myGroupStdlib = groupStdlib;
        this.mySingleDeclaration = singleDeclaration;
        this.mySingleStdlibSubGroup = singleStdlibSubGroup;
        this.myCreateLocalGroup = createLocalGroup;
        this.myLocalGroupMode = localGroupMode;
        this.myLocalPackagePrefixes = !StringUtil.isEmpty((String)localPackagePrefixes) ? new HashSet(ContainerUtil.map((Collection)StringUtil.split((String)localPackagePrefixes, (String)","), it -> it.trim())) : Collections.emptySet();
    }

    public void sortImports() {
        if (this.mySortingType == GoCodeStyleSettings.ImportSorting.NONE || this.myFile.getImports().isEmpty()) {
            return;
        }
        if (this.mySingleDeclaration) {
            this.moveImportSpecsInOneDeclarationAndSort();
            return;
        }
        this.sortImportsInDeclarations();
    }

    @Nullable
    public NewImportInfo findBeforeAnchorForNewImport(@NotNull String importPath) {
        if (importPath == null) {
            GoImportsSorter.$$$reportNull$$$0(5);
        }
        if (this.mySortingType == GoCodeStyleSettings.ImportSorting.NONE || this.myFile.getImports().isEmpty()) {
            return null;
        }
        List<GoImportDeclaration> declarations = GoImportsSorter.getImportDeclarationsListWithoutCImport(this.myFile.getImportList());
        if (declarations.isEmpty()) {
            return null;
        }
        Project project = this.myFile.getProject();
        GoImportSpec newImport = GoElementFactory.createImportSpec((PsiFile)this.myFile, importPath, null);
        VirtualFile sdkHome = GoSdkUtil.getSdkSources(project, GoUtil.module((PsiElement)this.myFile));
        int rank = this.rankImport(newImport, sdkHome);
        for (GoImportDeclaration declaration : declarations) {
            if (declaration.getImportSpecList().isEmpty()) continue;
            for (List<GoImportSpec> imports : GoImportsSorter.importGroups(declaration)) {
                for (List<GoImportSpec> subGroup : this.splitToSubGroups(imports)) {
                    GoImportSpec firstImport = (GoImportSpec)ContainerUtil.getFirstItem(subGroup);
                    if (firstImport == null) continue;
                    int subGroupRank = this.rankImport(firstImport, sdkHome);
                    if (rank < subGroupRank) {
                        return new NewImportInfo(declaration, GoImportsSorter.beforeAnchor(declaration, firstImport), true);
                    }
                    if (rank != subGroupRank) continue;
                    for (GoImportSpec anImport : subGroup) {
                        if (COMPARATOR.compare(anImport, newImport) <= 0) continue;
                        return new NewImportInfo(declaration, GoImportsSorter.beforeAnchor(declaration, anImport), false);
                    }
                    PsiElement anchor = GoImportsSorter.afterAnchor((GoImportSpec)ContainerUtil.getLastItem(subGroup));
                    return new NewImportInfo(declaration, anchor != null ? anchor.getNextSibling() : null, false);
                }
            }
            return new NewImportInfo(declaration, null, true);
        }
        return null;
    }

    @NotNull
    public @Unmodifiable List<? extends PsiElement> getUnsortedElements() {
        GoImportList importList = this.myFile.getImportList();
        List<GoImportDeclaration> importDeclarationList = GoImportsSorter.getImportDeclarationsListWithoutCImport(importList);
        if (importList == null || this.mySortingType == GoCodeStyleSettings.ImportSorting.NONE || importDeclarationList.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GoImportsSorter.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (this.mySingleDeclaration && importDeclarationList.size() > 1) {
            List list = importList.getImportDeclarationList().stream().flatMap(e -> e.getImportSpecList().stream()).collect(Collectors.toList());
            if (list == null) {
                GoImportsSorter.$$$reportNull$$$0(7);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (GoImportDeclaration declaration : importDeclarationList) {
            List<List<GoImportSpec>> importGroups = GoImportsSorter.importGroups(declaration);
            List<GoImportSpec> regroupedSdkImports = this.regroupAndGetSdkImportsIfNeeded(importGroups);
            if (!regroupedSdkImports.isEmpty()) {
                List<GoImportSpec> list = regroupedSdkImports;
                if (list == null) {
                    GoImportsSorter.$$$reportNull$$$0(8);
                }
                return list;
            }
            for (List<GoImportSpec> imports : importGroups) {
                if (this.isSorted(imports)) continue;
                result.addAll(imports);
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoImportsSorter.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private @Unmodifiable List<GoImportSpec> regroupAndGetSdkImportsIfNeeded(@NotNull @Unmodifiable List<List<GoImportSpec>> importGroups) {
        if (importGroups == null) {
            GoImportsSorter.$$$reportNull$$$0(10);
        }
        if (!this.myGroupStdlib || !this.mySingleStdlibSubGroup) {
            return Collections.emptyList();
        }
        VirtualFile sdkHome = GoSdkUtil.getSdkSources(this.myFile.getProject(), GoUtil.module((PsiElement)this.myFile));
        if (sdkHome == null && this.myPredefinedSdkImportPaths.isEmpty()) {
            return Collections.emptyList();
        }
        boolean regrouped = false;
        SmartList sdkGroup = new SmartList();
        for (List<GoImportSpec> group : importGroups) {
            boolean sdkGroupBefore = false;
            GoImportSpec firstSpec = (GoImportSpec)ContainerUtil.getFirstItem(group);
            if (!regrouped && !sdkGroup.isEmpty() && firstSpec != null) {
                GoImportSpec lastSdkSpec = (GoImportSpec)sdkGroup.get(sdkGroup.size() - 1);
                sdkGroupBefore = !this.isSdkImport(firstSpec, sdkHome) || GoImportsSorter.hasEmptyLineBetween(lastSdkSpec, firstSpec, true);
            }
            boolean sdkImports = false;
            boolean nonSdkImports = false;
            Iterator<GoImportSpec> iterator = group.iterator();
            while (iterator.hasNext()) {
                GoImportSpec spec = iterator.next();
                if (this.isSdkImport(spec, sdkHome)) {
                    iterator.remove();
                    sdkGroup.add(spec);
                    sdkImports = true;
                    continue;
                }
                nonSdkImports = true;
            }
            if (!sdkImports || !sdkGroupBefore && !nonSdkImports) continue;
            regrouped = true;
        }
        return regrouped || !this.isSorted((List<GoImportSpec>)sdkGroup) ? sdkGroup : Collections.emptyList();
    }

    private static boolean hasEmptyLineBetween(@NotNull PsiElement element1, @NotNull PsiElement element2, boolean commentResetsEmptyLines) {
        if (element1 == null) {
            GoImportsSorter.$$$reportNull$$$0(11);
        }
        if (element2 == null) {
            GoImportsSorter.$$$reportNull$$$0(12);
        }
        int newLineCount = 0;
        for (PsiElement element = element1.getNextSibling(); element != null && element != element2; element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace) {
                if ((newLineCount += StringUtil.countChars((CharSequence)element.getText(), (char)'\n')) <= 1) continue;
                return true;
            }
            if (element instanceof PsiComment) {
                if (!commentResetsEmptyLines) continue;
                newLineCount = 0;
                continue;
            }
            if (element.getNode().getElementType() == GoTypes.SEMICOLON) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static @Unmodifiable List<GoImportDeclaration> getImportDeclarationsListWithoutCImport(@Nullable GoImportList importList) {
        if (importList == null) {
            List<GoImportDeclaration> list = Collections.emptyList();
            if (list == null) {
                GoImportsSorter.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = ContainerUtil.filter(importList.getImportDeclarationList(), declaration -> {
            List<GoImportSpec> specList = declaration.getImportSpecList();
            if (specList.size() == 1) {
                GoImportSpec spec = (GoImportSpec)ContainerUtil.getFirstItem(specList);
                return spec == null || !spec.isCImport();
            }
            return true;
        });
        if (list == null) {
            GoImportsSorter.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static List<List<GoImportSpec>> importGroups(@NotNull GoImportDeclaration declaration) {
        List<GoImportSpec> imports;
        if (declaration == null) {
            GoImportsSorter.$$$reportNull$$$0(15);
        }
        if ((imports = declaration.getImportSpecList()).size() <= 1) {
            return new SmartList(imports);
        }
        ArrayList<List<GoImportSpec>> result = new ArrayList<List<GoImportSpec>>();
        SmartList currentList = new SmartList();
        GoImportSpec prevImport = null;
        for (GoImportSpec anImport : imports) {
            if (prevImport != null && GoImportsSorter.hasEmptyLineBetween(prevImport, anImport, false) && !currentList.isEmpty()) {
                result.add((List<GoImportSpec>)currentList);
                currentList = new SmartList();
            }
            currentList.add(anImport);
            prevImport = anImport;
        }
        if (!currentList.isEmpty()) {
            result.add((List<GoImportSpec>)currentList);
        }
        result.removeIf(List::isEmpty);
        ArrayList<List<GoImportSpec>> arrayList = result;
        if (arrayList == null) {
            GoImportsSorter.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private boolean isSorted(@NotNull List<GoImportSpec> importsGroup) {
        if (importsGroup == null) {
            GoImportsSorter.$$$reportNull$$$0(17);
        }
        if (importsGroup.size() < 2) {
            return true;
        }
        if (this.splitToSubGroups(importsGroup).size() > 1) {
            return false;
        }
        for (int i = 1; i < importsGroup.size(); ++i) {
            if (COMPARATOR.compare(importsGroup.get(i - 1), importsGroup.get(i)) <= 0) continue;
            return false;
        }
        return true;
    }

    private void sortImportsInDeclarations() {
        GoImportList importList = this.myFile.getImportList();
        List<GoImportDeclaration> declarations = GoImportsSorter.getImportDeclarationsListWithoutCImport(importList);
        if (declarations.isEmpty()) {
            return;
        }
        for (GoImportDeclaration declaration : declarations) {
            this.sortImportDeclaration(declaration);
        }
        if (importList != null) {
            CodeEditUtil.markToReformat((ASTNode)importList.getNode(), (boolean)true);
        }
    }

    private void moveImportSpecsInOneDeclarationAndSort() {
        GoImportList importList = this.myFile.getImportList();
        if (importList == null) {
            return;
        }
        List<GoImportDeclaration> declarations = GoImportsSorter.getImportDeclarationsListWithoutCImport(importList);
        GoImportDeclaration declaration = (GoImportDeclaration)ContainerUtil.getFirstItem(declarations);
        if (declaration == null) {
            return;
        }
        for (GoImportDeclaration oldDeclaration : declarations) {
            if (declaration == oldDeclaration) continue;
            for (GoImportSpec importSpec : oldDeclaration.getImportSpecList()) {
                GoImportSpec newImportSpec = declaration.addImportSpec(importSpec.getPath(), importSpec.getAlias(), null);
                GoImportDeclaration newDeclaration = (GoImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)newImportSpec, GoImportDeclaration.class);
                if (newDeclaration != null) {
                    declaration = newDeclaration;
                    continue;
                }
                LOG.error("Cannot create import declaration. ImportList: " + importList.getText());
            }
            oldDeclaration.delete();
        }
        CodeEditUtil.markToReformat((ASTNode)importList.getNode(), (boolean)true);
        this.sortImportDeclaration(declaration);
    }

    private void sortImportDeclaration(@NotNull GoImportDeclaration declaration) {
        GoImportSpec firstItem;
        List<List<GoImportSpec>> importGroups;
        List<GoImportSpec> regroupedSdkImports;
        if (declaration == null) {
            GoImportsSorter.$$$reportNull$$$0(18);
        }
        if (!(regroupedSdkImports = this.regroupAndGetSdkImportsIfNeeded(importGroups = GoImportsSorter.importGroups(declaration))).isEmpty() && (firstItem = (GoImportSpec)ContainerUtil.getFirstItem(declaration.getImportSpecList())) != null) {
            PsiElement newLine = declaration.addBefore(GoElementFactory.createNewLine(declaration.getProject(), 2), GoImportsSorter.beforeAnchor(declaration, firstItem));
            regroupedSdkImports = GoImportsSorter.sortAndReplaceSubGroup(regroupedSdkImports, declaration, newLine);
            for (GoImportSpec sdkImport : regroupedSdkImports) {
                declaration.deleteChildRange(GoImportsSorter.beforeAnchor(declaration, sdkImport), GoImportsSorter.afterAnchor(sdkImport));
            }
        }
        for (List<GoImportSpec> imports : importGroups) {
            if (regroupedSdkImports.isEmpty() && (imports.size() < 2 || this.isSorted(imports))) continue;
            GoImportSpec firstImport = (GoImportSpec)ContainerUtil.getFirstItem(imports);
            GoImportSpec lastImport = (GoImportSpec)ContainerUtil.getLastItem(imports);
            if (firstImport == null || lastImport == null) continue;
            PsiElement firstElement = GoImportsSorter.beforeAnchor(declaration, firstImport);
            PsiElement lastElement = GoImportsSorter.afterAnchor(lastImport);
            this.sortAndReplace(imports, declaration, firstElement);
            declaration.deleteChildRange(firstElement, lastElement);
        }
    }

    private void sortAndReplace(@NotNull List<GoImportSpec> imports, @NotNull GoImportDeclaration declaration, @NotNull PsiElement anchor) {
        if (imports == null) {
            GoImportsSorter.$$$reportNull$$$0(19);
        }
        if (declaration == null) {
            GoImportsSorter.$$$reportNull$$$0(20);
        }
        if (anchor == null) {
            GoImportsSorter.$$$reportNull$$$0(21);
        }
        Collection<List<GoImportSpec>> subGroups = this.splitToSubGroups(imports);
        boolean isFirst = true;
        for (List<GoImportSpec> subGroup : subGroups) {
            if (!isFirst) {
                PsiElement newLine = PsiParserFacade.getInstance((Project)declaration.getProject()).createWhiteSpaceFromText("\n\n");
                declaration.addBefore(newLine, anchor);
            }
            isFirst = false;
            GoImportsSorter.sortAndReplaceSubGroup(subGroup, declaration, anchor);
        }
    }

    private @NotNull @Unmodifiable Collection<@Unmodifiable List<GoImportSpec>> splitToSubGroups(@NotNull List<GoImportSpec> importsGroup) {
        if (importsGroup == null) {
            GoImportsSorter.$$$reportNull$$$0(22);
        }
        if (!this.requireGrouping()) {
            List<List<GoImportSpec>> list = Collections.singletonList(importsGroup);
            if (list == null) {
                GoImportsSorter.$$$reportNull$$$0(23);
            }
            return list;
        }
        VirtualFile sdkHome = GoSdkUtil.getSdkSources(this.myFile.getProject(), GoUtil.module((PsiElement)this.myFile));
        Collection<List<GoImportSpec>> collection = importsGroup.stream().collect(Collectors.groupingBy(importSpec -> this.rankImport((GoImportSpec)importSpec, sdkHome), () -> new TreeMap(Comparing::compare), Collectors.toList())).values();
        if (collection == null) {
            GoImportsSorter.$$$reportNull$$$0(24);
        }
        return collection;
    }

    private int rankImport(@NotNull GoImportSpec importSpec, @Nullable VirtualFile sdkHome) {
        if (importSpec == null) {
            GoImportsSorter.$$$reportNull$$$0(25);
        }
        if (!this.requireGrouping()) {
            return 1;
        }
        String importSpecPath = importSpec.getPath();
        if (this.myGroupStdlib && this.isSdkImport(importSpec, sdkHome)) {
            return 0;
        }
        if (this.myCreateLocalGroup && this.isLocalImport(importSpec)) {
            return 4;
        }
        if (this.mySortingType == GoCodeStyleSettings.ImportSorting.GOIMPORTS) {
            if (importSpecPath.startsWith("appengine")) {
                return 3;
            }
            if (StringUtil.containsChar((String)importSpecPath, (char)'.')) {
                return 2;
            }
        }
        return 1;
    }

    private boolean requireGrouping() {
        return this.mySortingType == GoCodeStyleSettings.ImportSorting.GOIMPORTS || this.myGroupStdlib || this.myCreateLocalGroup;
    }

    private boolean isSdkImport(@NotNull GoImportSpec importSpec, @Nullable VirtualFile sdkHome) {
        if (importSpec == null) {
            GoImportsSorter.$$$reportNull$$$0(26);
        }
        return this.myPredefinedSdkImportPaths.contains(importSpec.getPath()) || sdkHome != null && GoSdkUtil.isSdkImport(importSpec, sdkHome);
    }

    private boolean isLocalImport(@NotNull GoImportSpec importSpec) {
        if (importSpec == null) {
            GoImportsSorter.$$$reportNull$$$0(27);
        }
        if (this.myLocalGroupMode == GoCodeStyleSettings.LocalGroupMode.PREFIX) {
            String importPath = importSpec.getPath();
            for (String localPrefix : this.myLocalPackagePrefixes) {
                if (!importPath.startsWith(localPrefix)) continue;
                return true;
            }
            return false;
        }
        VirtualFile importSpecFile = importSpec.getContainingFile().getVirtualFile();
        VirtualFile importSpecDir = importSpecFile != null ? importSpecFile.getParent() : null;
        Project project = importSpec.getProject();
        HashSet<VirtualFile> rootDirs = new HashSet<VirtualFile>();
        for (Module module : GoSdkUtil.getGoModules(project)) {
            ContainerUtil.addAll(rootDirs, (Object[])ModuleRootManager.getInstance((Module)module).getContentRoots());
        }
        VirtualFile currentFileVendorDir = GoVendoringUtil.findVendorDir(importSpecDir, importSpecFile, rootDirs);
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        for (GoPackage goPackage : importSpec.resolve(GoPsiImplUtil.createContextOnElement((PsiElement)this.myFile))) {
            for (VirtualFile directory : goPackage.getDirectories()) {
                if (!index.isInContent(directory) || !Objects.equals(currentFileVendorDir, GoVendoringUtil.findVendorDir(directory, directory, rootDirs))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static @Unmodifiable List<GoImportSpec> sortAndReplaceSubGroup(@NotNull @Unmodifiable List<GoImportSpec> importsSubGroup, @NotNull GoImportDeclaration declaration, @NotNull PsiElement anchor) {
        if (importsSubGroup == null) {
            GoImportsSorter.$$$reportNull$$$0(28);
        }
        if (declaration == null) {
            GoImportsSorter.$$$reportNull$$$0(29);
        }
        if (anchor == null) {
            GoImportsSorter.$$$reportNull$$$0(30);
        }
        importsSubGroup = ContainerUtil.sorted(importsSubGroup, COMPARATOR);
        StringBuilder newText = new StringBuilder("(\n");
        for (GoImportSpec anImport : importsSubGroup) {
            List<PsiComment> upperComments = GoDocumentationProvider.getUpperComments(anImport);
            if (!upperComments.isEmpty()) {
                StringUtil.join(upperComments, PsiElement::getText, (String)"\n", (StringBuilder)newText);
                newText.append("\n");
            }
            newText.append(anImport.getText());
            StringUtil.join(GoDocumentationProvider.getAfterComments(anImport), PsiElement::getText, (String)" ", (StringBuilder)newText);
            newText.append("\n");
        }
        newText.append(")");
        if (!newText.isEmpty()) {
            String newImportDeclarationText = newText.toString();
            GoImportDeclaration newDeclaration = GoElementFactory.createImportDeclaration(declaration.getProject(), newImportDeclarationText);
            PsiElement lparen = newDeclaration.getLparen();
            PsiElement rparen = newDeclaration.getRparen();
            LOG.assertTrue(rparen != null && lparen != null, (Object)("Something impossible happened. New text: " + newImportDeclarationText));
            declaration.addRangeBefore(lparen.getNextSibling(), rparen.getPrevSibling(), anchor);
        }
        List list = importsSubGroup;
        if (list == null) {
            GoImportsSorter.$$$reportNull$$$0(31);
        }
        return list;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private static PsiElement beforeAnchor(@NotNull GoImportDeclaration declaration, @Nullable GoImportSpec spec) {
        if (declaration == null) {
            GoImportsSorter.$$$reportNull$$$0(32);
        }
        if (spec == null) {
            return null;
        }
        PsiComment firstComment = (PsiComment)ContainerUtil.getFirstItem(GoDocumentationProvider.getUpperComments(spec));
        return firstComment != null && firstComment.getParent() == declaration ? firstComment : spec;
    }

    @Nullable
    private static PsiElement afterAnchor(@Nullable GoImportSpec spec) {
        if (spec == null) {
            return null;
        }
        PsiComment lastComment = (PsiComment)ContainerUtil.getLastItem(GoDocumentationProvider.getAfterComments(spec));
        return (PsiElement)ObjectUtils.notNull((Object)lastComment, (Object)spec);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 13, 14, 16, 23, 24, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedSdkPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localGroupMode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/util/GoImportsSorter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importGroups";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsGroup";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsSubGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/util/GoImportsSorter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsortedElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDeclarationsListWithoutCImport";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "importGroups";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToSubGroups";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndReplaceSubGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBeforeAnchorForNewImport";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 31: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "regroupAndGetSdkImportsIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyLineBetween";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "importGroups";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSorted";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sortImportDeclaration";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sortAndReplace";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "splitToSubGroups";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rankImport";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSdkImport";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLocalImport";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sortAndReplaceSubGroup";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "beforeAnchor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 13, 14, 16, 23, 24, 31 -> new IllegalStateException(string);
        };
    }

    public static final class NewImportInfo {
        @NotNull
        public final GoImportDeclaration declaration;
        @Nullable
        public final PsiElement anchor;
        public final boolean newGroup;

        private NewImportInfo(@NotNull GoImportDeclaration declaration, @Nullable PsiElement anchor, boolean newGroup) {
            if (declaration == null) {
                NewImportInfo.$$$reportNull$$$0(0);
            }
            this.declaration = declaration;
            this.anchor = anchor;
            this.newGroup = newGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/goide/util/GoImportsSorter$NewImportInfo", "<init>"));
        }
    }
}

