/*
 * Decompiled with CFR 0.152.
 */
package com.goide.training.learn.lesson;

import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.training.learn.course.GoLearningCourse;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.quickfix.VgoSyncDependencyFix;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.TaskRuntimeContext;
import training.learn.course.IftModule;
import training.learn.course.KLesson;
import training.util.DataLoader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001cB\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\n\u0010\n\u001a\u00020\u000b*\u00020\fJ\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u00a8\u0006\u001d"}, d2={"Lcom/goide/training/learn/lesson/GoLesson;", "Ltraining/learn/course/KLesson;", "id", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "loadSample", "Ltraining/dsl/LessonSample;", "sampleName", "runManager", "Lcom/intellij/execution/RunManager;", "Ltraining/dsl/TaskRuntimeContext;", "configurations", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "s", "saveCurrentEditorFile", "", "project", "Lcom/intellij/openapi/project/Project;", "applyVgoSyncDependencyFixForCurrentEditorFile", "isGoVersion", "", "direction", "Lcom/goide/training/learn/lesson/GoLesson$ComparisonDirection;", "targetVersion", "Lcom/goide/sdk/GoSdkVersion;", "ComparisonDirection", "intellij.go.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nGoLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLesson.kt\ncom/goide/training/learn/lesson/GoLesson\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n774#2:95\n865#2,2:96\n*S KotlinDebug\n*F\n+ 1 GoLesson.kt\ncom/goide/training/learn/lesson/GoLesson\n*L\n39#1:95\n39#1:96,2\n*E\n"})
public abstract class GoLesson
extends KLesson {
    public GoLesson(@NonNls @NotNull String id, @Nls @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(id, name);
    }

    @NotNull
    public final LessonSample loadSample(@NotNull String sampleName) {
        Intrinsics.checkNotNullParameter((Object)sampleName, (String)"sampleName");
        IftModule iftModule = this.getModule();
        Intrinsics.checkNotNull((Object)iftModule, (String)"null cannot be cast to non-null type com.goide.training.learn.course.GoLearningCourse.GoLearningModule");
        String path = ((GoLearningCourse.GoLearningModule)iftModule).getLessonsPath() + "/" + sampleName;
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        byte[] byArray = ByteStreamsKt.readBytes((InputStream)DataLoader.INSTANCE.getResourceAsStream(path, classLoader));
        Charset charset = Charsets.UTF_8;
        String content2 = new String(byArray, charset);
        return LessonSampleKt.parseLessonSample((String)content2);
    }

    @NotNull
    public final RunManager runManager(@NotNull TaskRuntimeContext $this$runManager) {
        Intrinsics.checkNotNullParameter((Object)$this$runManager, (String)"<this>");
        return RunManager.Companion.getInstance($this$runManager.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RunnerAndConfigurationSettings> configurations(@NotNull TaskRuntimeContext $this$configurations, @NotNull String s) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$configurations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Iterable $this$filter$iv = this.runManager($this$configurations).getAllSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)s, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void saveCurrentEditorFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        ApplicationManager.getApplication().runWriteAction(() -> GoLesson.saveCurrentEditorFile$lambda$1(document2));
    }

    public final void applyVgoSyncDependencyFixForCurrentEditorFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile vFile = virtualFile;
        Module module = GoUtil.module((PsiElement)psiFile2);
        if (module == null) {
            return;
        }
        Module module2 = module;
        VgoModuleOrWorkspace vgoModuleOrWorkspace = VgoModulesRegistry.getInstance(project).findVgoModuleOrWorkspace(module2, vFile);
        if (vgoModuleOrWorkspace == null) {
            return;
        }
        VgoModuleOrWorkspace vgoModuleOrWorkspace2 = vgoModuleOrWorkspace;
        VgoSyncDependencyFix.Action action = VgoSyncDependencyFix.Action.SYNC;
        String string = action.getPresentableName(project, vgoModuleOrWorkspace2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        String presentable = string;
        VgoSyncDependencyFix.applyFix(project, module2, vgoModuleOrWorkspace2, presentable, action);
    }

    public final boolean isGoVersion(@NotNull Project $this$isGoVersion, @NotNull ComparisonDirection direction, @NotNull GoSdkVersion targetVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$isGoVersion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)((Object)targetVersion), (String)"targetVersion");
        GoSdkVersion goSdkVersion = GoSdkService.getInstance($this$isGoVersion).getSdk(null).getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)goSdkVersion), (String)"getMajorVersion(...)");
        GoSdkVersion version = goSdkVersion;
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> {
                if (version.isLessThan(targetVersion) || version == targetVersion) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (version.isAtLeast(targetVersion) || version == targetVersion) {
                    yield true;
                }
                yield false;
            }
            case 3 -> version.isAtLeast(targetVersion);
            case 4 -> version.isLessThan(targetVersion);
            case 5 -> {
                if (version == targetVersion) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void saveCurrentEditorFile$lambda$1(Document $document) {
        FileDocumentManager.getInstance().saveDocument($document);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/goide/training/learn/lesson/GoLesson$ComparisonDirection;", "", "<init>", "(Ljava/lang/String;I)V", "IS_AT_LEAST", "IS_LESS_THAN", "EQUAL", "LESS_OR_EQUAL", "GREATER_OR_EQUAL", "intellij.go.featuresTrainer"})
    public static final class ComparisonDirection
    extends Enum<ComparisonDirection> {
        public static final /* enum */ ComparisonDirection IS_AT_LEAST = new ComparisonDirection();
        public static final /* enum */ ComparisonDirection IS_LESS_THAN = new ComparisonDirection();
        public static final /* enum */ ComparisonDirection EQUAL = new ComparisonDirection();
        public static final /* enum */ ComparisonDirection LESS_OR_EQUAL = new ComparisonDirection();
        public static final /* enum */ ComparisonDirection GREATER_OR_EQUAL = new ComparisonDirection();
        private static final /* synthetic */ ComparisonDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ComparisonDirection[] values() {
            return (ComparisonDirection[])$VALUES.clone();
        }

        public static ComparisonDirection valueOf(String value2) {
            return Enum.valueOf(ComparisonDirection.class, value2);
        }

        @NotNull
        public static EnumEntries<ComparisonDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = comparisonDirectionArray = new ComparisonDirection[]{ComparisonDirection.IS_AT_LEAST, ComparisonDirection.IS_LESS_THAN, ComparisonDirection.EQUAL, ComparisonDirection.LESS_OR_EQUAL, ComparisonDirection.GREATER_OR_EQUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComparisonDirection.values().length];
            try {
                nArray[ComparisonDirection.LESS_OR_EQUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonDirection.GREATER_OR_EQUAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonDirection.IS_AT_LEAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonDirection.IS_LESS_THAN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComparisonDirection.EQUAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

