/*
 * Decompiled with CFR 0.152.
 */
package com.goide.testing;

import com.goide.utils.GoStringUtil;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoTestEvent {
    @SerializedName(value="Action")
    @Nullable
    public String action;
    @SerializedName(value="Package")
    @Nullable
    public String importPath;
    @SerializedName(value="Test")
    @Nullable
    public String testName;
    @SerializedName(value="Elapsed")
    public double elapsed;
    @SerializedName(value="Output")
    @Nullable
    public String output;

    GoTestEvent() {
    }

    @Nullable
    public Action getAction() {
        return Action.from(this.action);
    }

    @Nullable
    public String getNodeId() {
        return this.isTest() ? GoStringUtil.notNullize(this.importPath) + "#" + this.testName : this.importPath;
    }

    @Nullable
    public String getParentNodeId(@Nullable String parentTestName) {
        if (this.isTest()) {
            if (GoStringUtil.isNotEmpty(parentTestName)) {
                return GoStringUtil.notNullize(this.importPath) + "#" + parentTestName;
            }
            return this.importPath;
        }
        return null;
    }

    public boolean isTest() {
        return this.testName != null;
    }

    @NotNull
    public String getPackageLocationString(@NotNull String defaultImportPath) {
        if (defaultImportPath == null) {
            GoTestEvent.$$$reportNull$$$0(0);
        }
        String string = "gotest://" + GoStringUtil.notNullize(this.importPath, defaultImportPath) + "#";
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getTestLocationString(@NotNull String defaultImportPath) {
        if (defaultImportPath == null) {
            GoTestEvent.$$$reportNull$$$0(2);
        }
        String string = this.getPackageLocationString(defaultImportPath) + GoStringUtil.notNullize(this.testName);
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.isTest() ? this.testName : this.importPath;
    }

    @NotNull
    public String getElapsedTime() {
        String string = String.valueOf((int)(this.elapsed * 1000.0));
        if (string == null) {
            GoTestEvent.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isPackage() {
        return this.testName == null && this.importPath != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultImportPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/testing/GoTestEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/testing/GoTestEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageLocationString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLocationString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElapsedTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }

    static enum Action {
        START("start"),
        RUN("run"),
        PASS("pass"),
        SKIP("skip"),
        FAIL("fail"),
        OUTPUT("output"),
        CONT("cont"),
        PAUSE("pause"),
        BUILD_OUTPUT("build-output"),
        BUILD_FAIL("build-fail");

        private final String name;
        private static final Map<String, Action> NAME_MAP;

        private Action(String name) {
            this.name = name;
        }

        boolean isBuildAction() {
            return this == BUILD_OUTPUT || this == BUILD_FAIL;
        }

        static Action from(String name) {
            return NAME_MAP.get(name);
        }

        static {
            NAME_MAP = Arrays.stream(Action.values()).collect(Collectors.toMap(action -> action.name, action -> action));
        }
    }
}

