/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics.errors;

import com.goide.statistics.errors.GoErrorRegexDictionary;
import com.goide.statistics.errors.GoErrorStatisticsUtil;
import com.goide.statistics.errors.GoStatisticsWhiteListsService;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GoProgrammingErrorsStatisticsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("go.programming.errors", 3);
    private static final String COMPILATION_ERROR_MESSAGE = "compilation_error_message";
    private static final EventId1<String> COMPILATION_ERROR_DETECTED = GROUP.registerEvent("compilation.error.detected", (EventField)EventFields.StringValidatedByCustomRule((String)"compilation_error_message", CompilationErrorMessageValidationRule.class));
    private static final Object ourCompilationErrorsStatsLock = new Object();
    private static final String RUNTIME_ERROR_MESSAGE = "runtime_error_message";
    private static final EventId1<String> RUNTIME_ERROR_DETECTED = GROUP.registerEvent("runtime.error.detected", (EventField)EventFields.StringValidatedByCustomRule((String)"runtime_error_message", RuntimeErrorMessageValidationRule.class));
    private static final Object ourRuntimeErrorsStatsLock = new Object();

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void reportCompilationErrors(@NotNull Project project, @NotNull List<String> errorMessages) {
        if (project == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(0);
        }
        if (errorMessages == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(1);
        }
        GoProgrammingErrorsStatisticsCollector.reportErrors(project, errorMessages, GoStatisticsWhiteListsService.getInstance().getCompilationErrorsDictionary(), ourCompilationErrorsStatsLock, COMPILATION_ERROR_DETECTED);
    }

    public static void reportRuntimeErrors(@NotNull Project project, @NotNull List<String> programOutput) {
        if (project == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (programOutput == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(3);
        }
        GoProgrammingErrorsStatisticsCollector.reportErrors(project, programOutput, GoStatisticsWhiteListsService.getInstance().getRuntimeErrorsDictionary(), ourRuntimeErrorsStatsLock, RUNTIME_ERROR_DETECTED);
    }

    private static void reportErrors(@NotNull Project project, @NotNull List<String> rawOutput, @NotNull GoErrorRegexDictionary errorsDictionary, @NotNull Object reportLock, @NotNull EventId1<String> eventId) {
        if (project == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(4);
        }
        if (rawOutput == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(5);
        }
        if (errorsDictionary == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(6);
        }
        if (reportLock == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(7);
        }
        if (eventId == null) {
            GoProgrammingErrorsStatisticsCollector.$$$reportNull$$$0(8);
        }
        if (rawOutput.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<String> validatedErrorMessages = GoErrorStatisticsUtil.errorsToMetricIds(rawOutput, errorsDictionary);
            Object object = reportLock;
            synchronized (object) {
                for (String message : validatedErrorMessages) {
                    eventId.log(project, (Object)message);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "programOutput";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsDictionary";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportLock";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
        }
        objectArray2[1] = "com/goide/statistics/errors/GoProgrammingErrorsStatisticsCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reportCompilationErrors";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportRuntimeErrors";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "reportErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CompilationErrorMessageValidationRule
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return GoProgrammingErrorsStatisticsCollector.COMPILATION_ERROR_MESSAGE;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String compilationError, @NotNull EventContext context) {
            GoErrorRegexDictionary dictionary;
            if (compilationError == null) {
                CompilationErrorMessageValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CompilationErrorMessageValidationRule.$$$reportNull$$$0(1);
            }
            ValidationResultType validationResultType = (dictionary = GoStatisticsWhiteListsService.getInstance().getCompilationErrorsDictionary()).getContents().containsKey(compilationError) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            if (validationResultType == null) {
                CompilationErrorMessageValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compilationError";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/statistics/errors/GoProgrammingErrorsStatisticsCollector$CompilationErrorMessageValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/statistics/errors/GoProgrammingErrorsStatisticsCollector$CompilationErrorMessageValidationRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class RuntimeErrorMessageValidationRule
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return GoProgrammingErrorsStatisticsCollector.RUNTIME_ERROR_MESSAGE;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String runtimeError, @NotNull EventContext context) {
            GoErrorRegexDictionary dictionary;
            if (runtimeError == null) {
                RuntimeErrorMessageValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                RuntimeErrorMessageValidationRule.$$$reportNull$$$0(1);
            }
            ValidationResultType validationResultType = (dictionary = GoStatisticsWhiteListsService.getInstance().getRuntimeErrorsDictionary()).getContents().containsKey(runtimeError) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RuntimeErrorMessageValidationRule.$$$reportNull$$$0(2);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtimeError";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/statistics/errors/GoProgrammingErrorsStatisticsCollector$RuntimeErrorMessageValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/statistics/errors/GoProgrammingErrorsStatisticsCollector$RuntimeErrorMessageValidationRule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

