/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.GoIcons;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.download.GoBasedDownloadingSdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoDownloadingSdk
implements GoSdk,
GoBasedDownloadingSdk<GoSdk> {
    @NotNull
    private final String myVersion;
    @NotNull
    private final GoSdkVersion myMajorVersion;
    @NotNull
    private final String myHomeUrl;
    private volatile boolean myDownloaded;

    public GoDownloadingSdk(@NotNull String version, @NotNull String targetPath) {
        if (version == null) {
            GoDownloadingSdk.$$$reportNull$$$0(0);
        }
        if (targetPath == null) {
            GoDownloadingSdk.$$$reportNull$$$0(1);
        }
        targetPath = StringUtil.trimTrailing((String)targetPath, (char)'/');
        targetPath = StringUtil.trimTrailing((String)targetPath, (char)'\\');
        this.myHomeUrl = VfsUtilCore.pathToUrl((String)FileUtil.join((String[])new String[]{targetPath, version}));
        this.myVersion = StringUtil.trimStart((String)version, (String)"go");
        this.myMajorVersion = GoSdkVersion.fromText(this.myVersion);
    }

    @Override
    @Nullable
    public VirtualFile getSrcDir() {
        return null;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getHomeUrl() {
        String string = this.myHomeUrl;
        if (string == null) {
            GoDownloadingSdk.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getSdkRoot() {
        return VirtualFileManager.getInstance().findFileByUrl(this.myHomeUrl);
    }

    @Override
    @Nullable
    public VirtualFile getExecutable() {
        return null;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getRootsToAttach() {
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            GoDownloadingSdk.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return GoIcons.ICON;
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            GoDownloadingSdk.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public GoSdkVersion getMajorVersion() {
        GoSdkVersion goSdkVersion = this.myMajorVersion;
        if (goSdkVersion == null) {
            GoDownloadingSdk.$$$reportNull$$$0(5);
        }
        return goSdkVersion;
    }

    @Override
    @Nullable
    public String getVersionFilePath() {
        return null;
    }

    @Override
    @NotNull
    public GoSdk toLocalSdk() {
        GoSdk goSdk = GoSdk.fromUrl(this.myHomeUrl, true);
        if (goSdk == null) {
            GoDownloadingSdk.$$$reportNull$$$0(6);
        }
        return goSdk;
    }

    @Override
    public boolean isDownloaded() {
        return this.myDownloaded;
    }

    @Override
    public void setDownloaded(boolean downloaded) {
        this.myDownloaded = downloaded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoDownloadingSdk sdk = (GoDownloadingSdk)o;
        return this.myVersion.equals(sdk.myVersion) && this.myHomeUrl.equals(sdk.myHomeUrl);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion, this.myHomeUrl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/download/GoDownloadingSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/download/GoDownloadingSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToAttach";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorVersion";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

