/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.download;

import com.goide.execution.GoWslUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.download.GoDownloadSdkQueryService;
import com.goide.util.GoUtil;
import com.goide.vgo.EnvironmentVariable;
import com.goide.vgo.VgoUtilKt;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\n\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"REGULAR_URL", "", "CHINESE_URL", "getLatestGoSdkVersion", "Lcom/goide/sdk/GoSdkVersion;", "project", "Lcom/intellij/openapi/project/Project;", "includeAll", "", "getBaseUrl", "isInMainlandChina", "getFileExtension", "os", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoDownloadSdkQueryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDownloadSdkQueryService.kt\ncom/goide/sdk/download/GoDownloadSdkQueryServiceKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n40#2,3:151\n1563#3:154\n1634#3,3:155\n*S KotlinDebug\n*F\n+ 1 GoDownloadSdkQueryService.kt\ncom/goide/sdk/download/GoDownloadSdkQueryServiceKt\n*L\n53#1:151,3\n56#1:154\n56#1:155,3\n*E\n"})
public final class GoDownloadSdkQueryServiceKt {
    @NotNull
    private static final String REGULAR_URL = "https://go.dev/dl";
    @NotNull
    private static final String CHINESE_URL = "https://golang.google.cn/dl";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final GoSdkVersion getLatestGoSdkVersion(@Nullable Project project, boolean includeAll) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        WSLDistribution wsl = GoWslUtil.getWsl(project);
        if (wsl != null) {
            string = "linux";
        } else {
            String string2 = GoUtil.systemOS();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemOS(...)");
        }
        String os = string;
        String string3 = GoUtil.systemArch();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"systemArch(...)");
        String arch = string3;
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        boolean $i$f$service22 = false;
        Class<GoDownloadSdkQueryService> serviceClass$iv = GoDownloadSdkQueryService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Iterable $i$f$service22 = (GoDownloadSdkQueryService)object.new GoDownloadSdkQueryService.QueryExecutor(project, (ProgressIndicator)indicator).getVersionsForPlatform(os, arch, includeAll);
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GoSdkVersion.fromText(StringsKt.substringAfter$default((String)it, (String)"go", null, (int)2, null)));
        }
        List versions = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        return (GoSdkVersion)((Object)CollectionsKt.lastOrNull((List)versions));
    }

    private static final String getBaseUrl(Project project) {
        return GoDownloadSdkQueryServiceKt.isInMainlandChina(project) ? CHINESE_URL : REGULAR_URL;
    }

    private static final boolean isInMainlandChina(Project project) {
        Regex chineseGoProxyRegex = new Regex("^(https://[^,]+\\.cn)(,direct)?$");
        String string = VgoEnvironmentVariable.GOPROXY.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EnvironmentVariable goProxy = VgoUtilKt.getVariableFromEnvironment(project, string);
        Object object = goProxy;
        boolean useChineseGoProxy = object != null && (object = ((EnvironmentVariable)object).getValue()) != null ? chineseGoProxyRegex.matches((CharSequence)object) : false;
        return useChineseGoProxy || VgoUtilKt.isMainlandChinaRegion();
    }

    @NotNull
    public static final String getFileExtension(@NotNull String os) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        return Intrinsics.areEqual((Object)"windows", (Object)os) ? ".zip" : ".tar.gz";
    }

    public static final /* synthetic */ String access$getBaseUrl(Project project) {
        return GoDownloadSdkQueryServiceKt.getBaseUrl(project);
    }
}

