/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.util;

import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoResolvable;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoReferenceConverter {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final GoFile context;
    @Nullable
    private final String contextPackageName;
    @Nullable
    private final String contextImportPath;
    private final boolean vendoringEnabled;
    @NotNull
    private Collection<? extends PsiElement> elementsToSkip;
    @Nullable
    private String packageName;
    @Nullable
    private String importPath;

    private GoReferenceConverter(@NotNull PsiElement element, @NotNull GoFile context) {
        if (element == null) {
            GoReferenceConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoReferenceConverter.$$$reportNull$$$0(1);
        }
        this.elementsToSkip = Collections.emptyList();
        this.element = element;
        this.context = context;
        this.vendoringEnabled = GoVendoringUtil.isVendoringEnabled(element);
        this.contextPackageName = context.getPackageName();
        this.contextImportPath = context.getImportPath(this.vendoringEnabled);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GoReferenceConverter on(@NotNull PsiElement element, @NotNull GoFile context) {
        if (element == null) {
            GoReferenceConverter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoReferenceConverter.$$$reportNull$$$0(3);
        }
        return new GoReferenceConverter(element, context);
    }

    @Contract(value="_ -> this")
    @NotNull
    public GoReferenceConverter withElementsToSkip(@NotNull Collection<? extends PsiElement> elementsToSkip) {
        if (elementsToSkip == null) {
            GoReferenceConverter.$$$reportNull$$$0(4);
        }
        this.elementsToSkip = elementsToSkip;
        GoReferenceConverter goReferenceConverter = this;
        if (goReferenceConverter == null) {
            GoReferenceConverter.$$$reportNull$$$0(5);
        }
        return goReferenceConverter;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public GoReferenceConverter withPackageNameAndImportPath(@Nullable String packageName, @Nullable String importPath) {
        this.packageName = packageName;
        this.importPath = importPath;
        GoReferenceConverter goReferenceConverter = this;
        if (goReferenceConverter == null) {
            GoReferenceConverter.$$$reportNull$$$0(6);
        }
        return goReferenceConverter;
    }

    @NotNull
    public String getText() {
        final StringBuilder newText = new StringBuilder();
        this.element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement o) {
                GoReferenceExpressionBase expression;
                PsiElement resolve;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (o instanceof GoReferenceExpressionBase && ((resolve = GoReferenceConverter.resolve(expression = (GoReferenceExpressionBase)o)) == null || !ContainerUtil.exists(GoReferenceConverter.this.elementsToSkip, e -> PsiTreeUtil.isAncestor((PsiElement)e, (PsiElement)resolve, (boolean)false)))) {
                    String path = GoReferenceConverter.this.getImportPath(resolve);
                    String packageName = GoReferenceConverter.this.getPackageName(resolve);
                    if (path != null && packageName != null) {
                        boolean inSamePackage = path.equals(GoReferenceConverter.this.contextImportPath) && packageName.equals(GoReferenceConverter.this.contextPackageName);
                        String qualifier = GoReferenceConverter.this.importPackageIfNeeded(expression, inSamePackage ? "" : path);
                        if (!qualifier.isEmpty()) {
                            newText.append(qualifier).append('.');
                        }
                        newText.append(resolve instanceof GoPackage.GoPomTargetPsiElement || resolve instanceof GoImportSpec ? expression.getIdentifier().getText() : expression.getText());
                        return;
                    }
                }
                if (o instanceof LeafElement) {
                    newText.append(o.getText());
                }
                super.visitElement(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/refactor/util/GoReferenceConverter$1", "visitElement"));
            }
        });
        String string = newText.toString();
        if (string == null) {
            GoReferenceConverter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static PsiElement resolve(@NotNull GoReferenceExpressionBase expression) {
        GoResolvable resolvable;
        if (expression == null) {
            GoReferenceConverter.$$$reportNull$$$0(8);
        }
        if ((resolvable = expression.getResolvableQualifier()) == null) {
            resolvable = GoPsiUtil.notQualified(expression) ? expression : null;
        } else if (resolvable instanceof GoReferenceExpressionBase && ((GoReferenceExpressionBase)resolvable).getResolvableQualifier() != null) {
            resolvable = null;
        }
        return resolvable != null ? resolvable.resolve() : null;
    }

    @Nullable
    private String getImportPath(@Nullable PsiElement resolve) {
        if (this.importPath != null) {
            return this.importPath;
        }
        if (resolve instanceof GoImportSpec) {
            return ((GoImportSpec)resolve).getPath();
        }
        if (resolve instanceof GoPackage.GoPomTargetPsiElement) {
            return ((GoPackage.GoPomTargetPsiElement)resolve).getTarget().getImportPath(this.vendoringEnabled);
        }
        if (resolve != null && !(resolve instanceof GoFieldDefinition) && !GoPsiImplUtil.builtin(resolve)) {
            return (String)ObjectUtils.doIfCast((Object)resolve.getContainingFile(), GoFile.class, file -> file.getImportPath(this.vendoringEnabled));
        }
        return null;
    }

    @Nullable
    private String getPackageName(@Nullable PsiElement resolve) {
        if (this.packageName != null) {
            return this.packageName;
        }
        if (resolve instanceof GoImportSpec) {
            return GoPsiImplUtil.sanitizePackageName(((GoImportSpec)resolve).getPath());
        }
        if (resolve instanceof GoPackage.GoPomTargetPsiElement) {
            return ((GoPackage.GoPomTargetPsiElement)resolve).getTarget().getName();
        }
        if (resolve != null) {
            return (String)ObjectUtils.doIfCast((Object)resolve.getContainingFile(), GoFile.class, GoFile::getPackageName);
        }
        return null;
    }

    private String importPackageIfNeeded(@NotNull PsiElement expression, @NotNull String importPath) {
        if (expression == null) {
            GoReferenceConverter.$$$reportNull$$$0(9);
        }
        if (importPath == null) {
            GoReferenceConverter.$$$reportNull$$$0(10);
        }
        LinkedHashSet<String> existingNames = GoNameSuggestionProvider.getNamesInContext(expression);
        GoFile originalFile = (GoFile)((Object)ObjectUtils.tryCast((Object)expression.getContainingFile(), GoFile.class));
        if (originalFile != null && originalFile != this.context) {
            existingNames.removeAll(GoReferenceConverter.getSubstitutionContextFileOrOriginalFile(originalFile).getImportMap().keySet());
        }
        existingNames.addAll(this.context.getImportMap().keySet());
        if (this.contextPackageName != null) {
            existingNames.add(this.contextPackageName);
        }
        return GoRefactoringUtil.importPackageIfNeeded(this.context, importPath, existingNames);
    }

    @NotNull
    private static GoFile getSubstitutionContextFileOrOriginalFile(@NotNull GoFile originalFile) {
        if (originalFile == null) {
            GoReferenceConverter.$$$reportNull$$$0(11);
        }
        GoFile file = null;
        PsiElement substitutionContext = GoReferenceBase.getSubstitutionContext((PsiElement)originalFile);
        if (substitutionContext != null) {
            file = (GoFile)((Object)ObjectUtils.tryCast((Object)substitutionContext.getContainingFile(), GoFile.class));
        }
        GoFile goFile = (GoFile)((Object)ObjectUtils.notNull(file, (Object)((Object)originalFile)));
        if (goFile == null) {
            GoReferenceConverter.$$$reportNull$$$0(12);
        }
        return goFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToSkip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/util/GoReferenceConverter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/util/GoReferenceConverter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withElementsToSkip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withPackageNameAndImportPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionContextFileOrOriginalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "on";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withElementsToSkip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importPackageIfNeeded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionContextFileOrOriginalFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 12 -> new IllegalStateException(string);
        };
    }
}

